/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos;

import io.meeds.kernel.test.AbstractSpringTest;
import io.meeds.kernel.test.KernelExtension;
import io.meeds.kudos.dao.KudosDAO;
import io.meeds.kudos.entity.KudosEntity;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.model.KudosEntityType;
import io.meeds.kudos.service.utils.Utils;
import java.time.LocalDate;
import java.time.ZoneId;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class, KernelExtension.class})
@SpringBootApplication(scanBasePackages={"io.meeds.kudos", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa", "io.meeds.spring.liquibase", "io.meeds.spring.web"})
@EnableJpaRepositories(basePackages={"io.meeds.kudos"})
@TestPropertySource(properties={"spring.liquibase.change-log=classpath:db/changelog/kudos-rdbms.db.changelog-master.xml", "spring.profiles.active=gamification"})
@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/kudos-test-configuration.xml")})
public abstract class BaseKudosTest
extends AbstractSpringTest {
    public static final String MODULE_NAME = "io.meeds.kudos";
    public static final String CHANGELOG_PATH = "classpath:db/changelog/kudos-rdbms.db.changelog-master.xml";
    protected KudosEntityType kudosEntityType = KudosEntityType.USER_TIPTIP;
    protected int entityType = this.kudosEntityType.ordinal();
    protected long entityId = 1L;
    protected long parentEntityId = 2L;
    protected long receiverId = 3L;
    protected long senderId = 4L;
    protected long createdTimestamp = System.currentTimeMillis() / 1000L;
    protected String message = "message";

    @BeforeEach
    public void setUp() {
        this.getContainer();
        this.begin();
    }

    @AfterEach
    public void tearDown() {
        if (this.getKudosDAO() != null) {
            this.restartTransaction();
            this.getKudosDAO().deleteAll();
        }
        this.end();
    }

    public KudosDAO getKudosDAO() {
        return (KudosDAO)this.getContainer().getComponentInstanceOfType(KudosDAO.class);
    }

    protected Kudos newKudosDTO() {
        KudosEntity entity = this.newKudosInstance(this.parentEntityId, this.entityId, this.entityType, this.receiverId, this.senderId, this.createdTimestamp, this.message);
        return Utils.fromEntity((KudosEntity)entity);
    }

    protected KudosEntity newKudos() {
        return this.newKudos(this.parentEntityId, this.entityId, this.entityType, this.receiverId, this.senderId, this.createdTimestamp, this.message);
    }

    protected KudosEntity newKudosInstance() {
        return this.newKudosInstance(this.parentEntityId, this.entityId, this.entityType, this.receiverId, this.senderId, this.createdTimestamp, this.message);
    }

    protected KudosEntity newKudos(long parentEntityId, long entityId, int entityType, long receiverId, long senderId, long createdTimestamp, String message) {
        Assertions.assertNotNull((Object)this.getKudosDAO());
        KudosEntity kudosEntity = this.newKudosInstance(parentEntityId, entityId, entityType, receiverId, senderId, createdTimestamp, message);
        return (KudosEntity)this.getKudosDAO().save((Object)kudosEntity);
    }

    private KudosEntity newKudosInstance(long parentEntityId, long entityId, int entityType, long receiverId, long senderId, long createdTimestamp, String message) {
        KudosEntity kudosEntity = new KudosEntity();
        kudosEntity.setEntityId(entityId);
        kudosEntity.setEntityType(entityType);
        kudosEntity.setMessage(message);
        kudosEntity.setParentEntityId(Long.valueOf(parentEntityId));
        kudosEntity.setReceiverId(receiverId);
        kudosEntity.setReceiverUser(true);
        kudosEntity.setSenderId(senderId);
        kudosEntity.setCreatedDate(createdTimestamp);
        return kudosEntity;
    }

    protected void compareResults(KudosEntity kudosEntity, Kudos kudos) {
        Assertions.assertEquals((long)kudosEntity.getActivityId(), (long)kudos.getActivityId());
        Assertions.assertEquals((long)kudosEntity.getCreatedDate(), (long)kudos.getTimeInSeconds());
        Assertions.assertEquals((Object)String.valueOf(kudosEntity.getEntityId()), (Object)kudos.getEntityId());
        Assertions.assertEquals((int)kudosEntity.getEntityType(), (int)KudosEntityType.valueOf((String)kudos.getEntityType()).ordinal());
        Assertions.assertEquals((Long)kudosEntity.getId(), (Long)kudos.getTechnicalId());
        Assertions.assertEquals((Object)kudosEntity.getMessage(), (Object)kudos.getMessage());
        Assertions.assertEquals((Object)String.valueOf(kudosEntity.getParentEntityId()), (Object)kudos.getParentEntityId());
        Assertions.assertEquals((Object)String.valueOf(kudosEntity.getReceiverId()), (Object)kudos.getReceiverIdentityId());
        Assertions.assertEquals((Object)String.valueOf(kudosEntity.getSenderId()), (Object)kudos.getSenderIdentityId());
    }

    protected long getTime(int year, int month, int day) {
        return LocalDate.of(year, month, day).atStartOfDay(ZoneId.systemDefault()).toEpochSecond();
    }

    protected long getCurrentTimeInSeconds() {
        return System.currentTimeMillis() / 1000L + 10L;
    }
}

