/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.notification.plugin;

import io.meeds.kudos.BaseKudosTest;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.notification.plugin.KudosActivityChildPlugin;
import io.meeds.kudos.service.KudosService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={BaseKudosTest.class})
public class KudosActivityChildPluginTest
extends BaseKudosTest {
    private static final long KUDOS_BY_ACTIVITY_ID = 5L;
    private static final String KUDOS_MESSAGE = "KUDOS_MESSAGE";
    @Mock
    private KudosService kudosService;
    @Mock
    private NotificationContext ctx;
    @Mock
    private InitParams initParams;
    @Mock
    private NotificationInfo notification;
    @Mock
    private Kudos kudos;

    @Test
    public void testGetId() {
        KudosActivityChildPlugin kudosActivityChildPlugin = new KudosActivityChildPlugin(this.initParams);
        kudosActivityChildPlugin.kudosService = this.kudosService;
        Assertions.assertEquals((Object)"exokudos:activity", (Object)kudosActivityChildPlugin.getId());
    }

    @Test
    public void testIsValid() {
        KudosActivityChildPlugin kudosActivityChildPlugin = new KudosActivityChildPlugin(this.initParams);
        kudosActivityChildPlugin.kudosService = this.kudosService;
        Assertions.assertFalse((boolean)kudosActivityChildPlugin.isValid(null));
    }

    @Test
    public void testMakeContent() {
        KudosActivityChildPlugin kudosActivityChildPlugin = new KudosActivityChildPlugin(this.initParams);
        kudosActivityChildPlugin.kudosService = this.kudosService;
        Mockito.when((Object)this.kudosService.getKudosByActivityId(Long.valueOf(5L))).thenReturn((Object)this.kudos);
        Mockito.when((Object)this.kudos.getMessage()).thenReturn((Object)KUDOS_MESSAGE);
        Mockito.when((Object)this.ctx.getNotificationInfo()).thenReturn((Object)this.notification);
        Mockito.when((Object)this.notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey())).thenReturn((Object)String.valueOf(5L));
        Assertions.assertTrue((boolean)StringUtils.contains((CharSequence)kudosActivityChildPlugin.makeContent(this.ctx), (CharSequence)KUDOS_MESSAGE));
    }
}

