/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.listener.analytics;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.service.KudosService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
@Profile(value={"analytics"})
public class KudosSentListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(KudosSentListener.class);
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("exo.kudos.activity", (ListenerBase)this);
    }

    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        Kudos kudos = (Kudos)event.getData();
        long activityId = kudos.getActivityId();
        long streamIdentityId = 0L;
        boolean receiverChanged = false;
        if (activityId <= 0L && (StringUtils.equals((CharSequence)"ACTIVITY", (CharSequence)kudos.getEntityType()) || StringUtils.equals((CharSequence)"COMMENT", (CharSequence)kudos.getEntityType()))) {
            activityId = Long.parseLong(kudos.getEntityId());
        }
        StatisticData statisticData = new StatisticData();
        if (activityId > 0L) {
            ExoSocialActivity parentActivity;
            ExoSocialActivity activity = this.activityManager.getActivity("comment" + activityId);
            if (activity == null) {
                activity = this.activityManager.getActivity(String.valueOf(activityId));
            }
            if (activity != null && (parentActivity = this.activityManager.getParentActivity(activity)) != null) {
                activity = parentActivity;
            }
            Identity streamIdentity = null;
            if (activity != null) {
                ActivityStream activityStream;
                if (!activity.getPosterId().equals(kudos.getReceiverIdentityId())) {
                    receiverChanged = true;
                }
                if ((activityStream = activity.getActivityStream()) != null) {
                    ActivityStream.Type type = activityStream.getType();
                    boolean isSpace = type == ActivityStream.Type.SPACE;
                    String streamProviderId = isSpace ? "space" : "organization";
                    String streamRemoteId = activityStream.getPrettyId();
                    try {
                        streamIdentity = AnalyticsUtils.getIdentity((String)streamProviderId, (String)streamRemoteId);
                    }
                    catch (Exception e) {
                        LOG.debug("Can't retrieve identity with providerId {} and remoteId {}. Attempt to retrieve it as Identity technical ID", new Object[]{streamProviderId, streamRemoteId, e});
                        streamIdentity = AnalyticsUtils.getIdentity((String)activityStream.getId());
                    }
                }
            }
            if (streamIdentity != null) {
                streamIdentityId = Long.parseLong(streamIdentity.getId());
                if (StringUtils.equals((CharSequence)streamIdentity.getProviderId(), (CharSequence)"space")) {
                    Space space = this.spaceService.getSpaceByPrettyName(streamIdentity.getRemoteId());
                    AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
                }
            }
        }
        if (kudos.getSpacePrettyName() != null) {
            Space space = this.spaceService.getSpaceByPrettyName(kudos.getSpacePrettyName());
            Identity spaceIdentity = AnalyticsUtils.getIdentity((String)"space", (String)kudos.getSpacePrettyName());
            if (spaceIdentity != null) {
                streamIdentityId = Long.parseLong(spaceIdentity.getId());
                AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
            }
        }
        statisticData.setModule("social");
        statisticData.setSubModule("kudos");
        statisticData.setOperation("sendKudos");
        statisticData.setUserId(Long.parseLong(kudos.getSenderIdentityId()));
        statisticData.addParameter("activityId", (Object)activityId);
        statisticData.addParameter("streamIdentityId", (Object)streamIdentityId);
        statisticData.addParameter("kudosId", (Object)kudos.getTechnicalId());
        statisticData.addParameter("senderId", (Object)kudos.getSenderIdentityId());
        statisticData.addParameter("receiverId", (Object)kudos.getReceiverIdentityId());
        statisticData.addParameter("entityId", (Object)kudos.getEntityId());
        statisticData.addParameter("entityType", (Object)kudos.getEntityType());
        statisticData.addParameter("parentEntityId", (Object)kudos.getParentEntityId());
        statisticData.addParameter("receiverType", (Object)kudos.getReceiverType());
        statisticData.addParameter("messageLength", (Object)kudos.getMessage().length());
        statisticData.addParameter("duration", (Object)kudos.getTimeInSeconds());
        statisticData.addParameter("receiverChanged", (Object)receiverChanged);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

