/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutAclService {
    @Autowired
    private UserACL userAcl;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private Authenticator authenticator;
    @Autowired
    private IdentityManager identityManager;
    private IdentityRegistry identityRegistry;

    @PostConstruct
    public void init() {
        this.setIdentityRegistry((IdentityRegistry)ExoContainerContext.getService(IdentityRegistry.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAddSite(String username) {
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasCreatePortalPermission();
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canEditSite(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasEditPermission(portalConfig);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canViewSite(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasPermission(portalConfig);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canEditNavigation(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasEditPermission(portalConfig) || this.userAcl.hasEditPermissionOnNavigation(siteKey);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canViewNavigation(SiteKey siteKey, PageKey pageKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        Page page = pageKey == null ? null : this.layoutService.getPage(pageKey);
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasAccessPermission(portalConfig) && (page == null || this.userAcl.hasPermission(page));
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canViewPage(PageKey pageKey, String username) {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasPermission(page);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canEditPage(PageKey pageKey, String username) {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            return false;
        }
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasEditPermission(page);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAdministrator(String username) {
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.isSuperUser() || this.userAcl.isUserInGroup(this.getAdministratorsGroup());
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMemberOf(String username, String expression) {
        ConversationState currentConversationState = ConversationState.getCurrent();
        ConversationState.setCurrent((ConversationState)this.getConversationState(username));
        try {
            boolean bl = this.userAcl.hasPermission(expression);
            return bl;
        }
        finally {
            ConversationState.setCurrent((ConversationState)currentConversationState);
        }
    }

    public String getAdministratorsGroup() {
        return this.userAcl.getAdminGroups();
    }

    public ConversationState getSuperUserConversationState() {
        return new ConversationState(this.getUserIdentity(this.userAcl.getSuperUser()));
    }

    public long getSuperUserIdentityId() {
        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser());
        String id = userIdentity == null ? null : userIdentity.getId();
        return id == null ? 0L : Long.parseLong(id);
    }

    private ConversationState getConversationState(String username) {
        return new ConversationState(this.getUserIdentity(username));
    }

    private org.exoplatform.services.security.Identity getUserIdentity(String username) {
        if (StringUtils.isBlank((CharSequence)username) || IdentityConstants.ANONIM.equals(username)) {
            return null;
        }
        org.exoplatform.services.security.Identity identity = this.identityRegistry.getIdentity(username);
        if (identity != null) {
            return identity;
        }
        return this.authenticator.createIdentity(username);
    }

    @Generated
    public void setIdentityRegistry(IdentityRegistry identityRegistry) {
        this.identityRegistry = identityRegistry;
    }
}

