/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.attachment;

import io.meeds.layout.service.LayoutAclService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class LayoutBackgroundAttachmentPlugin
extends AttachmentPlugin {
    public static final String OBJECT_TYPE = "containerBackground";
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private AttachmentService attachmentService;

    @PostConstruct
    public void init() {
        this.attachmentService.addPlugin((AttachmentPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasEditPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        return this.layoutAclService.canEditPage(this.getPageKey(entityId.split("_")[0]), userIdentity == null ? null : userIdentity.getUserId());
    }

    public boolean hasAccessPermission(Identity userIdentity, String entityId) throws ObjectNotFoundException {
        return this.layoutAclService.canViewPage(this.getPageKey(entityId.split("_")[0]), userIdentity == null ? null : userIdentity.getUserId());
    }

    public long getAudienceId(String objectId) throws ObjectNotFoundException {
        return 0L;
    }

    public long getSpaceId(String objectId) throws ObjectNotFoundException {
        return 0L;
    }

    private PageKey getPageKey(String entityId) {
        String pageUuid = entityId.replace("page_", "");
        long pageId = StringUtils.isNumeric((CharSequence)pageUuid) ? Long.parseLong(pageUuid) : 0L;
        Page page = this.layoutService.getPage(pageId);
        return page.getPageKey();
    }
}

