/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.renderer;

import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstancePreferencePlugin;
import io.meeds.social.cms.model.CMSSetting;
import io.meeds.social.cms.service.CMSService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.social.attachment.AttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImagePortletInstancePreferencePlugin
implements PortletInstancePreferencePlugin {
    private static final String CMS_SETTING_PREFERENCE_NAME = "name";
    private static final String DATA_INIT_PREFERENCE_NAME = "data.init";
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private CMSService cmsService;
    @Autowired
    private FileService fileService;

    @Override
    public String getPortletName() {
        return "Image";
    }

    @Override
    public List<PortletInstancePreference> generatePreferences(Application application, Portlet preferences, PortletInstanceContext portletInstanceContext) {
        String settingName = this.getCmsSettingName(preferences);
        if (StringUtils.isBlank((CharSequence)settingName)) {
            if (preferences != null && preferences.getPreference(DATA_INIT_PREFERENCE_NAME) != null) {
                return Collections.singletonList(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, preferences.getPreference(DATA_INIT_PREFERENCE_NAME).getValue()));
            }
            return Collections.emptyList();
        }
        Long fileId = this.getImageFileId(settingName);
        if (fileId == null) {
            return Collections.emptyList();
        }
        FileItem file = this.fileService.getFile(fileId.longValue());
        if (file == null) {
            return Collections.emptyList();
        }
        String imageContent = Base64.encodeBase64String((byte[])file.getAsByte());
        return Collections.singletonList(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, imageContent));
    }

    private Long getImageFileId(String settingName) {
        CMSSetting setting = this.cmsService.getSetting("imagePortlet", settingName);
        List fileIds = this.attachmentService.getAttachmentFileIds("imagePortlet", setting.getName());
        if (CollectionUtils.isEmpty((Collection)fileIds)) {
            return null;
        }
        return Long.parseLong((String)fileIds.getFirst());
    }

    private String getCmsSettingName(Portlet preferences) {
        if (preferences == null) {
            return null;
        }
        Preference settingNamePreference = preferences.getPreference(CMS_SETTING_PREFERENCE_NAME);
        return settingNamePreference == null ? null : settingNamePreference.getValue();
    }
}

