/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.model.PageTemplateDatabind;
import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.plugin.PageTemplateDatabindPlugin$AjcClosure1;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.util.DatabindUtils;
import io.meeds.layout.util.JsonUtils;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.plugin.DatabindPlugin;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class PageTemplateDatabindPlugin
implements DatabindPlugin {
    private static final Random RANDOM;
    public static final String OBJECT_TYPE = "PageTemplate";
    public static final String CONFIG_JSON = "config.json";
    public static final String LAYOUT_JSON = "layout.json";
    @Autowired
    private PageTemplateService pageTemplateService;
    @Autowired
    private DatabindService databindService;
    @Autowired
    private FileService fileService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private PortletInstanceService portletInstanceService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private IdentityManager identityManager;
    private long superUserIdentityId;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.databindService.addPlugin((DatabindPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canHandleDatabind(String objectType, String objectId) {
        return StringUtils.equals((CharSequence)OBJECT_TYPE, (CharSequence)objectType);
    }

    public void serialize(String objectId, ZipOutputStream zipOutputStream, String username) {
        FileItem file;
        TranslationField translationDescriptionField;
        PageTemplate pageTemplate = this.pageTemplateService.getPageTemplate(Long.parseLong(objectId), Locale.getDefault(), true, true);
        PageTemplateDatabind databind = new PageTemplateDatabind();
        databind.setContent(pageTemplate.getContent());
        TranslationField translationNameField = this.translationService.getTranslationField("pageTemplate", Long.parseLong(objectId), "title", username);
        if (translationNameField != null) {
            Map<String, String> names = translationNameField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setNames(names);
        }
        if ((translationDescriptionField = this.translationService.getTranslationField("pageTemplate", Long.parseLong(objectId), "description", username)) != null) {
            Map<String, String> descriptions = translationDescriptionField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setDescriptions(descriptions);
        }
        if ((file = this.fileService.getFile(pageTemplate.getIllustrationId())) != null) {
            databind.setIllustration(Base64.encodeBase64String((byte[])file.getAsByte()));
        }
        String jsonData = JsonUtils.toJsonString(databind);
        Page pageLayout = JsonUtils.fromJsonString(pageTemplate.getContent(), LayoutModel.class).toPage();
        LayoutModel layoutModel = new LayoutModel((ModelObject)pageLayout, this.portletInstanceService, new PortletInstanceContext(true, null));
        DatabindUtils.retrieveBackgroundImages(layoutModel, this.fileService);
        layoutModel.resetStorage();
        String layoutData = JsonUtils.toJsonString(layoutModel);
        this.writeToZip(zipOutputStream, "PageTemplate-" + pageTemplate.getId() + "/config.json", jsonData);
        this.writeToZip(zipOutputStream, "PageTemplate-" + pageTemplate.getId() + "/layout.json", layoutData);
    }

    public CompletableFuture<Pair<DatabindReport, File>> deserialize(File zipFile, Map<String, String> params, String username) {
        return CompletableFuture.supplyAsync(() -> this.importPageTemplates(zipFile)).thenApply(processedTemplates -> {
            DatabindReport report = new DatabindReport();
            report.setSuccess(!processedTemplates.isEmpty());
            report.setProcessedItems(processedTemplates);
            return Pair.of((Object)report, (Object)zipFile);
        });
    }

    @ContainerTransactional
    public List<String> importPageTemplates(File zipFile) {
        File file = zipFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file);
        Object[] objectArray = new Object[]{this, file, joinPoint};
        PageTemplateDatabindPlugin$AjcClosure1 pageTemplateDatabindPlugin$AjcClosure1 = new PageTemplateDatabindPlugin$AjcClosure1(objectArray);
        return (List)ContainerTransactionalAspect.aspectOf().around(pageTemplateDatabindPlugin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private Map<String, PageTemplateDatabind> extractTemplates(File zipFile) {
        HashMap<String, PageTemplateDatabind> templateDatabindMap = new HashMap<String, PageTemplateDatabind>();
        try (ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(zipFile), StandardCharsets.UTF_8);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                LayoutModel page;
                int bytesRead;
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                String jsonContent = baos.toString(StandardCharsets.UTF_8);
                String entryName = entry.getName();
                String key = entryName.split("/")[0];
                if (entry.getName().endsWith(CONFIG_JSON)) {
                    PageTemplateDatabind databind = JsonUtils.fromJsonString(jsonContent, PageTemplateDatabind.class);
                    if (databind == null) continue;
                    templateDatabindMap.put(key, databind);
                    continue;
                }
                if (!entry.getName().endsWith(LAYOUT_JSON) || (page = JsonUtils.fromJsonString(jsonContent, LayoutModel.class)) == null) continue;
                PageTemplateDatabind databind = templateDatabindMap.computeIfAbsent(key, k -> new PageTemplateDatabind());
                databind.setPage(page);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading zip file", e);
        }
        return templateDatabindMap;
    }

    private void saveIllustration(long pageTemplateId, byte[] illustrationBytes) {
        File tempFile = null;
        try {
            tempFile = DatabindUtils.getIllustrationFile(illustrationBytes);
            String uploadId = "PageTemplateIllustration" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            this.attachmentService.deleteAttachments("pageTemplate", String.valueOf(pageTemplateId));
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "pageTemplate", String.valueOf(pageTemplateId), null, this.getSuperUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving illustration as attachment for page template '%s'", pageTemplateId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    private void saveNames(PageTemplateDatabind pageTemplateDatabind, PageTemplate pageTemplate) {
        this.translationService.saveTranslationLabels("pageTemplate", pageTemplate.getId(), "title", pageTemplateDatabind.getNames().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue)));
    }

    private void saveDescriptions(PageTemplateDatabind pageTemplateDatabind, PageTemplate pageTemplate) {
        this.translationService.saveTranslationLabels("pageTemplate", pageTemplate.getId(), "description", pageTemplateDatabind.getDescriptions().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue)));
    }

    private void processPageTemplate(PageTemplateDatabind pageTemplateDatabind) {
        PageTemplate pageTemplate = new PageTemplate();
        pageTemplate.setName(pageTemplateDatabind.getNames().get("en"));
        pageTemplate.setDescription(pageTemplateDatabind.getDescriptions().get("en"));
        LayoutModel page = JsonUtils.fromJsonString(pageTemplateDatabind.getContent(), LayoutModel.class);
        if (page != null) {
            page.setChildren(pageTemplateDatabind.getPage().getChildren());
            pageTemplate.setContent(JsonUtils.toJsonString(page));
        }
        pageTemplate.setSystem(false);
        PageTemplate createdPageTemplate = this.pageTemplateService.createPageTemplate(pageTemplate);
        this.saveNames(pageTemplateDatabind, createdPageTemplate);
        this.saveDescriptions(pageTemplateDatabind, createdPageTemplate);
        if (pageTemplateDatabind.getIllustration() != null) {
            this.saveIllustration(createdPageTemplate.getId(), Base64.decodeBase64((String)pageTemplateDatabind.getIllustration()));
        }
        DatabindUtils.saveAppBackgroundImages(createdPageTemplate.getId(), page, this.attachmentService, this.getSuperUserIdentityId());
        createdPageTemplate.setContent(JsonUtils.toJsonString(page));
        this.pageTemplateService.updatePageTemplate(createdPageTemplate);
    }

    private void writeToZip(ZipOutputStream zipOutputStream, String filePath, String content) {
        ZipEntry entry = new ZipEntry(filePath);
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(content.getBytes(StandardCharsets.UTF_8));
        zipOutputStream.closeEntry();
    }

    private long getSuperUserIdentityId() {
        if (this.superUserIdentityId == 0L) {
            this.superUserIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser()).getId());
        }
        return this.superUserIdentityId;
    }

    static {
        PageTemplateDatabindPlugin.ajc$preClinit();
        RANDOM = new Random();
    }

    static final /* synthetic */ List importPageTemplates_aroundBody0(PageTemplateDatabindPlugin ajc$this, File zipFile, JoinPoint joinPoint) {
        Map<String, PageTemplateDatabind> instances = ajc$this.extractTemplates(zipFile);
        ArrayList<String> processedPageTemplates = new ArrayList<String>();
        for (Map.Entry<String, PageTemplateDatabind> entry : instances.entrySet()) {
            PageTemplateDatabind pageTemplate = entry.getValue();
            ajc$this.processPageTemplate(pageTemplate);
            processedPageTemplates.add(pageTemplate.getContent());
        }
        return processedPageTemplates;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PageTemplateDatabindPlugin.java", PageTemplateDatabindPlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importPageTemplates", "io.meeds.layout.plugin.PageTemplateDatabindPlugin", "java.io.File", "zipFile", "", "java.util.List"), 182);
    }
}

