/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LayoutAclService {
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private UserACL userAcl;

    public boolean canAddSite(String username) {
        return this.userAcl.hasCreatePortalPermission(this.userAcl.getUserIdentity(username));
    }

    public boolean canEditSite(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        return this.userAcl.hasEditPermission(portalConfig, this.userAcl.getUserIdentity(username));
    }

    public boolean canViewSite(SiteKey siteKey, String username) {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            return false;
        }
        return this.userAcl.hasAccessPermission(portalConfig, this.userAcl.getUserIdentity(username));
    }

    public boolean canEditNavigation(SiteKey siteKey, String username) {
        return this.canEditSite(siteKey, username);
    }

    public boolean canViewNavigation(SiteKey siteKey, PageKey pageKey, String username) {
        return this.canViewSite(siteKey, username) && (pageKey == null || this.canViewPage(pageKey, username));
    }

    public boolean canViewPage(PageKey pageKey, String username) {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            return false;
        }
        return this.userAcl.hasAccessPermission(page, this.userAcl.getUserIdentity(username));
    }

    public boolean canEditPage(PageKey pageKey, String username) {
        Page page = this.layoutService.getPage(pageKey);
        if (page == null) {
            return false;
        }
        return this.userAcl.hasEditPermission(page, this.userAcl.getUserIdentity(username));
    }

    public boolean hasAccessPermission(ModelObject modelObject, String username) {
        ModelObject modelObject2 = modelObject;
        Objects.requireNonNull(modelObject2);
        ModelObject modelObject3 = modelObject2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Application.class, Page.class, Container.class, PortalConfig.class}, (Object)modelObject3, n)) {
            case 0 -> {
                Application application = (Application)modelObject3;
                yield this.hasAccessPermission(application.getAccessPermissions(), username);
            }
            case 1 -> {
                Page page = (Page)modelObject3;
                yield this.canViewPage(new PageKey(page.getOwnerType(), page.getOwnerId(), page.getName()), username);
            }
            case 2 -> {
                Container container = (Container)modelObject3;
                yield this.hasAccessPermission(container.getAccessPermissions(), username);
            }
            case 3 -> {
                PortalConfig portalConfig = (PortalConfig)modelObject3;
                yield this.canViewSite(new SiteKey(portalConfig.getType(), portalConfig.getName()), username);
            }
            default -> true;
        };
    }

    public boolean isAdministrator(String username) {
        return this.userAcl.isAdministrator(this.userAcl.getUserIdentity(username));
    }

    public boolean hasPermission(String username, String expression) {
        return this.userAcl.hasPermission(this.userAcl.getUserIdentity(username), expression);
    }

    public String getAdministratorsGroup() {
        return this.userAcl.getAdminGroups();
    }

    public ConversationState getSuperUserConversationState() {
        return new ConversationState(this.userAcl.getUserIdentity(this.userAcl.getSuperUser()));
    }

    public long getSuperUserIdentityId() {
        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser());
        return userIdentity == null ? 0L : Long.parseLong(userIdentity.getId());
    }

    private boolean hasAccessPermission(String[] accessPermissions, String username) {
        return ArrayUtils.isEmpty((Object[])accessPermissions) || this.isAdministrator(username) || Arrays.stream(accessPermissions).anyMatch(permission -> this.hasPermission(username, (String)permission));
    }
}

