/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.PortletDescriptor;
import io.meeds.layout.service.PortletService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"portlets"})
@Tag(name="portlets", description="Retrieving available portlets")
public class PortletRest {
    @Autowired
    private PortletService portletService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieve portlets", method="GET", description="This retrieves the list of available portlets in the platform")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public List<PortletDescriptor> getPortlets() {
        return this.portletService.getPortlets();
    }
}

