/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.dao.PageTemplateDAO;
import io.meeds.layout.entity.PageTemplateEntity;
import io.meeds.layout.model.PageTemplate;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageTemplateStorage {
    @Autowired
    private PageTemplateDAO pageTemplateDAO;

    public List<PageTemplate> getPageTemplates() {
        List entities = this.pageTemplateDAO.findAll();
        return entities.stream().map(e -> new PageTemplate(e.getId(), e.isDisabled(), e.isSystem(), e.getCategory(), e.getContent())).toList();
    }

    public PageTemplate getPageTemplate(long id) {
        return this.pageTemplateDAO.findById(id).map(e -> new PageTemplate(e.getId(), e.isDisabled(), e.isSystem(), e.getCategory(), e.getContent())).orElse(null);
    }

    public PageTemplate createPageTemplate(PageTemplate pageTemplate) {
        PageTemplateEntity entity = new PageTemplateEntity(null, pageTemplate.isDisabled(), pageTemplate.isSystem(), pageTemplate.getCategory(), pageTemplate.getContent());
        entity = (PageTemplateEntity)this.pageTemplateDAO.save(entity);
        return new PageTemplate(entity.getId(), entity.isDisabled(), entity.isSystem(), entity.getCategory(), entity.getContent());
    }

    public PageTemplate updatePageTemplate(PageTemplate pageTemplate) throws ObjectNotFoundException {
        if (!this.pageTemplateDAO.existsById(pageTemplate.getId())) {
            throw new ObjectNotFoundException("Page template doesn't exist");
        }
        PageTemplateEntity entity = new PageTemplateEntity(pageTemplate.getId(), pageTemplate.isDisabled(), pageTemplate.isSystem(), pageTemplate.getCategory(), pageTemplate.getContent());
        entity = (PageTemplateEntity)this.pageTemplateDAO.save(entity);
        return new PageTemplate(entity.getId(), entity.isDisabled(), entity.isSystem(), entity.getCategory(), entity.getContent());
    }

    public void deletePageTemplate(long templateId) throws ObjectNotFoundException {
        if (!this.pageTemplateDAO.existsById(templateId)) {
            throw new ObjectNotFoundException(String.format("Page template with id %s doesn't exist", templateId));
        }
        this.pageTemplateDAO.deleteById(templateId);
    }
}

