/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.service.LayoutAclService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={LayoutAclService.class})
@ExtendWith(value={MockitoExtension.class})
public class LayoutAclServiceTest {
    private static final String TEST_USER = "testuser";
    private static final SiteKey SITE_KEY = SiteKey.portal((String)"test");
    private static final PageKey PAGE_KEY = PageKey.parse((String)"portal::test::test");
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private UserACL userAcl;
    @Autowired
    private LayoutAclService layoutAclService;
    @Mock
    private PortalConfig portalConfig;
    @Mock
    private Page page;
    @Mock
    private Identity aclIdentity;

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.userAcl.getUserIdentity(TEST_USER)).thenReturn((Object)this.aclIdentity);
    }

    @Test
    public void canAddSite() {
        Assertions.assertFalse((boolean)this.layoutAclService.canAddSite(TEST_USER));
        Mockito.when((Object)this.userAcl.hasCreatePortalPermission(this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.layoutAclService.canAddSite(TEST_USER));
    }

    @Test
    public void canEditSite() {
        Assertions.assertFalse((boolean)this.layoutAclService.canEditSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assertions.assertFalse((boolean)this.layoutAclService.canEditSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasEditPermission(this.portalConfig, this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.layoutAclService.canEditSite(SITE_KEY, TEST_USER));
    }

    @Test
    public void canViewSite() {
        Assertions.assertFalse((boolean)this.layoutAclService.canViewSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assertions.assertFalse((boolean)this.layoutAclService.canViewSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasAccessPermission(this.portalConfig, this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.layoutAclService.canViewSite(SITE_KEY, TEST_USER));
    }

    @Test
    public void canEditNavigation() {
        Assertions.assertFalse((boolean)this.layoutAclService.canEditNavigation(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assertions.assertFalse((boolean)this.layoutAclService.canEditNavigation(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasEditPermission(this.portalConfig, this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.layoutAclService.canEditNavigation(SITE_KEY, TEST_USER));
    }

    @Test
    public void canViewNavigation() {
        Assertions.assertFalse((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, null, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assertions.assertFalse((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, null, TEST_USER));
        Mockito.when((Object)this.userAcl.hasAccessPermission(this.portalConfig, this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, null, TEST_USER));
    }

    @Test
    public void canViewNavigationWithPage() {
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assertions.assertFalse((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasAccessPermission(this.page, this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasAccessPermission(this.portalConfig, this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.layoutAclService.canViewNavigation(SITE_KEY, PAGE_KEY, TEST_USER));
    }

    @Test
    public void canViewPage() {
        Assertions.assertFalse((boolean)this.layoutAclService.canViewPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assertions.assertFalse((boolean)this.layoutAclService.canViewPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasAccessPermission(this.page, this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.layoutAclService.canViewPage(PAGE_KEY, TEST_USER));
    }

    @Test
    public void canEditPage() {
        Assertions.assertFalse((boolean)this.layoutAclService.canEditPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assertions.assertFalse((boolean)this.layoutAclService.canEditPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.userAcl.hasEditPermission(this.page, this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.layoutAclService.canEditPage(PAGE_KEY, TEST_USER));
    }

    @Test
    public void isAdministrator() {
        Assertions.assertFalse((boolean)this.layoutAclService.isAdministrator(TEST_USER));
        Mockito.when((Object)this.userAcl.isAdministrator(this.aclIdentity)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.layoutAclService.isAdministrator(TEST_USER));
    }
}

