/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.NavigationCreateModel;
import io.meeds.layout.model.NavigationUpdateModel;
import io.meeds.layout.model.NodeLabel;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.NavigationLayoutService;
import io.meeds.layout.service.PageLayoutService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.DescriptionService;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.router.Router;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={NavigationLayoutService.class})
@ExtendWith(value={MockitoExtension.class})
public class NavigationLayoutServiceTest {
    private static final String TEST_USER = "testuser";
    private static final SiteKey SITE_KEY = SiteKey.portal((String)"test");
    private static final PageKey PAGE_KEY = PageKey.parse((String)"portal::test::test");
    @MockBean
    private NavigationService navigationService;
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private PageLayoutService pageLayoutService;
    @MockBean
    private DescriptionService descriptionService;
    @MockBean
    private LayoutAclService aclService;
    @MockBean
    private WebAppController webController;
    @MockBean
    private LocaleConfigService localeConfigService;
    @Mock
    private NodeData parentNodeData;
    @Mock
    private NodeData nodeData;
    @Mock
    private NodeState nodeState;
    @Mock
    private PageContext pageContext;
    @Mock
    private LocaleConfig defaultLocaleConfig;
    @Autowired
    private NavigationLayoutService navigationLayoutService;

    @Test
    public void createNode() throws IllegalAccessException, IllegalArgumentException, ObjectNotFoundException {
        NavigationCreateModel nodeModel = (NavigationCreateModel)Mockito.mock(NavigationCreateModel.class);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.createNode(nodeModel, TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(nodeModel.getParentNodeId())).thenReturn((Object)this.parentNodeData);
        Mockito.when((Object)this.parentNodeData.getSiteKey()).thenReturn((Object)SITE_KEY);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.navigationLayoutService.createNode(nodeModel, TEST_USER));
        Mockito.when((Object)this.aclService.canEditNavigation(this.parentNodeData.getSiteKey(), TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)nodeModel.getPageRef()).thenReturn((Object)PAGE_KEY.format());
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.createNode(nodeModel, TEST_USER));
        Mockito.when((Object)this.layoutService.getPageContext(PAGE_KEY)).thenReturn((Object)this.pageContext);
        Mockito.when((Object)nodeModel.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)nodeModel.isScheduled()).thenReturn((Object)true);
        Mockito.when((Object)nodeModel.getStartScheduleDate()).thenReturn((Object)3L);
        Mockito.when((Object)nodeModel.getEndScheduleDate()).thenReturn((Object)2L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.navigationLayoutService.createNode(nodeModel, TEST_USER));
        Mockito.when((Object)nodeModel.getEndScheduleDate()).thenReturn((Object)4L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.navigationLayoutService.createNode(nodeModel, TEST_USER));
        Mockito.when((Object)nodeModel.isPasteMode()).thenReturn((Object)true);
        Assertions.assertThrows(IllegalStateException.class, () -> this.navigationLayoutService.createNode(nodeModel, TEST_USER));
        Mockito.when((Object)this.navigationService.createNode((Long)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (NodeState)ArgumentMatchers.any())).thenReturn((Object)new NodeData[]{this.parentNodeData, this.nodeData});
        Mockito.when((Object)this.nodeData.getId()).thenReturn((Object)"36");
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(36L))).thenReturn((Object)this.nodeData);
        Assert.assertNotNull((Object)this.navigationLayoutService.createNode(nodeModel, TEST_USER));
    }

    @Test
    public void createDraftNode() throws IllegalAccessException, ObjectNotFoundException {
        Mockito.when((Object)this.nodeData.getId()).thenReturn((Object)"2");
        Mockito.when((Object)this.nodeData.getParentId()).thenReturn((Object)"3");
        Mockito.when((Object)this.nodeData.getState()).thenReturn((Object)this.nodeState);
        Mockito.when((Object)this.nodeData.getSiteKey()).thenReturn((Object)SITE_KEY);
        Mockito.when((Object)this.nodeState.getPageRef()).thenReturn((Object)PAGE_KEY);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.createDraftNode(Long.valueOf(2L), TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(2L))).thenReturn((Object)this.nodeData);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.navigationLayoutService.createDraftNode(Long.valueOf(2L), TEST_USER));
        Mockito.when((Object)this.aclService.canViewNavigation(SITE_KEY, PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        PageKey clonedPageKey = PageKey.parse((String)"portal::test::test_clone");
        Mockito.when((Object)this.pageLayoutService.clonePage(PAGE_KEY, TEST_USER)).thenReturn((Object)clonedPageKey);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.createDraftNode(Long.valueOf(2L), TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(3L))).thenReturn((Object)this.parentNodeData);
        Mockito.when((Object)this.parentNodeData.getSiteKey()).thenReturn((Object)SITE_KEY);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.navigationLayoutService.createDraftNode(Long.valueOf(2L), TEST_USER));
        Mockito.when((Object)this.aclService.canEditNavigation(this.parentNodeData.getSiteKey(), TEST_USER)).thenReturn((Object)true);
        NodeData clonedNodeData = (NodeData)Mockito.mock(NodeData.class);
        PageContext clonedPageContext = (PageContext)Mockito.mock(PageContext.class);
        Mockito.when((Object)this.layoutService.getPageContext((PageKey)ArgumentMatchers.argThat(k -> k.format().equals(clonedPageKey.format())))).thenReturn((Object)clonedPageContext);
        Mockito.when((Object)clonedPageContext.getKey()).thenReturn((Object)clonedPageKey);
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(36L))).thenReturn((Object)clonedNodeData);
        Mockito.when((Object)this.navigationService.createNode((Long)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (NodeState)ArgumentMatchers.any())).thenReturn((Object)new NodeData[]{this.parentNodeData, this.nodeData});
        this.navigationLayoutService.createDraftNode(Long.valueOf(2L), TEST_USER);
        ((NavigationService)Mockito.verify((Object)this.navigationService)).createNode((Long)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (NodeState)ArgumentMatchers.any());
    }

    @Test
    public void updateNode() {
        NavigationUpdateModel nodeModel = (NavigationUpdateModel)Mockito.mock(NavigationUpdateModel.class);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.updateNode(2L, nodeModel, TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(2L))).thenReturn((Object)this.nodeData);
        Mockito.when((Object)this.nodeData.getSiteKey()).thenReturn((Object)SITE_KEY);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.navigationLayoutService.updateNode(2L, nodeModel, TEST_USER));
        Mockito.when((Object)this.aclService.canEditNavigation(this.nodeData.getSiteKey(), TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)nodeModel.getPageRef()).thenReturn((Object)PAGE_KEY.format());
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.updateNode(2L, nodeModel, TEST_USER));
        Mockito.when((Object)this.layoutService.getPageContext(PAGE_KEY)).thenReturn((Object)this.pageContext);
        Mockito.when((Object)nodeModel.isVisible()).thenReturn((Object)true);
        Mockito.when((Object)nodeModel.isScheduled()).thenReturn((Object)true);
        Mockito.when((Object)nodeModel.getStartScheduleDate()).thenReturn((Object)3L);
        Mockito.when((Object)nodeModel.getEndScheduleDate()).thenReturn((Object)2L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.navigationLayoutService.updateNode(2L, nodeModel, TEST_USER));
        Mockito.when((Object)nodeModel.getEndScheduleDate()).thenReturn((Object)4L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.navigationLayoutService.updateNode(2L, nodeModel, TEST_USER));
        Mockito.when((Object)nodeModel.getStartScheduleDate()).thenReturn(null);
        Mockito.when((Object)nodeModel.getEndScheduleDate()).thenReturn(null);
        Mockito.when((Object)this.nodeData.getId()).thenReturn((Object)"2");
        Assertions.assertDoesNotThrow(() -> this.navigationLayoutService.updateNode(2L, nodeModel, TEST_USER));
        ((NavigationService)Mockito.verify((Object)this.navigationService)).updateNode((Long)ArgumentMatchers.any(), (NodeState)ArgumentMatchers.any());
    }

    @Test
    public void deleteNode() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.deleteNode(2L, 0L, TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(2L))).thenReturn((Object)this.nodeData);
        Mockito.when((Object)this.nodeData.getSiteKey()).thenReturn((Object)SITE_KEY);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.navigationLayoutService.deleteNode(2L, 0L, TEST_USER));
        Mockito.when((Object)this.aclService.canEditNavigation(this.nodeData.getSiteKey(), TEST_USER)).thenReturn((Object)true);
        Assertions.assertDoesNotThrow(() -> this.navigationLayoutService.deleteNode(2L, 10L, TEST_USER));
        ((NavigationService)Mockito.verify((Object)this.navigationService, (VerificationMode)Mockito.never())).deleteNode(Long.valueOf(2L));
        Assertions.assertDoesNotThrow(() -> this.navigationLayoutService.deleteNode(2L, 0L, TEST_USER));
        ((NavigationService)Mockito.verify((Object)this.navigationService, (VerificationMode)Mockito.atLeast((int)1))).deleteNode(Long.valueOf(2L));
    }

    @Test
    public void undoDeleteNode() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.deleteNode(2L, 0L, TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(2L))).thenReturn((Object)this.nodeData);
        Mockito.when((Object)this.nodeData.getSiteKey()).thenReturn((Object)SITE_KEY);
        Mockito.when((Object)this.aclService.canEditNavigation(this.nodeData.getSiteKey(), TEST_USER)).thenReturn((Object)true);
        this.navigationLayoutService.deleteNode(2L, 10L, TEST_USER);
        ((NavigationService)Mockito.verify((Object)this.navigationService, (VerificationMode)Mockito.never())).deleteNode(Long.valueOf(2L));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.undoDeleteNode(2L, "anotherUser"));
        this.navigationLayoutService.undoDeleteNode(2L, TEST_USER);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.undoDeleteNode(2L, TEST_USER));
    }

    @Test
    public void moveNode() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.moveNode(2L, Long.valueOf(3L), Long.valueOf(4L), TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(2L))).thenReturn((Object)this.nodeData);
        Mockito.when((Object)this.nodeData.getParentId()).thenReturn((Object)"55");
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.moveNode(2L, Long.valueOf(3L), Long.valueOf(4L), TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(55L))).thenReturn((Object)this.parentNodeData);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.navigationLayoutService.moveNode(2L, null, Long.valueOf(4L), TEST_USER));
        Mockito.when((Object)this.parentNodeData.getSiteKey()).thenReturn((Object)SITE_KEY);
        Mockito.when((Object)this.aclService.canEditNavigation(this.parentNodeData.getSiteKey(), TEST_USER)).thenReturn((Object)true);
        this.navigationLayoutService.moveNode(2L, null, Long.valueOf(4L), TEST_USER);
        ((NavigationService)Mockito.verify((Object)this.navigationService)).moveNode(Long.valueOf(2L), Long.valueOf(55L), Long.valueOf(55L), Long.valueOf(4L));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(3L))).thenReturn((Object)this.parentNodeData);
        this.navigationLayoutService.moveNode(2L, Long.valueOf(3L), Long.valueOf(4L), TEST_USER);
        ((NavigationService)Mockito.verify((Object)this.navigationService)).moveNode(Long.valueOf(2L), Long.valueOf(55L), Long.valueOf(3L), Long.valueOf(4L));
    }

    @Test
    public void getNodeLabels() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.getNodeLabels(2L, TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(2L))).thenReturn((Object)this.nodeData);
        Mockito.when((Object)this.nodeData.getSiteKey()).thenReturn((Object)SITE_KEY);
        Mockito.when((Object)this.nodeData.getState()).thenReturn((Object)this.nodeState);
        Mockito.when((Object)this.nodeState.getPageRef()).thenReturn((Object)PAGE_KEY);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.navigationLayoutService.getNodeLabels(2L, TEST_USER));
        ((DescriptionService)Mockito.verify((Object)this.descriptionService, (VerificationMode)Mockito.never())).getDescriptions("2");
        Mockito.when((Object)this.aclService.canViewNavigation(SITE_KEY, PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        this.navigationLayoutService.getNodeLabels(2L, TEST_USER);
        ((DescriptionService)Mockito.verify((Object)this.descriptionService)).getDescriptions("2");
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
        Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.FRENCH);
        Mockito.when((Object)this.defaultLocaleConfig.getLocaleName()).thenReturn((Object)Locale.FRENCH.toLanguageTag());
        LocaleConfig otherLocaleConfig = (LocaleConfig)Mockito.mock(LocaleConfig.class);
        Mockito.when((Object)otherLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)otherLocaleConfig.getLocaleName()).thenReturn((Object)Locale.ENGLISH.toLanguageTag());
        Mockito.when((Object)this.localeConfigService.getLocalConfigs()).thenReturn(Arrays.asList(this.defaultLocaleConfig, otherLocaleConfig));
        String nodeName = "testLabel";
        Mockito.when((Object)this.descriptionService.getDescriptions("2")).thenReturn(Collections.singletonMap(Locale.ENGLISH, new State(nodeName, "testDescription")));
        NodeLabel nodeLabel = this.navigationLayoutService.getNodeLabels(2L, TEST_USER);
        Assert.assertNotNull((Object)nodeLabel);
        Assert.assertNotNull((Object)nodeLabel.getLabels());
        Assertions.assertEquals((Object)this.defaultLocaleConfig.getLocale().toLanguageTag(), (Object)nodeLabel.getDefaultLanguage());
        Assertions.assertEquals((int)2, (int)nodeLabel.getSupportedLanguages().size());
        Assertions.assertEquals((int)2, (int)nodeLabel.getLabels().size());
        Assertions.assertEquals((Object)nodeName, nodeLabel.getLabels().get(this.defaultLocaleConfig.getLocale().toLanguageTag()));
        Assertions.assertEquals((Object)nodeName, nodeLabel.getLabels().get(otherLocaleConfig.getLocale().toLanguageTag()));
    }

    @Test
    public void getNodeUri() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.navigationLayoutService.getNodeUri(2L, TEST_USER));
        Mockito.when((Object)this.navigationService.getNodeById(Long.valueOf(2L))).thenReturn((Object)this.nodeData);
        Mockito.when((Object)this.nodeData.getSiteKey()).thenReturn((Object)SITE_KEY);
        Mockito.when((Object)this.nodeData.getState()).thenReturn((Object)this.nodeState);
        Mockito.when((Object)this.nodeState.getPageRef()).thenReturn((Object)PAGE_KEY);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.navigationLayoutService.getNodeUri(2L, TEST_USER));
        Mockito.when((Object)this.aclService.canViewNavigation(SITE_KEY, PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Router router = (Router)Mockito.mock(Router.class);
        Mockito.when((Object)this.webController.getRouter()).thenReturn((Object)router);
        Mockito.when((Object)router.render((Map)ArgumentMatchers.any(Map.class))).thenReturn((Object)"/test/en/uri?lang=en&lang=en");
        String nodeUri = this.navigationLayoutService.getNodeUri(2L, TEST_USER);
        Assertions.assertEquals((Object)"/test/uri", (Object)nodeUri);
    }
}

