/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.model.PortletDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.portlet.impl.info.ContainerPortletInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortletStorage {
    @Autowired(required=false)
    private PortletInvoker portletInvoker;
    private List<PortletDescriptor> portletDescriptors;

    public List<PortletDescriptor> getPortletDescriptors() {
        if (this.portletDescriptors == null) {
            this.portletDescriptors = Collections.unmodifiableList(this.getPortlets().stream().map(this::toPortletDescriptor).filter(Objects::nonNull).toList());
        }
        return this.portletDescriptors;
    }

    public PortletDescriptor getPortletDescriptor(String id) {
        return this.getPortletDescriptors().stream().filter(p -> StringUtils.equals((CharSequence)p.getContentId(), (CharSequence)id) || StringUtils.equals((CharSequence)p.getPortletName(), (CharSequence)id)).findFirst().orElse(null);
    }

    private PortletDescriptor toPortletDescriptor(Portlet portlet) {
        if (portlet.isRemote()) {
            return null;
        }
        PortletInfo info = portlet.getInfo();
        MetaInfo metaInfo = info.getMeta();
        Set allModes = info.getCapabilities().getModes(MediaType.create((String)"text/html"));
        LocalizedString descriptionLS = metaInfo.getMetaValue("description");
        LocalizedString nameLS = metaInfo.getMetaValue("display-name");
        PortletDescriptor portletDescriptor = new PortletDescriptor();
        portletDescriptor.setApplicationName(info.getApplicationName());
        portletDescriptor.setPortletName(info.getName());
        portletDescriptor.setName(this.getLocalizedStringOrDefault(nameLS, info.getName()));
        portletDescriptor.setDescription(this.getLocalizedStringOrDefault(descriptionLS, info.getName()));
        portletDescriptor.setSupportedModes(allModes.stream().map(m -> m.getModeName()).toList());
        if (info instanceof ContainerPortletInfo) {
            ContainerPortletInfo containerPortletInfo = (ContainerPortletInfo)info;
            portletDescriptor.setEditable(StringUtils.equals((CharSequence)"true", (CharSequence)containerPortletInfo.getInitParameter("layout-content-editable")));
        }
        return portletDescriptor;
    }

    private String getLocalizedStringOrDefault(LocalizedString localizedString, String portletName) {
        if (localizedString == null || localizedString.getDefaultString() == null) {
            return portletName;
        }
        return localizedString.getDefaultString();
    }

    private Set<Portlet> getPortlets() {
        return this.getPortletInvoker().getPortlets();
    }

    private PortletInvoker getPortletInvoker() {
        if (this.portletInvoker == null) {
            this.portletInvoker = (PortletInvoker)ExoContainerContext.getService(PortletInvoker.class);
        }
        return this.portletInvoker;
    }

    public void setPortletDescriptors(List<PortletDescriptor> portletDescriptors) {
        this.portletDescriptors = portletDescriptors;
    }
}

