/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.translation;

import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.plugin.translation.PortletInstanceTranslationPlugin;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collections;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PortletInstanceTranslationPlugin.class})
@ExtendWith(value={MockitoExtension.class})
public class PortletInstanceTranslationPluginTest {
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private PortletInstanceService portletInstanceService;
    @Autowired
    private PortletInstanceTranslationPlugin translationPlugin;
    private String username = "test";

    @Test
    public void getObjectType() {
        Assertions.assertEquals((Object)"portletInstance", (Object)this.translationPlugin.getObjectType());
        Assertions.assertEquals((Object)"portletInstance", (Object)this.translationPlugin.getObjectType());
    }

    @Test
    public void hasEditPermission() {
        Assertions.assertFalse((boolean)this.translationPlugin.hasEditPermission(0L, null));
        Assertions.assertFalse((boolean)this.translationPlugin.hasEditPermission(0L, this.username));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.username)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.translationPlugin.hasEditPermission(0L, this.username));
    }

    @Test
    public void hasAccessPermission() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.translationPlugin.hasAccessPermission(1L, null));
        PortletInstance portletInstance = (PortletInstance)Mockito.mock(PortletInstance.class);
        Mockito.when((Object)this.portletInstanceService.getPortletInstance(1L)).thenReturn((Object)portletInstance);
        Assertions.assertTrue((boolean)this.translationPlugin.hasAccessPermission(1L, null));
        Assertions.assertTrue((boolean)this.translationPlugin.hasAccessPermission(1L, this.username));
        String permissionExpression = "A Permission Expression";
        Mockito.when((Object)portletInstance.getPermissions()).thenReturn(Collections.singletonList(permissionExpression));
        Assertions.assertFalse((boolean)this.translationPlugin.hasAccessPermission(1L, this.username));
        Mockito.when((Object)this.layoutAclService.isMemberOf(this.username, permissionExpression)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.translationPlugin.hasAccessPermission(1L, this.username));
    }

    @Test
    public void getAudienceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getAudienceId(0L));
    }

    @Test
    public void getSpaceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getSpaceId(0L));
    }
}

