/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.NodeLabel;
import io.meeds.layout.rest.SiteLayoutRest;
import io.meeds.layout.service.SiteLayoutService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={SiteLayoutRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class SiteLayoutRestTest {
    private static final String REST_PATH = "/sites";
    @MockBean
    private SiteLayoutService siteLayoutService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @Mock
    private NodeLabel nodeLabel;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getSiteLabels() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).getSiteLabels(Long.valueOf(2L), null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/2/labels", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).getSiteLabels(Long.valueOf(3L), null);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/3/labels", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        ((SiteLayoutService)Mockito.doReturn((Object)this.nodeLabel).when((Object)this.siteLayoutService)).getSiteLabels(Long.valueOf(4L), null);
        Mockito.when((Object)this.nodeLabel.getDefaultLanguage()).thenReturn((Object)"en");
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/4/labels", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.defaultLanguage", (Object[])new Object[0]).value((Object)"en"));
    }

    @Test
    void getSiteDescriptions() throws Exception {
        ((SiteLayoutService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.siteLayoutService)).getSiteDescriptions(Long.valueOf(2L), null);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/2/descriptions", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        ((SiteLayoutService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.siteLayoutService)).getSiteDescriptions(Long.valueOf(3L), null);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/3/descriptions", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        ((SiteLayoutService)Mockito.doReturn((Object)this.nodeLabel).when((Object)this.siteLayoutService)).getSiteDescriptions(Long.valueOf(4L), null);
        Mockito.when((Object)this.nodeLabel.getDefaultLanguage()).thenReturn((Object)"en");
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sites/4/descriptions", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.defaultLanguage", (Object[])new Object[0]).value((Object)"en"));
    }
}

