/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.translation;

import io.meeds.layout.plugin.translation.PageTemplateTranslationPlugin;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.social.translation.service.TranslationService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PageTemplateTranslationPlugin.class})
@ExtendWith(value={MockitoExtension.class})
public class PageTemplateTranslationPluginTest {
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private TranslationService translationService;
    @Autowired
    private PageTemplateTranslationPlugin translationPlugin;
    private String username = "test";

    @Test
    public void getObjectType() {
        Assertions.assertEquals((Object)"pageTemplate", (Object)this.translationPlugin.getObjectType());
        Assertions.assertEquals((Object)"pageTemplate", (Object)this.translationPlugin.getObjectType());
    }

    @Test
    public void hasEditPermission() {
        Assertions.assertFalse((boolean)this.translationPlugin.hasEditPermission(0L, null));
        Assertions.assertFalse((boolean)this.translationPlugin.hasEditPermission(0L, this.username));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.username)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.translationPlugin.hasEditPermission(0L, this.username));
    }

    @Test
    public void hasAccessPermission() {
        Assertions.assertTrue((boolean)this.translationPlugin.hasAccessPermission(0L, null));
    }

    @Test
    public void getAudienceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getAudienceId(0L));
    }

    @Test
    public void getSpaceId() {
        Assertions.assertEquals((long)0L, (long)this.translationPlugin.getSpaceId(0L));
    }
}

