/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.model.PortletInstanceCategory;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstancePreferencePlugin;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.service.PortletService;
import io.meeds.layout.storage.PortletInstanceCategoryStorage;
import io.meeds.layout.storage.PortletInstanceLayoutStorage;
import io.meeds.layout.storage.PortletInstanceStorage;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.attachment.AttachmentService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PortletInstanceService.class})
@ExtendWith(value={MockitoExtension.class})
public class PortletInstanceServiceTest {
    private static final String DESCRIPTION = "testDescription";
    private static final String TITLE = "testTitle";
    private static final String CONTENT_ID = "test/portlet";
    private static final String USERNAME = "test";
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private LocaleConfigService localeConfigService;
    @MockBean
    private PortletInstanceCategoryStorage portletInstanceCategoryStorage;
    @MockBean
    private PortletInstanceLayoutStorage portletInstanceLayoutStorage;
    @MockBean
    private PortletInstanceStorage portletInstanceStorage;
    @MockBean
    private PortletService portletService;
    @MockBean
    private ListenerService listenerService;
    @Mock
    private PortletInstanceCategory portletInstanceCategory;
    @Mock
    private PortletInstance portletInstance;
    @Mock
    private Application<Portlet> application;
    @Mock
    private LocaleConfig defaultLocaleConfig;
    @Mock
    private LocaleConfig localeConfig;
    @Mock
    private PortletInstancePreferencePlugin plugin;
    @Autowired
    private PortletInstanceService portletInstanceService;
    private String testuser = "testuser";

    @Test
    public void getPortletInstances() {
        Mockito.when((Object)this.portletInstance.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.portletInstance.getContentId()).thenReturn((Object)CONTENT_ID);
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstances()).thenReturn(Collections.singletonList(this.portletInstance));
        List portletInstances = this.portletInstanceService.getPortletInstances();
        Assertions.assertNotNull((Object)portletInstances);
        Assertions.assertEquals((int)1, (int)portletInstances.size());
        Assertions.assertEquals((long)this.portletInstance.getId(), (long)((PortletInstance)portletInstances.get(0)).getId());
        Assertions.assertEquals((Object)this.portletInstance.getContentId(), (Object)((PortletInstance)portletInstances.get(0)).getContentId());
        Assertions.assertNull((Object)((PortletInstance)portletInstances.get(0)).getName());
        Assertions.assertNull((Object)((PortletInstance)portletInstances.get(0)).getDescription());
        Assertions.assertEquals((long)0L, (long)((PortletInstance)portletInstances.get(0)).getIllustrationId());
    }

    @Test
    public void getPortletInstancesByCategoryId() {
        Mockito.when((Object)this.portletInstance.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.portletInstance.getContentId()).thenReturn((Object)CONTENT_ID);
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstances(3L)).thenReturn(Collections.singletonList(this.portletInstance));
        List portletInstances = this.portletInstanceService.getPortletInstances(3L, null, null, false);
        Assertions.assertNotNull((Object)portletInstances);
        Assertions.assertEquals((int)1, (int)portletInstances.size());
        Assertions.assertEquals((long)this.portletInstance.getId(), (long)((PortletInstance)portletInstances.get(0)).getId());
        Assertions.assertEquals((Object)this.portletInstance.getContentId(), (Object)((PortletInstance)portletInstances.get(0)).getContentId());
        Assertions.assertNull((Object)((PortletInstance)portletInstances.get(0)).getName());
        Assertions.assertNull((Object)((PortletInstance)portletInstances.get(0)).getDescription());
        Assertions.assertEquals((long)0L, (long)((PortletInstance)portletInstances.get(0)).getIllustrationId());
    }

    @Test
    public void getPortletInstancesWithExpand() throws ObjectNotFoundException {
        PortletInstance template = this.newPortletInstance();
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
        Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstances()).thenReturn(Collections.singletonList(template));
        List portletInstances = this.portletInstanceService.getPortletInstances();
        Assertions.assertNotNull((Object)portletInstances);
        Assertions.assertEquals((int)1, (int)portletInstances.size());
        Assertions.assertEquals((long)template.getId(), (long)((PortletInstance)portletInstances.get(0)).getId());
        Assertions.assertEquals((Object)template.getContentId(), (Object)((PortletInstance)portletInstances.get(0)).getContentId());
        Assertions.assertEquals((long)template.getIllustrationId(), (long)((PortletInstance)portletInstances.get(0)).getIllustrationId());
        Mockito.when((Object)this.translationService.getTranslationField("portletInstance", template.getId(), "title")).thenThrow(ObjectNotFoundException.class);
        portletInstances = this.portletInstanceService.getPortletInstances();
        Assertions.assertNotNull((Object)portletInstances);
        Assertions.assertEquals((int)1, (int)portletInstances.size());
        Mockito.reset((Object[])new TranslationService[]{this.translationService});
        TranslationField titleTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("portletInstance", template.getId(), "title")).thenReturn((Object)titleTranslationField);
        portletInstances = this.portletInstanceService.getPortletInstances(0L, null, Locale.ENGLISH, true);
        Assertions.assertNotNull((Object)portletInstances);
        Assertions.assertEquals((int)1, (int)portletInstances.size());
        Assertions.assertEquals((long)template.getId(), (long)((PortletInstance)portletInstances.get(0)).getId());
        Assertions.assertEquals((Object)template.getContentId(), (Object)((PortletInstance)portletInstances.get(0)).getContentId());
        Assertions.assertNull((Object)((PortletInstance)portletInstances.get(0)).getName());
        Assertions.assertNull((Object)((PortletInstance)portletInstances.get(0)).getDescription());
        Assertions.assertEquals((long)template.getIllustrationId(), (long)((PortletInstance)portletInstances.get(0)).getIllustrationId());
        String frTitle = TITLE;
        Mockito.when((Object)titleTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.FRENCH, frTitle));
        portletInstances = this.portletInstanceService.getPortletInstances(0L, null, Locale.FRENCH, true);
        Assertions.assertNotNull((Object)portletInstances);
        Assertions.assertEquals((int)1, (int)portletInstances.size());
        Assertions.assertEquals((Object)frTitle, (Object)((PortletInstance)portletInstances.get(0)).getName());
        TranslationField descriptionTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("portletInstance", template.getId(), "description")).thenReturn((Object)descriptionTranslationField);
        String enDesc = DESCRIPTION;
        Mockito.when((Object)descriptionTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.ENGLISH, enDesc));
        portletInstances = this.portletInstanceService.getPortletInstances(0L, null, Locale.ENGLISH, true);
        Assertions.assertNotNull((Object)portletInstances);
        Assertions.assertEquals((int)1, (int)portletInstances.size());
        Assertions.assertEquals((Object)enDesc, (Object)((PortletInstance)portletInstances.get(0)).getDescription());
        Mockito.when((Object)this.attachmentService.getAttachmentFileIds("portletInstance", "2")).thenReturn(Collections.singletonList("32"));
        portletInstances = this.portletInstanceService.getPortletInstances(0L, null, Locale.ENGLISH, true);
        Assertions.assertNotNull((Object)portletInstances);
        Assertions.assertEquals((int)1, (int)portletInstances.size());
        Assertions.assertEquals((long)32L, (long)((PortletInstance)portletInstances.get(0)).getIllustrationId());
    }

    @Test
    public void getPortletInstanceWithExpand() throws ObjectNotFoundException, IllegalAccessException {
        PortletInstance template = this.newPortletInstance();
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
        Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstance(template.getId())).thenReturn((Object)template);
        PortletInstance retrievedPortletInstance = this.portletInstanceService.getPortletInstance(template.getId());
        Assertions.assertNotNull((Object)retrievedPortletInstance);
        Assertions.assertEquals((long)template.getId(), (long)retrievedPortletInstance.getId());
        Assertions.assertEquals((Object)template.getContentId(), (Object)retrievedPortletInstance.getContentId());
        Assertions.assertEquals((long)template.getIllustrationId(), (long)retrievedPortletInstance.getIllustrationId());
        Mockito.when((Object)this.translationService.getTranslationField("portletInstance", template.getId(), "title")).thenThrow(ObjectNotFoundException.class);
        retrievedPortletInstance = this.portletInstanceService.getPortletInstance(2L, null, Locale.FRENCH, true);
        Assertions.assertNotNull((Object)retrievedPortletInstance);
        Mockito.reset((Object[])new TranslationService[]{this.translationService});
        TranslationField titleTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("portletInstance", template.getId(), "title")).thenReturn((Object)titleTranslationField);
        retrievedPortletInstance = this.portletInstanceService.getPortletInstance(2L, null, Locale.FRENCH, true);
        Assertions.assertNotNull((Object)retrievedPortletInstance);
        Assertions.assertEquals((long)template.getId(), (long)retrievedPortletInstance.getId());
        Assertions.assertEquals((Object)template.getContentId(), (Object)retrievedPortletInstance.getContentId());
        Assertions.assertNull((Object)retrievedPortletInstance.getName());
        Assertions.assertNull((Object)retrievedPortletInstance.getDescription());
        Assertions.assertEquals((long)template.getIllustrationId(), (long)retrievedPortletInstance.getIllustrationId());
        String frTitle = TITLE;
        Mockito.when((Object)titleTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.FRENCH, frTitle));
        retrievedPortletInstance = this.portletInstanceService.getPortletInstance(2L, null, Locale.FRENCH, true);
        Assertions.assertEquals((Object)frTitle, (Object)retrievedPortletInstance.getName());
        TranslationField descriptionTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("portletInstance", template.getId(), "description")).thenReturn((Object)descriptionTranslationField);
        String enDesc = DESCRIPTION;
        Mockito.when((Object)descriptionTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.ENGLISH, enDesc));
        retrievedPortletInstance = this.portletInstanceService.getPortletInstance(2L, null, Locale.ENGLISH, true);
        Assertions.assertNotNull((Object)retrievedPortletInstance);
        Assertions.assertEquals((Object)enDesc, (Object)retrievedPortletInstance.getDescription());
        Mockito.when((Object)this.attachmentService.getAttachmentFileIds("portletInstance", "2")).thenReturn(Collections.singletonList("32"));
        retrievedPortletInstance = this.portletInstanceService.getPortletInstance(2L, null, Locale.GERMAN, true);
        Assertions.assertNotNull((Object)retrievedPortletInstance);
        Assertions.assertEquals((long)32L, (long)retrievedPortletInstance.getIllustrationId());
    }

    @Test
    public void getPortletInstance() {
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstance(2L)).thenReturn((Object)this.portletInstance);
        PortletInstance retrievedPortletInstance = this.portletInstanceService.getPortletInstance(3L);
        Assertions.assertNull((Object)retrievedPortletInstance);
        retrievedPortletInstance = this.portletInstanceService.getPortletInstance(2L);
        Assertions.assertNotNull((Object)retrievedPortletInstance);
        Assertions.assertEquals((Object)this.portletInstance, (Object)retrievedPortletInstance);
    }

    @Test
    public void createPortletInstance() throws IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.createPortletInstance(this.portletInstance, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.portletInstanceStorage.createPortletInstance((PortletInstance)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        this.portletInstanceService.createPortletInstance(this.portletInstance, this.testuser);
        ((PortletInstanceStorage)Mockito.verify((Object)this.portletInstanceStorage, (VerificationMode)Mockito.times((int)1))).createPortletInstance(this.portletInstance);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.portletInstance.created", (Object)this.testuser, (Object)this.portletInstance);
    }

    @Test
    public void deletePortletInstance() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.deletePortletInstance(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceService.deletePortletInstance(2L, this.testuser));
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstance(2L)).thenReturn((Object)this.portletInstance);
        Mockito.when((Object)this.portletInstance.isSystem()).thenReturn((Object)true);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.deletePortletInstance(2L, this.testuser));
        Mockito.when((Object)this.portletInstance.isSystem()).thenReturn((Object)false);
        this.portletInstanceService.deletePortletInstance(2L, this.testuser);
        ((AttachmentService)Mockito.verify((Object)this.attachmentService, (VerificationMode)Mockito.times((int)1))).deleteAttachments("portletInstance", "2");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.times((int)1))).deleteTranslationLabels("portletInstance", 2L);
        ((PortletInstanceStorage)Mockito.verify((Object)this.portletInstanceStorage, (VerificationMode)Mockito.times((int)1))).deletePortletInstance(2L);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.portletInstance.deleted", (Object)this.testuser, (Object)this.portletInstance);
    }

    @Test
    public void deletePortletInstanceWhenException() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.deletePortletInstance(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstance(2L)).thenReturn((Object)this.portletInstance);
        ((AttachmentService)Mockito.doThrow(RuntimeException.class).when((Object)this.attachmentService)).deleteAttachments(ArgumentMatchers.anyString(), (String)ArgumentMatchers.any());
        ((TranslationService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.translationService)).deleteTranslationLabels(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong());
        this.portletInstanceService.deletePortletInstance(2L, this.testuser);
        ((PortletInstanceStorage)Mockito.verify((Object)this.portletInstanceStorage, (VerificationMode)Mockito.times((int)1))).deletePortletInstance(2L);
    }

    @Test
    public void updatePortletInstance() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.updatePortletInstance(this.portletInstance, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.portletInstanceStorage.updatePortletInstance((PortletInstance)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        this.portletInstanceService.updatePortletInstance(this.portletInstance, this.testuser);
        ((PortletInstanceStorage)Mockito.verify((Object)this.portletInstanceStorage, (VerificationMode)Mockito.times((int)1))).updatePortletInstance(this.portletInstance);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.portletInstance.updated", (Object)this.testuser, (Object)this.portletInstance);
    }

    @Test
    public void getPortletInstanceCategories() {
        Mockito.when((Object)this.portletInstanceCategory.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.portletInstanceCategory.getIcon()).thenReturn((Object)CONTENT_ID);
        Mockito.when((Object)this.portletInstanceCategoryStorage.getPortletInstanceCategories()).thenReturn(Collections.singletonList(this.portletInstanceCategory));
        List portletInstanceCategories = this.portletInstanceService.getPortletInstanceCategories();
        Assertions.assertNotNull((Object)portletInstanceCategories);
        Assertions.assertEquals((int)1, (int)portletInstanceCategories.size());
        Assertions.assertEquals((long)this.portletInstanceCategory.getId(), (long)((PortletInstanceCategory)portletInstanceCategories.get(0)).getId());
        Assertions.assertEquals((Object)this.portletInstanceCategory.getIcon(), (Object)((PortletInstanceCategory)portletInstanceCategories.get(0)).getIcon());
        Assertions.assertNull((Object)((PortletInstanceCategory)portletInstanceCategories.get(0)).getName());
    }

    @Test
    public void getPortletInstanceCategoriesWithExpand() throws ObjectNotFoundException {
        PortletInstanceCategory category = this.newPortletInstanceCategory();
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
        Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.portletInstanceCategoryStorage.getPortletInstanceCategories()).thenReturn(Collections.singletonList(category));
        List portletInstanceCategorys = this.portletInstanceService.getPortletInstanceCategories();
        Assertions.assertNotNull((Object)portletInstanceCategorys);
        Assertions.assertEquals((int)1, (int)portletInstanceCategorys.size());
        Assertions.assertEquals((long)category.getId(), (long)((PortletInstanceCategory)portletInstanceCategorys.get(0)).getId());
        Assertions.assertEquals((Object)category.getIcon(), (Object)((PortletInstanceCategory)portletInstanceCategorys.get(0)).getIcon());
        Assertions.assertNull((Object)((PortletInstanceCategory)portletInstanceCategorys.get(0)).getName());
        Mockito.when((Object)this.translationService.getTranslationField("portletInstanceCategory", category.getId(), "title")).thenThrow(ObjectNotFoundException.class);
        portletInstanceCategorys = this.portletInstanceService.getPortletInstanceCategories(null, Locale.ENGLISH, true);
        Assertions.assertNotNull((Object)portletInstanceCategorys);
        Assertions.assertEquals((int)1, (int)portletInstanceCategorys.size());
        Mockito.reset((Object[])new TranslationService[]{this.translationService});
        TranslationField titleTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("portletInstanceCategory", category.getId(), "title")).thenReturn((Object)titleTranslationField);
        portletInstanceCategorys = this.portletInstanceService.getPortletInstanceCategories(null, Locale.FRENCH, true);
        Assertions.assertNotNull((Object)portletInstanceCategorys);
        Assertions.assertEquals((int)1, (int)portletInstanceCategorys.size());
        Assertions.assertEquals((long)category.getId(), (long)((PortletInstanceCategory)portletInstanceCategorys.get(0)).getId());
        Assertions.assertEquals((Object)category.getIcon(), (Object)((PortletInstanceCategory)portletInstanceCategorys.get(0)).getIcon());
        Assertions.assertNull((Object)((PortletInstanceCategory)portletInstanceCategorys.get(0)).getName());
        String frTitle = TITLE;
        Mockito.when((Object)titleTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.FRENCH, frTitle));
        portletInstanceCategorys = this.portletInstanceService.getPortletInstanceCategories(null, Locale.FRENCH, true);
        Assertions.assertNotNull((Object)portletInstanceCategorys);
        Assertions.assertEquals((int)1, (int)portletInstanceCategorys.size());
        Assertions.assertEquals((Object)frTitle, (Object)((PortletInstanceCategory)portletInstanceCategorys.get(0)).getName());
        portletInstanceCategorys = this.portletInstanceService.getPortletInstanceCategories(null, Locale.ENGLISH, true);
        Assertions.assertNotNull((Object)portletInstanceCategorys);
        Assertions.assertEquals((int)1, (int)portletInstanceCategorys.size());
    }

    @Test
    public void getPortletInstanceCategoryWithExpand() throws ObjectNotFoundException, IllegalAccessException {
        PortletInstanceCategory category = this.newPortletInstanceCategory();
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
        Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.portletInstanceCategoryStorage.getPortletInstanceCategory(category.getId())).thenReturn((Object)category);
        PortletInstanceCategory retrievedPortletInstanceCategory = this.portletInstanceService.getPortletInstanceCategory(category.getId());
        Assertions.assertNotNull((Object)retrievedPortletInstanceCategory);
        Assertions.assertEquals((long)category.getId(), (long)retrievedPortletInstanceCategory.getId());
        Assertions.assertEquals((Object)category.getIcon(), (Object)retrievedPortletInstanceCategory.getIcon());
        Mockito.when((Object)this.translationService.getTranslationField("portletInstanceCategory", category.getId(), "title")).thenThrow(ObjectNotFoundException.class);
        retrievedPortletInstanceCategory = this.portletInstanceService.getPortletInstanceCategory(category.getId(), null, Locale.FRENCH, true);
        Assertions.assertNotNull((Object)retrievedPortletInstanceCategory);
        Mockito.reset((Object[])new TranslationService[]{this.translationService});
        TranslationField titleTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("portletInstanceCategory", category.getId(), "title")).thenReturn((Object)titleTranslationField);
        retrievedPortletInstanceCategory = this.portletInstanceService.getPortletInstanceCategory(category.getId(), null, Locale.FRENCH, true);
        Assertions.assertNotNull((Object)retrievedPortletInstanceCategory);
        Assertions.assertEquals((long)category.getId(), (long)retrievedPortletInstanceCategory.getId());
        Assertions.assertEquals((Object)category.getIcon(), (Object)retrievedPortletInstanceCategory.getIcon());
        Assertions.assertNull((Object)retrievedPortletInstanceCategory.getName());
        String frTitle = TITLE;
        Mockito.when((Object)titleTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.FRENCH, frTitle));
        retrievedPortletInstanceCategory = this.portletInstanceService.getPortletInstanceCategory(category.getId(), null, Locale.FRENCH, true);
        Assertions.assertEquals((Object)frTitle, (Object)retrievedPortletInstanceCategory.getName());
        retrievedPortletInstanceCategory = this.portletInstanceService.getPortletInstanceCategory(category.getId(), null, Locale.ENGLISH, true);
        Assertions.assertNotNull((Object)retrievedPortletInstanceCategory);
    }

    @Test
    public void getPortletInstanceCategory() {
        Mockito.when((Object)this.portletInstanceCategoryStorage.getPortletInstanceCategory(2L)).thenReturn((Object)this.portletInstanceCategory);
        PortletInstanceCategory retrievedPortletInstanceCategory = this.portletInstanceService.getPortletInstanceCategory(3L);
        Assertions.assertNull((Object)retrievedPortletInstanceCategory);
        retrievedPortletInstanceCategory = this.portletInstanceService.getPortletInstanceCategory(2L);
        Assertions.assertNotNull((Object)retrievedPortletInstanceCategory);
        Assertions.assertEquals((Object)this.portletInstanceCategory, (Object)retrievedPortletInstanceCategory);
    }

    @Test
    public void createPortletInstanceCategory() throws IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.createPortletInstanceCategory(this.portletInstanceCategory, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.portletInstanceCategoryStorage.createPortletInstanceCategory((PortletInstanceCategory)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        this.portletInstanceService.createPortletInstanceCategory(this.portletInstanceCategory, this.testuser);
        ((PortletInstanceCategoryStorage)Mockito.verify((Object)this.portletInstanceCategoryStorage, (VerificationMode)Mockito.times((int)1))).createPortletInstanceCategory(this.portletInstanceCategory);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.portletInstanceCategory.created", (Object)this.testuser, (Object)this.portletInstanceCategory);
    }

    @Test
    public void deletePortletInstanceCategory() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.deletePortletInstanceCategory(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceService.deletePortletInstanceCategory(2L, this.testuser));
        Mockito.when((Object)this.portletInstanceCategoryStorage.getPortletInstanceCategory(2L)).thenReturn((Object)this.portletInstanceCategory);
        Mockito.when((Object)this.portletInstanceCategory.isSystem()).thenReturn((Object)true);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.deletePortletInstanceCategory(2L, this.testuser));
        Mockito.when((Object)this.portletInstanceCategory.isSystem()).thenReturn((Object)false);
        this.portletInstanceService.deletePortletInstanceCategory(2L, this.testuser);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.times((int)1))).deleteTranslationLabels("portletInstanceCategory", 2L);
        ((PortletInstanceCategoryStorage)Mockito.verify((Object)this.portletInstanceCategoryStorage, (VerificationMode)Mockito.times((int)1))).deletePortletInstanceCategory(2L);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.portletInstanceCategory.deleted", (Object)this.testuser, (Object)this.portletInstanceCategory);
    }

    @Test
    public void deletePortletInstanceCategoryWhenException() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.deletePortletInstanceCategory(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.portletInstanceCategoryStorage.getPortletInstanceCategory(2L)).thenReturn((Object)this.portletInstanceCategory);
        ((TranslationService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.translationService)).deleteTranslationLabels(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong());
        this.portletInstanceService.deletePortletInstanceCategory(2L, this.testuser);
        ((PortletInstanceCategoryStorage)Mockito.verify((Object)this.portletInstanceCategoryStorage, (VerificationMode)Mockito.times((int)1))).deletePortletInstanceCategory(2L);
    }

    @Test
    public void updatePortletInstanceCategory() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.portletInstanceService.updatePortletInstanceCategory(this.portletInstanceCategory, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.portletInstanceCategoryStorage.updatePortletInstanceCategory((PortletInstanceCategory)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        this.portletInstanceService.updatePortletInstanceCategory(this.portletInstanceCategory, this.testuser);
        ((PortletInstanceCategoryStorage)Mockito.verify((Object)this.portletInstanceCategoryStorage, (VerificationMode)Mockito.times((int)1))).updatePortletInstanceCategory(this.portletInstanceCategory);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.portletInstanceCategory.updated", (Object)this.testuser, (Object)this.portletInstanceCategory);
    }

    @Test
    public void getPortletInstanceApplication() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceService.getPortletInstanceApplication(2L, 0L, USERNAME));
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstance(2L)).thenReturn((Object)this.portletInstance);
        Mockito.when((Object)this.portletInstanceLayoutStorage.getPortletInstanceApplication(this.portletInstance, 0L)).thenReturn(this.application);
        Application portletInstanceApplication = this.portletInstanceService.getPortletInstanceApplication(2L, 0L, USERNAME);
        Assertions.assertEquals(this.application, (Object)portletInstanceApplication);
    }

    @Test
    public void getPortletInstanceApplicationPlaceholder() {
        Assertions.assertNull((Object)this.portletInstanceService.getPortletInstanceApplication(0L, 0L, USERNAME));
    }

    @Test
    public void getPortletInstancePreferencesWhenNoPlugin() {
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstance(2L)).thenReturn((Object)this.portletInstance);
        Mockito.when((Object)this.application.getStorageId()).thenReturn((Object)"3");
        Mockito.when((Object)this.portletInstanceLayoutStorage.getApplicationPortletName(this.application)).thenReturn((Object)CONTENT_ID);
        Portlet portlet = new Portlet();
        portlet.setValue(USERNAME, "testValue");
        Mockito.when((Object)this.portletInstanceLayoutStorage.getOrCreatePortletInstanceApplication(this.portletInstance)).thenReturn(this.application);
        Mockito.when((Object)this.portletInstanceLayoutStorage.getApplicationPreferences(Long.parseLong(this.application.getStorageId()))).thenReturn((Object)portlet);
        List portletInstancePreferences = this.portletInstanceService.getPortletInstancePreferences(2L, USERNAME);
        Assertions.assertNotNull((Object)portletInstancePreferences);
        Assertions.assertEquals((int)1, (int)portletInstancePreferences.size());
        Assertions.assertEquals((Object)USERNAME, (Object)((PortletInstancePreference)portletInstancePreferences.get(0)).getName());
        Assertions.assertEquals((Object)"testValue", (Object)((PortletInstancePreference)portletInstancePreferences.get(0)).getValue());
    }

    @Test
    public void getPortletInstancePreferencesWithPlugin() {
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstance(2L)).thenReturn((Object)this.portletInstance);
        Mockito.when((Object)this.application.getStorageId()).thenReturn((Object)"3");
        Mockito.when((Object)this.portletInstanceLayoutStorage.getApplicationPortletName(this.application)).thenReturn((Object)CONTENT_ID.split("/")[1]);
        Mockito.when((Object)this.portletInstanceLayoutStorage.getOrCreatePortletInstanceApplication(this.portletInstance)).thenReturn(this.application);
        Mockito.when((Object)this.plugin.getPortletName()).thenReturn((Object)CONTENT_ID.split("/")[1]);
        this.portletInstanceService.addPortletInstancePreferencePlugin(this.plugin);
        try {
            Mockito.when((Object)this.plugin.generatePreferences((Application)ArgumentMatchers.any(), (Portlet)ArgumentMatchers.any())).thenReturn(Collections.singletonList(new PortletInstancePreference(USERNAME, "value")));
            List portletInstancePreferences = this.portletInstanceService.getPortletInstancePreferences(2L, USERNAME);
            Assertions.assertNotNull((Object)portletInstancePreferences);
            Assertions.assertEquals((int)1, (int)portletInstancePreferences.size());
            Assertions.assertEquals((Object)USERNAME, (Object)((PortletInstancePreference)portletInstancePreferences.get(0)).getName());
            Assertions.assertEquals((Object)"value", (Object)((PortletInstancePreference)portletInstancePreferences.get(0)).getValue());
        }
        finally {
            this.portletInstanceService.removePortletInstancePreferencePlugin(this.plugin.getPortletName());
        }
    }

    @Test
    public void getPortletInstancePreferencesWhenNoPluginNoPreferences() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceService.getPortletInstancePreferences(2L, USERNAME));
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstance(2L)).thenReturn((Object)this.portletInstance);
        Mockito.when((Object)this.portletInstanceLayoutStorage.getApplicationPortletName(this.application)).thenReturn((Object)CONTENT_ID.split("/")[1]);
        Mockito.when((Object)this.portletInstanceLayoutStorage.getOrCreatePortletInstanceApplication(this.portletInstance)).thenReturn(this.application);
        Mockito.when((Object)this.application.getStorageId()).thenReturn((Object)"3");
        Assertions.assertNotNull((Object)this.portletInstanceService.getPortletInstancePreferences(2L, USERNAME));
        Assertions.assertEquals((int)0, (int)this.portletInstanceService.getPortletInstancePreferences(2L, USERNAME).size());
    }

    @Test
    public void getPortletInstanceApplicationByInstanceIdAndCreateApplication() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceService.getPortletInstanceApplication(2L, 0L, USERNAME));
        Mockito.when((Object)this.portletInstanceStorage.getPortletInstance(2L)).thenReturn((Object)this.portletInstance);
        Mockito.when((Object)this.portletInstanceLayoutStorage.getPortletInstanceApplication(this.portletInstance, 0L)).thenReturn(this.application);
        Application portletInstanceApplication = this.portletInstanceService.getPortletInstanceApplication(2L, 0L, USERNAME);
        Assertions.assertEquals(this.application, (Object)portletInstanceApplication);
    }

    @Test
    public void getPortletInstanceApplicationByApplicationId() {
        Mockito.when((Object)this.portletInstanceLayoutStorage.getPortletInstanceApplication(null, 3L)).thenReturn(this.application);
        Application portletInstanceApplication = this.portletInstanceService.getPortletInstanceApplication(0L, 3L, USERNAME);
        Assertions.assertEquals(this.application, (Object)portletInstanceApplication);
    }

    private PortletInstanceCategory newPortletInstanceCategory() {
        return new PortletInstanceCategory(3L, null, "icon", true, Collections.singletonList("Everyone"));
    }

    private PortletInstance newPortletInstance() {
        return new PortletInstance(2L, "name", "description", 5L, CONTENT_ID, 0L, Collections.singletonList(new PortletInstancePreference("prefName", "prefValue")), 7L, Collections.singletonList("Everyone"), Collections.singletonList("edit"), true, false, false);
    }
}

