/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service.injection;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.SiteTemplate;
import io.meeds.layout.model.SiteTemplateDescriptor;
import io.meeds.layout.model.SiteTemplateDescriptorList;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.SiteTemplateService;
import io.meeds.layout.service.injection.LayoutTranslationImportService;
import io.meeds.layout.service.injection.SiteTemplateImportService$AjcClosure1;
import io.meeds.layout.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFF)
public class SiteTemplateImportService {
    private static final String SITE_TEMPLATE_IMPORT = "SITE_TEMPLATE_IMPORT";
    private static final Scope SITE_TEMPLATE_IMPORT_SCOPE;
    private static final Context SITE_TEMPLATE_CONTEXT;
    private static final String SITE_TEMPLATE_VERSION = "version";
    private static final Log LOG;
    private static final Random RANDOM;
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private LayoutTranslationImportService layoutTranslationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private SiteTemplateService siteTemplateService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private ConfigurationManager configurationManager;
    @Value(value="${meeds.site.templates.import.override:false}")
    private boolean forceReimport;
    @Value(value="${meeds.site.templates.import.version:1}")
    private long importVersion;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        CompletableFuture.runAsync(this::importSiteTemplates);
    }

    @ContainerTransactional
    public void importSiteTemplates() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SiteTemplateImportService$AjcClosure1 siteTemplateImportService$AjcClosure1 = new SiteTemplateImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(siteTemplateImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected List<SiteTemplateDescriptor> parseDescriptors(URL url) {
        List<SiteTemplateDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                SiteTemplateDescriptorList list2 = JsonUtils.fromJsonString(content, SiteTemplateDescriptorList.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unkown error happened while parsing Site Templates from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected void importDescriptor(SiteTemplateDescriptor descriptor) {
        String descriptorId = descriptor.getNameId();
        long existingId = this.getSettingValue(descriptorId);
        if (this.forceReimport || existingId == 0L) {
            this.importSiteTemplate(descriptor, existingId);
        } else {
            LOG.debug("Ignore re-importing Site Template {}", new Object[]{descriptorId});
        }
    }

    protected void importSiteTemplate(SiteTemplateDescriptor d, long oldId) {
        String descriptorId = d.getNameId();
        LOG.debug("Importing Site Template {}", new Object[]{descriptorId});
        try {
            SiteTemplate siteTemplate = this.saveSiteTemplate(d, oldId);
            if (siteTemplate == null) {
                return;
            }
            if (this.forceReimport || oldId == 0L || siteTemplate.getId() != oldId) {
                LOG.debug("Importing Site Template {} title translations", new Object[]{descriptorId});
                this.saveNames(d, siteTemplate);
                LOG.debug("Importing Site Template {} description translations", new Object[]{descriptorId});
                this.saveDescriptions(d, siteTemplate);
                if (StringUtils.isNotBlank((CharSequence)d.getIllustrationPath())) {
                    LOG.debug("Importing Site Template {} illustration", new Object[]{descriptorId});
                    this.saveIllustration(siteTemplate.getId(), d.getIllustrationPath());
                }
                this.setSettingValue(descriptorId, siteTemplate.getId());
            }
            LOG.debug("Importing Site Template {} finished successfully", new Object[]{descriptorId});
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing Site Template {}", new Object[]{descriptorId, e});
        }
    }

    protected void saveNames(SiteTemplateDescriptor d, SiteTemplate siteTemplate) {
        this.layoutTranslationService.saveTranslationLabels("siteTemplate", siteTemplate.getId(), "title", d.getNames());
    }

    protected void saveDescriptions(SiteTemplateDescriptor d, SiteTemplate siteTemplate) {
        this.layoutTranslationService.saveTranslationLabels("siteTemplate", siteTemplate.getId(), "description", d.getDescriptions());
    }

    protected SiteTemplate saveSiteTemplate(SiteTemplateDescriptor d, long oldId) {
        boolean isNew;
        SiteTemplate siteTemplate = null;
        if (oldId > 0L) {
            siteTemplate = this.siteTemplateService.getSiteTemplate(oldId);
        }
        boolean bl = isNew = siteTemplate == null;
        if (isNew) {
            siteTemplate = new SiteTemplate();
        }
        siteTemplate.setIcon(d.getIcon());
        siteTemplate.setLayout(d.getLayout());
        siteTemplate.setSystem(d.isSystem());
        siteTemplate.setDisabled(d.isDisabled());
        if (isNew) {
            return this.siteTemplateService.createSiteTemplate(siteTemplate);
        }
        return this.siteTemplateService.updateSiteTemplate(siteTemplate);
    }

    protected void saveIllustration(long siteTemplateId, String imagePath) {
        File tempFile = null;
        try {
            tempFile = this.getIllustrationFile(imagePath);
            String uploadId = "SiteTemplateIllustration" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.deleteAttachments("siteTemplate", String.valueOf(siteTemplateId));
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "siteTemplate", String.valueOf(siteTemplateId), null, this.layoutAclService.getSuperUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving Image '%s' as attachment for Site Template '%s'", imagePath, siteTemplateId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    protected void setSettingValue(String name, long value) {
        this.settingService.set(SITE_TEMPLATE_CONTEXT, SITE_TEMPLATE_IMPORT_SCOPE, name, SettingValue.create((String)String.valueOf(value)));
    }

    protected long getSettingValue(String name) {
        try {
            SettingValue settingValue = this.settingService.get(SITE_TEMPLATE_CONTEXT, SITE_TEMPLATE_IMPORT_SCOPE, name);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private File getIllustrationFile(String imagePath) throws Exception {
        try (InputStream inputStream = this.configurationManager.getInputStream(imagePath);){
            File tempFile = File.createTempFile("temp", ".png");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            File file = tempFile;
            return file;
        }
    }

    static {
        SiteTemplateImportService.ajc$preClinit();
        SITE_TEMPLATE_IMPORT_SCOPE = Scope.APPLICATION.id(SITE_TEMPLATE_IMPORT);
        SITE_TEMPLATE_CONTEXT = Context.GLOBAL.id("SITE_TEMPLATE");
        LOG = ExoLogger.getLogger(SiteTemplateImportService.class);
        RANDOM = new Random();
    }

    static final /* synthetic */ void importSiteTemplates_aroundBody0(SiteTemplateImportService ajc$this, JoinPoint joinPoint) {
        if (!ajc$this.forceReimport && ajc$this.getSettingValue(SITE_TEMPLATE_VERSION) != ajc$this.importVersion) {
            ajc$this.forceReimport = true;
        }
        LOG.info("Importing Site Templates with version {}, force reimport = {}", new Object[]{ajc$this.importVersion, ajc$this.forceReimport});
        ConversationState.setCurrent((ConversationState)ajc$this.layoutAclService.getSuperUserConversationState());
        try {
            Collections.list(ajc$this.getClass().getClassLoader().getResources("site-templates.json")).stream().map(ajc$this::parseDescriptors).flatMap(Collection::stream).forEach(ajc$this::importDescriptor);
            LOG.info((Object)"Importing Site Templates finished successfully.");
            LOG.info((Object)"Processing Post Site Templates import");
            ajc$this.layoutTranslationService.postImport("siteTemplate");
            LOG.info((Object)"Processing Post Site Templates import finished");
            ajc$this.setSettingValue(SITE_TEMPLATE_VERSION, ajc$this.importVersion);
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while importing Site Templates", (Throwable)e);
        }
        finally {
            ConversationState.setCurrent(null);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SiteTemplateImportService.java", SiteTemplateImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importSiteTemplates", "io.meeds.layout.service.injection.SiteTemplateImportService", "", "", "", "void"), 114);
    }
}

