/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.rest.PageTemplateRest;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={PageTemplateRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class PageTemplateRestTest {
    private static final String REST_PATH = "/page/templates";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    @MockBean
    private PageTemplateService pageTemplateService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getPageTemplatesAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.pageTemplateService});
    }

    @Test
    void getPageTemplatesWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PageTemplateService)Mockito.verify((Object)this.pageTemplateService)).getPageTemplates((Locale)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
    }

    @Test
    void getPageTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/page/templates/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.pageTemplateService});
    }

    @Test
    void getPageTemplateWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/page/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PageTemplateService)Mockito.verify((Object)this.pageTemplateService)).getPageTemplate(ArgumentMatchers.eq((long)1L), (Locale)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    void createPageTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)new PageTemplate())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.pageTemplateService});
    }

    @Test
    void createPageTemplateWithUser() throws Exception {
        PageTemplate pageTemplate = new PageTemplate();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)pageTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PageTemplateService)Mockito.verify((Object)this.pageTemplateService)).createPageTemplate(pageTemplate, SIMPLE_USER);
    }

    @Test
    void createPageTemplateWithUserForbidden() throws Exception {
        PageTemplate pageTemplate = new PageTemplate();
        Mockito.when((Object)this.pageTemplateService.createPageTemplate(pageTemplate, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)pageTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updatePageTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/page/templates/1", (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)new PageTemplate())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.pageTemplateService});
    }

    @Test
    void updatePageTemplateWithUser() throws Exception {
        PageTemplate pageTemplate = new PageTemplate();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/page/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)pageTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        pageTemplate.setId(1L);
        ((PageTemplateService)Mockito.verify((Object)this.pageTemplateService)).updatePageTemplate(pageTemplate, SIMPLE_USER);
    }

    @Test
    void updatePageTemplateWithUserForbidden() throws Exception {
        PageTemplate pageTemplate = new PageTemplate();
        pageTemplate.setId(1L);
        Mockito.when((Object)this.pageTemplateService.updatePageTemplate(pageTemplate, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/page/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)pageTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updatePageTemplateWithUserNotFound() throws Exception {
        PageTemplate pageTemplate = new PageTemplate();
        pageTemplate.setId(1L);
        Mockito.when((Object)this.pageTemplateService.updatePageTemplate(pageTemplate, SIMPLE_USER)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/page/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)pageTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void deletePageTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/page/templates/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.pageTemplateService});
    }

    @Test
    void deletePageTemplateWithUser() throws Exception {
        PageTemplate pageTemplate = new PageTemplate();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/page/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        pageTemplate.setId(1L);
        ((PageTemplateService)Mockito.verify((Object)this.pageTemplateService)).deletePageTemplate(1L, SIMPLE_USER);
    }

    @Test
    void deletePageTemplateWithUserForbidden() throws Exception {
        PageTemplate pageTemplate = new PageTemplate();
        pageTemplate.setId(1L);
        ((PageTemplateService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.pageTemplateService)).deletePageTemplate(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/page/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deletePageTemplateWithUserNotFound() throws Exception {
        PageTemplate pageTemplate = new PageTemplate();
        pageTemplate.setId(1L);
        ((PageTemplateService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.pageTemplateService)).deletePageTemplate(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/page/templates/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

