/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.rest.SectionTemplateRest;
import io.meeds.layout.service.SectionTemplateService;
import io.meeds.layout.service.injection.SectionTemplateImportService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={SectionTemplateRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class SectionTemplateRestTest {
    private static final String REST_PATH = "/sections";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    @MockBean
    private SectionTemplateService sectionTemplateService;
    @MockBean
    private SectionTemplateImportService sectionTemplateImportService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getSectionTemplatesAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.sectionTemplateService});
    }

    @Test
    void getSectionTemplatesWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((SectionTemplateService)Mockito.verify((Object)this.sectionTemplateService)).getSectionTemplates((Locale)ArgumentMatchers.any());
    }

    @Test
    void getSectionTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sections/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.sectionTemplateService});
    }

    @Test
    void getSectionTemplateWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sections/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((SectionTemplateService)Mockito.verify((Object)this.sectionTemplateService)).getSectionTemplate(ArgumentMatchers.eq((long)1L), (Locale)ArgumentMatchers.any());
    }

    @Test
    void createSectionTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)new SectionTemplate())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.sectionTemplateService});
    }

    @Test
    void createSectionTemplateWithUser() throws Exception {
        SectionTemplate sectionTemplate = new SectionTemplate();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)sectionTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((SectionTemplateService)Mockito.verify((Object)this.sectionTemplateService)).createSectionTemplate(sectionTemplate, SIMPLE_USER);
    }

    @Test
    void createSectionTemplateWithUserForbidden() throws Exception {
        SectionTemplate sectionTemplate = new SectionTemplate();
        Mockito.when((Object)this.sectionTemplateService.createSectionTemplate(sectionTemplate, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)sectionTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateSectionTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/sections/1", (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)new SectionTemplate())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.sectionTemplateService});
    }

    @Test
    void updateSectionTemplateWithUser() throws Exception {
        SectionTemplate sectionTemplate = new SectionTemplate();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/sections/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)sectionTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        sectionTemplate.setId(1L);
        ((SectionTemplateService)Mockito.verify((Object)this.sectionTemplateService)).updateSectionTemplate(sectionTemplate, SIMPLE_USER);
    }

    @Test
    void updateSectionTemplateWithUserForbidden() throws Exception {
        SectionTemplate sectionTemplate = new SectionTemplate();
        sectionTemplate.setId(1L);
        Mockito.when((Object)this.sectionTemplateService.updateSectionTemplate(sectionTemplate, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/sections/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)sectionTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updateSectionTemplateWithUserNotFound() throws Exception {
        SectionTemplate sectionTemplate = new SectionTemplate();
        sectionTemplate.setId(1L);
        Mockito.when((Object)this.sectionTemplateService.updateSectionTemplate(sectionTemplate, SIMPLE_USER)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/sections/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)sectionTemplate)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void generateSectionTemplateNodeIdWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sections/1/nodeId", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((SectionTemplateService)Mockito.verify((Object)this.sectionTemplateService)).generateSectionTemplateNodeId(1L, SIMPLE_USER);
    }

    @Test
    void generateSectionTemplateNodeIdWithUserForbidden() throws Exception {
        Mockito.when((Object)this.sectionTemplateService.generateSectionTemplateNodeId(2L, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sections/2/nodeId", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void generateSectionTemplateNodeIdWithUserNotFound() throws Exception {
        Mockito.when((Object)this.sectionTemplateService.generateSectionTemplateNodeId(3L, SIMPLE_USER)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sections/3/nodeId", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void generateSectionTemplateContentWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sections/1/content", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((SectionTemplateService)Mockito.verify((Object)this.sectionTemplateService)).generateSectionTemplateContent(1L, SIMPLE_USER);
    }

    @Test
    void generateSectionTemplateContentWithUserForbidden() throws Exception {
        Mockito.when((Object)this.sectionTemplateService.generateSectionTemplateContent(2L, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sections/2/content", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void generateSectionTemplateContentWithUserNotFound() throws Exception {
        Mockito.when((Object)this.sectionTemplateService.generateSectionTemplateContent(3L, SIMPLE_USER)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/sections/3/content", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void deleteSectionTemplateAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/sections/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.sectionTemplateService});
    }

    @Test
    void deleteSectionTemplateWithUser() throws Exception {
        SectionTemplate sectionTemplate = new SectionTemplate();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/sections/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        sectionTemplate.setId(1L);
        ((SectionTemplateService)Mockito.verify((Object)this.sectionTemplateService)).deleteSectionTemplate(1L, SIMPLE_USER);
    }

    @Test
    void deleteSectionTemplateWithUserForbidden() throws Exception {
        SectionTemplate sectionTemplate = new SectionTemplate();
        sectionTemplate.setId(1L);
        ((SectionTemplateService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.sectionTemplateService)).deleteSectionTemplate(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/sections/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deleteSectionTemplateWithUserNotFound() throws Exception {
        SectionTemplate sectionTemplate = new SectionTemplate();
        sectionTemplate.setId(1L);
        ((SectionTemplateService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.sectionTemplateService)).deleteSectionTemplate(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/sections/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

