/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.model.SectionTemplateDatabind;
import io.meeds.layout.model.SectionTemplateDetail;
import io.meeds.layout.plugin.SectionTemplateDatabindPlugin$AjcClosure1;
import io.meeds.layout.service.ContainerLayoutService;
import io.meeds.layout.service.PageLayoutService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.service.SectionTemplateService;
import io.meeds.layout.util.DatabindUtils;
import io.meeds.layout.util.EntityMapper;
import io.meeds.layout.util.JsonUtils;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.plugin.DatabindPlugin;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SectionTemplateDatabindPlugin
implements DatabindPlugin {
    @Generated
    private final Object $lock = new Object[0];
    public static final String GLOBAL_SITE_NAME = "global";
    private static final PageKey SECTION_TEMPLATE_EDITOR_SYSTEM_PAGE_KEY;
    private static final String[] EVERYONE_PERMISSIONS;
    private static final Random RANDOM;
    public static final String OBJECT_TYPE = "SectionTemplate";
    public static final String CONFIG_JSON = "config.json";
    public static final String LAYOUT_JSON = "layout.json";
    @Autowired
    private SectionTemplateService sectionTemplateService;
    @Autowired
    private DatabindService databindService;
    @Autowired
    private FileService fileService;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private PortletInstanceService portletInstanceService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private PageLayoutService pageLayoutService;
    @Autowired
    private ContainerLayoutService containerLayoutService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private IdentityManager identityManager;
    private long superUserIdentityId;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.databindService.addPlugin((DatabindPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canHandleDatabind(String objectType, String objectId) {
        return StringUtils.equals((CharSequence)OBJECT_TYPE, (CharSequence)objectType);
    }

    public void serialize(String objectId, ZipOutputStream zipOutputStream, String username) {
        FileItem file;
        TranslationField translationDescriptionField;
        SectionTemplateDetail sectionTemplate = this.sectionTemplateService.getSectionTemplate(Long.parseLong(objectId), Locale.getDefault());
        SectionTemplateDatabind databind = new SectionTemplateDatabind();
        databind.setContent(sectionTemplate.getContent());
        TranslationField translationNameField = this.translationService.getTranslationField("sectionTemplate", Long.parseLong(objectId), "title", username);
        if (translationNameField != null) {
            Map<String, String> names = translationNameField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setNames(names);
        }
        if ((translationDescriptionField = this.translationService.getTranslationField("sectionTemplate", Long.parseLong(objectId), "description", username)) != null) {
            Map<String, String> descriptions = translationDescriptionField.getLabels().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
            databind.setDescriptions(descriptions);
        }
        if ((file = this.fileService.getFile(sectionTemplate.getIllustrationId())) != null) {
            databind.setIllustration(Base64.encodeBase64String((byte[])file.getAsByte()));
        }
        LayoutModel sectionLayoutModel = JsonUtils.fromJsonString(sectionTemplate.getContent(), LayoutModel.class);
        DatabindUtils.retrieveBackgroundImages(sectionLayoutModel, this.fileService);
        databind.setContent(JsonUtils.toJsonString(sectionLayoutModel));
        String jsonData = JsonUtils.toJsonString(databind);
        Page pageLayout = JsonUtils.fromJsonString(sectionTemplate.getContent(), LayoutModel.class).toPage();
        LayoutModel layoutModel = new LayoutModel((ModelObject)pageLayout, this.portletInstanceService, new PortletInstanceContext(true, null));
        DatabindUtils.retrieveBackgroundImages(layoutModel, this.fileService);
        layoutModel.resetStorage();
        String layoutData = JsonUtils.toJsonString(layoutModel);
        this.writeToZip(zipOutputStream, "SectionTemplate-" + sectionTemplate.getId() + "/config.json", jsonData);
        this.writeToZip(zipOutputStream, "SectionTemplate-" + sectionTemplate.getId() + "/layout.json", layoutData);
    }

    public CompletableFuture<Pair<DatabindReport, File>> deserialize(File zipFile, Map<String, String> params, String username) {
        return CompletableFuture.supplyAsync(() -> this.importSectionTemplates(zipFile)).thenApply(processedTemplates -> {
            DatabindReport report = new DatabindReport();
            report.setSuccess(!processedTemplates.isEmpty());
            report.setProcessedItems(processedTemplates);
            return Pair.of((Object)report, (Object)zipFile);
        });
    }

    @ContainerTransactional
    public List<String> importSectionTemplates(File zipFile) {
        File file = zipFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)file);
        Object[] objectArray = new Object[]{this, file, joinPoint};
        SectionTemplateDatabindPlugin$AjcClosure1 sectionTemplateDatabindPlugin$AjcClosure1 = new SectionTemplateDatabindPlugin$AjcClosure1(objectArray);
        return (List)ContainerTransactionalAspect.aspectOf().around(sectionTemplateDatabindPlugin$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private Map<String, SectionTemplateDatabind> extractTemplates(File zipFile) {
        HashMap<String, SectionTemplateDatabind> templateDatabindMap = new HashMap<String, SectionTemplateDatabind>();
        try (ZipInputStream zis = new ZipInputStream((InputStream)new FileInputStream(zipFile), StandardCharsets.UTF_8);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                LayoutModel page;
                int bytesRead;
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                String jsonContent = baos.toString(StandardCharsets.UTF_8);
                String entryName = entry.getName();
                String key = entryName.split("/")[0];
                if (entry.getName().endsWith(CONFIG_JSON)) {
                    SectionTemplateDatabind databind = JsonUtils.fromJsonString(jsonContent, SectionTemplateDatabind.class);
                    if (databind == null) continue;
                    templateDatabindMap.put(key, databind);
                    continue;
                }
                if (!entry.getName().endsWith(LAYOUT_JSON) || (page = JsonUtils.fromJsonString(jsonContent, LayoutModel.class)) == null) continue;
                SectionTemplateDatabind databind = templateDatabindMap.computeIfAbsent(key, k -> new SectionTemplateDatabind());
                databind.setPage(page);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading zip file", e);
        }
        return templateDatabindMap;
    }

    private void saveIllustration(long sectionTemplateId, byte[] illustrationBytes) {
        File tempFile = null;
        try {
            tempFile = DatabindUtils.getIllustrationFile(illustrationBytes);
            String uploadId = "SectionTemplateIllustration" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            this.attachmentService.deleteAttachments("sectionTemplate", String.valueOf(sectionTemplateId));
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "sectionTemplate", String.valueOf(sectionTemplateId), null, this.getSuperUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving illustration as attachment for page template '%s'", sectionTemplateId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    private void saveNames(SectionTemplateDatabind sectionTemplateDatabind, SectionTemplate sectionTemplate) {
        this.translationService.saveTranslationLabels("sectionTemplate", sectionTemplate.getId(), "title", sectionTemplateDatabind.getNames().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue)));
    }

    private void saveDescriptions(SectionTemplateDatabind sectionTemplateDatabind, SectionTemplate sectionTemplate) {
        this.translationService.saveTranslationLabels("sectionTemplate", sectionTemplate.getId(), "description", sectionTemplateDatabind.getDescriptions().entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSectionTemplate(SectionTemplateDatabind sectionTemplateDatabind) {
        Object object = this.$lock;
        synchronized (object) {
            SectionTemplate sectionTemplate = new SectionTemplate();
            LayoutModel page = JsonUtils.fromJsonString(sectionTemplateDatabind.getContent(), LayoutModel.class);
            if (page != null) {
                page.setChildren(sectionTemplateDatabind.getPage().getChildren());
                DatabindUtils.saveAppBackgroundImages(RANDOM.nextLong(), page, this.attachmentService, this.getSuperUserIdentityId());
                sectionTemplate.setContent(JsonUtils.toJsonString(page));
            }
            sectionTemplate.setSystem(false);
            sectionTemplate.setCategory("custom");
            Page systemPage = this.createSectionTemplateSystemPage(JsonUtils.toJsonString(page));
            if (CollectionUtils.isNotEmpty((Collection)systemPage.getChildren())) {
                Container section = (Container)((Container)systemPage.getChildren().getFirst()).getChildren().getFirst();
                this.containerLayoutService.exportPortletPreferences((ModelObject)section);
                LayoutModel sectionLayoutModel = new LayoutModel((ModelObject)section);
                sectionLayoutModel.resetStorage();
                sectionTemplate.setContent(JsonUtils.toJsonString(sectionLayoutModel));
            }
            SectionTemplate createdSectionTemplate = this.sectionTemplateService.createSectionTemplate(sectionTemplate);
            this.saveNames(sectionTemplateDatabind, createdSectionTemplate);
            this.saveDescriptions(sectionTemplateDatabind, createdSectionTemplate);
            if (sectionTemplateDatabind.getIllustration() != null) {
                this.saveIllustration(createdSectionTemplate.getId(), Base64.decodeBase64((String)sectionTemplateDatabind.getIllustration()));
            }
        }
    }

    private void writeToZip(ZipOutputStream zipOutputStream, String filePath, String content) {
        ZipEntry entry = new ZipEntry(filePath);
        zipOutputStream.putNextEntry(entry);
        zipOutputStream.write(content.getBytes(StandardCharsets.UTF_8));
        zipOutputStream.closeEntry();
    }

    private long getSuperUserIdentityId() {
        if (this.superUserIdentityId == 0L) {
            this.superUserIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser()).getId());
        }
        return this.superUserIdentityId;
    }

    private Page createSectionTemplateSystemPage(String sectionTemplateContent) {
        LayoutModel layoutModel = JsonUtils.fromJsonString(sectionTemplateContent, LayoutModel.class);
        if (layoutModel != null) {
            layoutModel.resetStorage();
        }
        Container parentContainer = new Container();
        parentContainer.setTemplate("system:/groovy/portal/webui/container/UIPageLayout.gtmpl");
        parentContainer.setChildren(new ArrayList());
        parentContainer.getChildren().add(EntityMapper.toModelObject(layoutModel));
        Page systemPage = this.layoutService.getPage(SECTION_TEMPLATE_EDITOR_SYSTEM_PAGE_KEY);
        if (systemPage == null) {
            systemPage = new Page();
            systemPage.setAccessPermissions(EVERYONE_PERMISSIONS);
            systemPage.setOwnerType(PortalConfig.PORTAL_TYPE);
            systemPage.setOwnerId(GLOBAL_SITE_NAME);
            systemPage.setName("_sectionTemplateEditor");
            systemPage.setTitle("sectionTemplateSystem");
        }
        systemPage.setChildren(new ArrayList());
        systemPage.getChildren().add(parentContainer);
        PageKey clonedPageKey = systemPage.getPageKey();
        this.layoutService.save(new PageContext(clonedPageKey, Utils.toPageState((Page)systemPage)), systemPage);
        this.pageLayoutService.updatePageLayout(clonedPageKey.format(), systemPage, true, this.userAcl.getSuperUser());
        this.pageLayoutService.impersonatePage(clonedPageKey);
        return this.layoutService.getPage(clonedPageKey);
    }

    static {
        SectionTemplateDatabindPlugin.ajc$preClinit();
        SECTION_TEMPLATE_EDITOR_SYSTEM_PAGE_KEY = new PageKey(SiteKey.portal((String)GLOBAL_SITE_NAME), "_sectionTemplateEditor");
        EVERYONE_PERMISSIONS = new String[]{"Everyone"};
        RANDOM = new Random();
    }

    static final /* synthetic */ List importSectionTemplates_aroundBody0(SectionTemplateDatabindPlugin ajc$this, File zipFile, JoinPoint joinPoint) {
        Map<String, SectionTemplateDatabind> instances = ajc$this.extractTemplates(zipFile);
        ArrayList<String> processedSectionTemplates = new ArrayList<String>();
        for (Map.Entry<String, SectionTemplateDatabind> entry : instances.entrySet()) {
            SectionTemplateDatabind sectionTemplate = entry.getValue();
            ajc$this.processSectionTemplate(sectionTemplate);
            processedSectionTemplates.add(sectionTemplate.getContent());
        }
        return processedSectionTemplates;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SectionTemplateDatabindPlugin.java", SectionTemplateDatabindPlugin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importSectionTemplates", "io.meeds.layout.plugin.SectionTemplateDatabindPlugin", "java.io.File", "zipFile", "", "java.util.List"), 213);
    }
}

