/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.model.SectionTemplateDetail;
import io.meeds.layout.service.ContainerLayoutService;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PortletService;
import io.meeds.layout.service.SectionTemplateService;
import io.meeds.layout.storage.SectionTemplateLayoutStorage;
import io.meeds.layout.storage.SectionTemplateStorage;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.attachment.AttachmentService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={SectionTemplateService.class})
@ExtendWith(value={MockitoExtension.class})
public class SectionTemplateServiceTest {
    private static final String CATEGORY = "category";
    private static final String DESCRIPTION = "testDescription";
    private static final String TITLE = "testTitle";
    private static final String CONTENT = "{}";
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private LocaleConfigService localeConfigService;
    @MockBean
    private SectionTemplateLayoutStorage sectionTemplateLayoutStorage;
    @MockBean
    private ContainerLayoutService containerLayoutService;
    @MockBean
    private SectionTemplateStorage sectionTemplateStorage;
    @MockBean
    private PortletService portletService;
    @MockBean
    private ListenerService listenerService;
    @Mock
    private SectionTemplate sectionTemplate;
    @Mock
    private LocaleConfig defaultLocaleConfig;
    @Mock
    private LocaleConfig localeConfig;
    @Autowired
    private SectionTemplateService sectionTemplateService;
    private String testuser = "testuser";

    @Test
    public void getSectionTemplates() {
        Mockito.when((Object)this.sectionTemplate.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.sectionTemplate.getContent()).thenReturn((Object)CONTENT);
        Mockito.when((Object)this.sectionTemplateStorage.getSectionTemplates()).thenReturn(Collections.singletonList(this.sectionTemplate));
        List sectionTemplates = this.sectionTemplateService.getSectionTemplates();
        Assertions.assertNotNull((Object)sectionTemplates);
        Assertions.assertEquals((int)1, (int)sectionTemplates.size());
        Assertions.assertEquals((long)this.sectionTemplate.getId(), (long)((SectionTemplate)sectionTemplates.get(0)).getId());
        Assertions.assertEquals((Object)this.sectionTemplate.getContent(), (Object)((SectionTemplate)sectionTemplates.get(0)).getContent());
    }

    @Test
    public void getSectionTemplatesWithExpand() throws ObjectNotFoundException {
        SectionTemplate template = this.newSectionTemplate();
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
        Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.sectionTemplateStorage.getSectionTemplates()).thenReturn(Collections.singletonList(template));
        List sectionTemplates = this.sectionTemplateService.getSectionTemplates();
        Assertions.assertNotNull((Object)sectionTemplates);
        Assertions.assertEquals((int)1, (int)sectionTemplates.size());
        Assertions.assertEquals((long)template.getId(), (long)((SectionTemplate)sectionTemplates.get(0)).getId());
        Assertions.assertEquals((Object)template.getContent(), (Object)((SectionTemplate)sectionTemplates.get(0)).getContent());
        Mockito.when((Object)this.translationService.getTranslationField("sectionTemplate", template.getId(), "title")).thenThrow(ObjectNotFoundException.class);
        sectionTemplates = this.sectionTemplateService.getSectionTemplates();
        Assertions.assertNotNull((Object)sectionTemplates);
        Assertions.assertEquals((int)1, (int)sectionTemplates.size());
        Mockito.reset((Object[])new TranslationService[]{this.translationService});
        TranslationField titleTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("sectionTemplate", template.getId(), "title")).thenReturn((Object)titleTranslationField);
        List sectionTemplatesWithDetail = this.sectionTemplateService.getSectionTemplates(Locale.ENGLISH);
        Assertions.assertNotNull((Object)sectionTemplatesWithDetail);
        Assertions.assertEquals((int)1, (int)sectionTemplatesWithDetail.size());
        Assertions.assertEquals((long)template.getId(), (long)((SectionTemplateDetail)sectionTemplatesWithDetail.get(0)).getId());
        Assertions.assertEquals((Object)template.getContent(), (Object)((SectionTemplateDetail)sectionTemplatesWithDetail.get(0)).getContent());
        Assertions.assertNull((Object)((SectionTemplateDetail)sectionTemplatesWithDetail.get(0)).getName());
        Assertions.assertNull((Object)((SectionTemplateDetail)sectionTemplatesWithDetail.get(0)).getDescription());
        String frTitle = TITLE;
        Mockito.when((Object)titleTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.FRENCH, frTitle));
        sectionTemplatesWithDetail = this.sectionTemplateService.getSectionTemplates(Locale.FRENCH);
        Assertions.assertNotNull((Object)sectionTemplatesWithDetail);
        Assertions.assertEquals((int)1, (int)sectionTemplatesWithDetail.size());
        Assertions.assertEquals((Object)frTitle, (Object)((SectionTemplateDetail)sectionTemplatesWithDetail.get(0)).getName());
        TranslationField descriptionTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("sectionTemplate", template.getId(), "description")).thenReturn((Object)descriptionTranslationField);
        String enDesc = DESCRIPTION;
        Mockito.when((Object)descriptionTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.ENGLISH, enDesc));
        sectionTemplatesWithDetail = this.sectionTemplateService.getSectionTemplates(Locale.ENGLISH);
        Assertions.assertNotNull((Object)sectionTemplatesWithDetail);
        Assertions.assertEquals((int)1, (int)sectionTemplatesWithDetail.size());
        Assertions.assertEquals((Object)enDesc, (Object)((SectionTemplateDetail)sectionTemplatesWithDetail.get(0)).getDescription());
        Mockito.when((Object)this.attachmentService.getAttachmentFileIds("sectionTemplate", "2")).thenReturn(Collections.singletonList("32"));
        sectionTemplatesWithDetail = this.sectionTemplateService.getSectionTemplates(Locale.ENGLISH);
        Assertions.assertNotNull((Object)sectionTemplatesWithDetail);
        Assertions.assertEquals((int)1, (int)sectionTemplatesWithDetail.size());
        Assertions.assertEquals((long)32L, (long)((SectionTemplateDetail)sectionTemplatesWithDetail.get(0)).getIllustrationId());
    }

    @Test
    public void getSectionTemplateWithExpand() throws ObjectNotFoundException {
        SectionTemplate template = this.newSectionTemplate();
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
        Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.sectionTemplateStorage.getSectionTemplate(template.getId())).thenReturn((Object)template);
        SectionTemplate retrievedSectionTemplate = this.sectionTemplateService.getSectionTemplate(template.getId());
        Assertions.assertNotNull((Object)retrievedSectionTemplate);
        Assertions.assertEquals((long)template.getId(), (long)retrievedSectionTemplate.getId());
        Assertions.assertEquals((Object)template.getContent(), (Object)retrievedSectionTemplate.getContent());
        Assertions.assertEquals((Object)template.getCategory(), (Object)retrievedSectionTemplate.getCategory());
        Mockito.when((Object)this.translationService.getTranslationField("sectionTemplate", template.getId(), "title")).thenThrow(ObjectNotFoundException.class);
        retrievedSectionTemplate = this.sectionTemplateService.getSectionTemplate(2L, Locale.FRENCH);
        Assertions.assertNotNull((Object)retrievedSectionTemplate);
        Mockito.reset((Object[])new TranslationService[]{this.translationService});
        TranslationField titleTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("sectionTemplate", template.getId(), "title")).thenReturn((Object)titleTranslationField);
        SectionTemplateDetail retrievedSectionTemplateWithDetail = this.sectionTemplateService.getSectionTemplate(2L, Locale.FRENCH);
        Assertions.assertNotNull((Object)retrievedSectionTemplateWithDetail);
        Assertions.assertEquals((long)template.getId(), (long)retrievedSectionTemplateWithDetail.getId());
        Assertions.assertEquals((Object)template.getContent(), (Object)retrievedSectionTemplateWithDetail.getContent());
        Assertions.assertEquals((Object)template.getCategory(), (Object)retrievedSectionTemplateWithDetail.getCategory());
        Assertions.assertNull((Object)retrievedSectionTemplateWithDetail.getName());
        Assertions.assertNull((Object)retrievedSectionTemplateWithDetail.getDescription());
        String frTitle = TITLE;
        Mockito.when((Object)titleTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.FRENCH, frTitle));
        retrievedSectionTemplateWithDetail = this.sectionTemplateService.getSectionTemplate(2L, Locale.FRENCH);
        Assertions.assertEquals((Object)frTitle, (Object)retrievedSectionTemplateWithDetail.getName());
        TranslationField descriptionTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("sectionTemplate", template.getId(), "description")).thenReturn((Object)descriptionTranslationField);
        String enDesc = DESCRIPTION;
        Mockito.when((Object)descriptionTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.ENGLISH, enDesc));
        retrievedSectionTemplateWithDetail = this.sectionTemplateService.getSectionTemplate(2L, Locale.ENGLISH);
        Assertions.assertNotNull((Object)retrievedSectionTemplateWithDetail);
        Assertions.assertEquals((Object)enDesc, (Object)retrievedSectionTemplateWithDetail.getDescription());
        Mockito.when((Object)this.attachmentService.getAttachmentFileIds("sectionTemplate", "2")).thenReturn(Collections.singletonList("32"));
        retrievedSectionTemplateWithDetail = this.sectionTemplateService.getSectionTemplate(2L, Locale.GERMAN);
        Assertions.assertNotNull((Object)retrievedSectionTemplateWithDetail);
        Assertions.assertEquals((long)32L, (long)retrievedSectionTemplateWithDetail.getIllustrationId());
    }

    @Test
    public void getSectionTemplate() {
        Mockito.when((Object)this.sectionTemplateStorage.getSectionTemplate(2L)).thenReturn((Object)this.sectionTemplate);
        SectionTemplate retrievedSectionTemplate = this.sectionTemplateService.getSectionTemplate(3L);
        Assertions.assertNull((Object)retrievedSectionTemplate);
        retrievedSectionTemplate = this.sectionTemplateService.getSectionTemplate(2L);
        Assertions.assertNotNull((Object)retrievedSectionTemplate);
        Assertions.assertEquals((Object)this.sectionTemplate, (Object)retrievedSectionTemplate);
    }

    @Test
    public void createSectionTemplate() throws IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.sectionTemplateService.createSectionTemplate(this.sectionTemplate, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.sectionTemplateStorage.createSectionTemplate((SectionTemplate)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        this.sectionTemplateService.createSectionTemplate(this.sectionTemplate, this.testuser);
        ((SectionTemplateStorage)Mockito.verify((Object)this.sectionTemplateStorage, (VerificationMode)Mockito.times((int)1))).createSectionTemplate(this.sectionTemplate);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.sectionTemplate.created", (Object)this.testuser, (Object)this.sectionTemplate);
    }

    @Test
    public void deleteSectionTemplate() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.sectionTemplateService.deleteSectionTemplate(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.sectionTemplateService.deleteSectionTemplate(2L, this.testuser));
        Mockito.when((Object)this.sectionTemplateStorage.getSectionTemplate(2L)).thenReturn((Object)this.sectionTemplate);
        Mockito.when((Object)this.sectionTemplate.isSystem()).thenReturn((Object)true);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.sectionTemplateService.deleteSectionTemplate(2L, this.testuser));
        Mockito.when((Object)this.sectionTemplate.isSystem()).thenReturn((Object)false);
        this.sectionTemplateService.deleteSectionTemplate(2L, this.testuser);
        ((AttachmentService)Mockito.verify((Object)this.attachmentService, (VerificationMode)Mockito.times((int)1))).deleteAttachments("sectionTemplate", "2");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.times((int)1))).deleteTranslationLabels("sectionTemplate", 2L);
        ((SectionTemplateStorage)Mockito.verify((Object)this.sectionTemplateStorage, (VerificationMode)Mockito.times((int)1))).deleteSectionTemplate(2L);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.sectionTemplate.deleted", (Object)this.testuser, (Object)this.sectionTemplate);
    }

    @Test
    public void deleteSectionTemplateWhenException() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.sectionTemplateService.deleteSectionTemplate(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.sectionTemplateStorage.getSectionTemplate(2L)).thenReturn((Object)this.sectionTemplate);
        ((AttachmentService)Mockito.doThrow(RuntimeException.class).when((Object)this.attachmentService)).deleteAttachments(ArgumentMatchers.anyString(), (String)ArgumentMatchers.any());
        ((TranslationService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.translationService)).deleteTranslationLabels(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong());
        this.sectionTemplateService.deleteSectionTemplate(2L, this.testuser);
        ((SectionTemplateStorage)Mockito.verify((Object)this.sectionTemplateStorage, (VerificationMode)Mockito.times((int)1))).deleteSectionTemplate(2L);
    }

    @Test
    public void generateSectionTemplateNodeId() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.sectionTemplateService.generateSectionTemplateNodeId(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.sectionTemplateService.generateSectionTemplateNodeId(2L, this.testuser));
        Mockito.when((Object)this.sectionTemplateStorage.getSectionTemplate(2L)).thenReturn((Object)this.sectionTemplate);
        NodeData nodeData = (NodeData)Mockito.mock(NodeData.class);
        Mockito.when((Object)nodeData.getId()).thenReturn((Object)"35");
        Mockito.when((Object)this.sectionTemplateLayoutStorage.generateSectionTemplateNodeId(this.sectionTemplate, this.testuser)).thenReturn((Object)nodeData);
        long nodeId = this.sectionTemplateService.generateSectionTemplateNodeId(2L, this.testuser);
        Assertions.assertEquals((long)35L, (long)nodeId);
    }

    @Test
    public void generateSectionTemplateContent() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.sectionTemplateService.generateSectionTemplateContent(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.sectionTemplateService.generateSectionTemplateContent(2L, this.testuser));
        Mockito.when((Object)this.sectionTemplateStorage.getSectionTemplate(2L)).thenReturn((Object)this.sectionTemplate);
        String value = "Layout content";
        Mockito.when((Object)this.sectionTemplateLayoutStorage.generateSectionTemplateContent(this.sectionTemplate, this.testuser)).thenReturn((Object)value);
        String result = this.sectionTemplateService.generateSectionTemplateContent(2L, this.testuser);
        Assertions.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void updateSectionTemplate() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.sectionTemplateService.updateSectionTemplate(this.sectionTemplate, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.sectionTemplateStorage.updateSectionTemplate((SectionTemplate)ArgumentMatchers.any())).thenAnswer(invocation -> invocation.getArgument(0));
        this.sectionTemplateService.updateSectionTemplate(this.sectionTemplate, this.testuser);
        ((SectionTemplateStorage)Mockito.verify((Object)this.sectionTemplateStorage, (VerificationMode)Mockito.times((int)1))).updateSectionTemplate(this.sectionTemplate);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).broadcast("layout.sectionTemplate.updated", (Object)this.testuser, (Object)this.sectionTemplate);
    }

    private SectionTemplate newSectionTemplate() {
        return new SectionTemplate(2L, CATEGORY, CONTENT, true, false);
    }
}

