/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service.injection;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.model.SectionTemplateDescriptor;
import io.meeds.layout.model.SectionTemplateDescriptorList;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.SectionTemplateService;
import io.meeds.layout.service.injection.LayoutTranslationImportService;
import io.meeds.layout.service.injection.SectionTemplateImportService$AjcClosure1;
import io.meeds.layout.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.UploadedAttachmentDetail;
import org.exoplatform.upload.UploadResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFF)
public class SectionTemplateImportService {
    private static final String SECTION_TEMPLATE_IMPORT = "SECTION_TEMPLATE_IMPORT";
    private static final Scope SECTION_TEMPLATE_IMPORT_SCOPE;
    private static final Context SECTION_TEMPLATE_CONTEXT;
    private static final String SECTION_TEMPLATE_VERSION = "version";
    private static final Log LOG;
    private static final Random RANDOM;
    @Autowired
    private LayoutAclService layoutAclService;
    @Autowired
    private LayoutTranslationImportService layoutTranslationService;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private SectionTemplateService sectionTemplateService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private ConfigurationManager configurationManager;
    @Value(value="${meeds.sections.import.override:false}")
    private boolean forceReimport;
    @Value(value="${meeds.sections.import.version:1}")
    private long sectionTemplateImportVersion;
    private List<SectionTemplateDescriptor> sectionTemplateDescriptors;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        CompletableFuture.runAsync(this::importSectionTemplates);
    }

    @ContainerTransactional
    public void importSectionTemplates() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SectionTemplateImportService$AjcClosure1 sectionTemplateImportService$AjcClosure1 = new SectionTemplateImportService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(sectionTemplateImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restoreSectionTemplate(long sectionTemplateId, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (!this.layoutAclService.isAdministrator(username)) {
            throw new IllegalAccessException("User isn't authorized to restore a section template");
        }
        SectionTemplate sectionTemplate = this.sectionTemplateService.getSectionTemplate(sectionTemplateId);
        if (sectionTemplate == null) {
            throw new ObjectNotFoundException(String.format("Section Template with Id %s doesn't exists", sectionTemplateId));
        }
        SectionTemplateDescriptor descriptor = this.sectionTemplateDescriptors.stream().filter(d -> this.getSettingValue(d.getNameId()) == sectionTemplateId).findFirst().orElse(null);
        if (descriptor == null) {
            if (!sectionTemplate.isSystem()) throw new IllegalStateException(String.format("Section Template with Id %s isn't a system Section template", sectionTemplateId));
            sectionTemplate.setSystem(false);
            this.sectionTemplateService.updateSectionTemplate(sectionTemplate);
            return;
        } else {
            this.saveSectionTemplate(descriptor, sectionTemplateId);
        }
    }

    protected List<SectionTemplateDescriptor> parseDescriptors(URL url) {
        List<SectionTemplateDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                SectionTemplateDescriptorList list2 = JsonUtils.fromJsonString(content, SectionTemplateDescriptorList.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unkown error happened while parsing Section Templates from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    protected void importDescriptor(SectionTemplateDescriptor descriptor, boolean override) {
        String descriptorId = descriptor.getNameId();
        long existingId = this.getSettingValue(descriptorId);
        if (override || existingId == 0L) {
            this.importSectionTemplate(descriptor, existingId, override);
        } else {
            LOG.debug("Ignore re-importing Section Template {}", new Object[]{descriptorId});
        }
    }

    protected void importSectionTemplate(SectionTemplateDescriptor d, long oldId, boolean override) {
        String descriptorId = d.getNameId();
        LOG.debug("Importing Section Template {}", new Object[]{descriptorId});
        try {
            SectionTemplate sectionTemplate = this.saveSectionTemplate(d, oldId);
            if (sectionTemplate == null) {
                return;
            }
            if (override || oldId == 0L || sectionTemplate.getId() != oldId) {
                LOG.debug("Importing Section Template {} title translations", new Object[]{descriptorId});
                this.saveNames(d, sectionTemplate);
                LOG.debug("Importing Section Template {} description translations", new Object[]{descriptorId});
                this.saveDescriptions(d, sectionTemplate);
                if (StringUtils.isNotBlank((CharSequence)d.getIllustrationPath())) {
                    LOG.debug("Importing Section Template {} illustration", new Object[]{descriptorId});
                    this.saveIllustration(sectionTemplate.getId(), d.getIllustrationPath());
                }
                this.setSettingValue(descriptorId, sectionTemplate.getId());
            }
            LOG.debug("Importing Section Template {} finished successfully", new Object[]{descriptorId});
        }
        catch (Exception e) {
            LOG.warn("An error occurred while importing Section Template {}", new Object[]{descriptorId, e});
        }
    }

    protected void saveNames(SectionTemplateDescriptor d, SectionTemplate sectionTemplate) {
        this.layoutTranslationService.saveTranslationLabels("sectionTemplate", sectionTemplate.getId(), "title", d.getNames(), false);
    }

    protected void saveDescriptions(SectionTemplateDescriptor d, SectionTemplate sectionTemplate) {
        this.layoutTranslationService.saveTranslationLabels("sectionTemplate", sectionTemplate.getId(), "description", d.getDescriptions(), true);
    }

    protected SectionTemplate saveSectionTemplate(SectionTemplateDescriptor d, long oldId) {
        boolean isNew;
        SectionTemplate sectionTemplate = null;
        if (oldId > 0L) {
            sectionTemplate = this.sectionTemplateService.getSectionTemplate(oldId);
        }
        boolean bl = isNew = sectionTemplate == null;
        if (isNew) {
            sectionTemplate = new SectionTemplate();
        }
        sectionTemplate.setContent(d.getContent());
        sectionTemplate.setCategory(d.getCategory());
        sectionTemplate.setSystem(d.isSystem());
        sectionTemplate.setDisabled(d.isDisabled());
        if (isNew) {
            return this.sectionTemplateService.createSectionTemplate(sectionTemplate);
        }
        return this.sectionTemplateService.updateSectionTemplate(sectionTemplate);
    }

    protected void saveIllustration(long sectionTemplateId, String imagePath) {
        File tempFile = null;
        try {
            tempFile = this.getIllustrationFile(imagePath);
            String uploadId = "SectionTemplateIllustration" + RANDOM.nextLong();
            UploadResource uploadResource = new UploadResource(uploadId);
            uploadResource.setFileName(tempFile.getName());
            uploadResource.setMimeType("image/png");
            uploadResource.setStatus(1);
            uploadResource.setStoreLocation(tempFile.getPath());
            UploadedAttachmentDetail uploadedAttachmentDetail = new UploadedAttachmentDetail(uploadResource);
            this.attachmentService.deleteAttachments("sectionTemplate", String.valueOf(sectionTemplateId));
            this.attachmentService.saveAttachment(uploadedAttachmentDetail, "sectionTemplate", String.valueOf(sectionTemplateId), null, this.layoutAclService.getSuperUserIdentityId());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error while saving Image '%s' as attachment for Section Template '%s'", imagePath, sectionTemplateId), e);
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (IOException e) {
                    tempFile.deleteOnExit();
                }
            }
        }
    }

    protected void setSettingValue(String name, long value) {
        this.settingService.set(SECTION_TEMPLATE_CONTEXT, SECTION_TEMPLATE_IMPORT_SCOPE, name, SettingValue.create((String)String.valueOf(value)));
    }

    protected long getSettingValue(String name) {
        try {
            SettingValue settingValue = this.settingService.get(SECTION_TEMPLATE_CONTEXT, SECTION_TEMPLATE_IMPORT_SCOPE, name);
            return settingValue == null || settingValue.getValue() == null ? 0L : Long.parseLong(settingValue.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private File getIllustrationFile(String imagePath) throws Exception {
        try (InputStream inputStream = this.configurationManager.getInputStream(imagePath);){
            File tempFile = File.createTempFile("temp", ".png");
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            File file = tempFile;
            return file;
        }
    }

    static {
        SectionTemplateImportService.ajc$preClinit();
        SECTION_TEMPLATE_IMPORT_SCOPE = Scope.APPLICATION.id(SECTION_TEMPLATE_IMPORT);
        SECTION_TEMPLATE_CONTEXT = Context.GLOBAL.id("SECTION_TEMPLATE");
        LOG = ExoLogger.getLogger(SectionTemplateImportService.class);
        RANDOM = new Random();
    }

    static final /* synthetic */ void importSectionTemplates_aroundBody0(SectionTemplateImportService ajc$this, JoinPoint joinPoint) {
        if (!ajc$this.forceReimport && ajc$this.getSettingValue(SECTION_TEMPLATE_VERSION) != ajc$this.sectionTemplateImportVersion) {
            ajc$this.forceReimport = true;
        }
        LOG.info("Importing Section Templates with version {}, force reimport = {}", new Object[]{ajc$this.sectionTemplateImportVersion, ajc$this.forceReimport});
        ConversationState.setCurrent((ConversationState)ajc$this.layoutAclService.getSuperUserConversationState());
        try {
            ajc$this.sectionTemplateDescriptors = Collections.list(ajc$this.getClass().getClassLoader().getResources("section-templates.json")).stream().map(ajc$this::parseDescriptors).flatMap(Collection::stream).toList();
            ajc$this.sectionTemplateDescriptors.forEach(d -> this.importDescriptor((SectionTemplateDescriptor)d, this.forceReimport));
            LOG.info((Object)"Importing Section Templates finished successfully.");
            LOG.info((Object)"Processing Post Section Templates import");
            ajc$this.layoutTranslationService.postImport("sectionTemplate");
            LOG.info((Object)"Processing Post Section Templates import finished");
            ajc$this.setSettingValue(SECTION_TEMPLATE_VERSION, ajc$this.sectionTemplateImportVersion);
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurred while importing Section Templates", (Throwable)e);
        }
        finally {
            ConversationState.setCurrent(null);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SectionTemplateImportService.java", SectionTemplateImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "importSectionTemplates", "io.meeds.layout.service.injection.SectionTemplateImportService", "", "", "", "void"), 117);
    }
}

