/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.service.MatrixService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatrixUserLoginListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(MatrixUserLoginListener.class);
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private UserACL userACL;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("exo.core.security.ConversationRegistry.register", (ListenerBase)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<ConversationRegistry, ConversationState> event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        String userId = ((ConversationState)event.getData()).getIdentity().getUserId();
        Identity connectedUserIdentity = ((ConversationState)event.getData()).getIdentity();
        String matrixUserAdmin = PropertyManager.getProperty((String)"meeds.matrix.user.name");
        if (matrixUserAdmin.equals(userId)) {
            return;
        }
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        String matrixRestrictedGroup = PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId");
        if (StringUtils.isNotBlank((CharSequence)matrixRestrictedGroup) && !this.userACL.isUserInGroup(connectedUserIdentity, matrixRestrictedGroup)) {
            return;
        }
        try {
            String matrixUserId = this.matrixService.getMatrixIdForUser(userId);
            if (StringUtils.isBlank((CharSequence)matrixUserId)) {
                org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateUserIdentity(userId);
                this.matrixService.saveUserAccount(userIdentity, true);
            }
        }
        catch (Exception e) {
            LOG.error("Could not add matrix information for user {}", new Object[]{userId, e});
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

