/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.notification.builder;

import io.meeds.chat.notification.mail.MailTemplateProvider;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.TimeConvertUtils;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class MatrixTemplateBuilder
extends AbstractTemplateBuilder {
    private final TemplateProvider templateProvider;
    private final ResourceBundleService resourceBundleService;

    public MatrixTemplateBuilder(MailTemplateProvider mailTemplateProvider, ResourceBundleService resourceBundleService) {
        this.templateProvider = mailTemplateProvider;
        this.resourceBundleService = resourceBundleService;
    }

    protected MessageInfo makeMessage(NotificationContext notificationContext) {
        NotificationInfo notification = notificationContext.getNotificationInfo();
        String language = this.getLanguage(notification);
        String pluginId = notification.getKey().getId();
        String roomType = notification.getValueOwnerParameter("MATRIX_ROOM_TYPE");
        String roomName = notification.getValueOwnerParameter("MATRIX_ROOM_NAME");
        TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)this.templateProvider.getChannelKey(), (String)pluginId, (String)language);
        SocialNotificationUtils.addFooterAndFirstName((String)notification.getTo(), (TemplateContext)templateContext);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(notification.getLastModifiedDate());
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)Locale.of(language), (int)TimeConvertUtils.YEAR));
        Identity senderIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getFrom());
        templateContext.put((Object)"USER", (Object)senderIdentity.getProfile().getFullName());
        templateContext.put((Object)"ROOM", (Object)roomName);
        templateContext.put((Object)"ROOM_TYPE", (Object)roomType);
        templateContext.put((Object)"MESSAGE_LINK", (Object)notification.getValueOwnerParameter("MATRIX_MESSAGE_URL"));
        templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)senderIdentity.getRemoteId()));
        if (StringUtils.isNotBlank((CharSequence)notification.getValueOwnerParameter("MATRIX_ROOM_AVATAR"))) {
            templateContext.put((Object)"AVATAR", (Object)(CommonsUtils.getCurrentDomain() + notification.getValueOwnerParameter("MATRIX_ROOM_AVATAR")));
        }
        String subject = "SUBJECT";
        if (StringUtils.isNotBlank((CharSequence)roomType) && roomType.equals("ONE_TO_ONE")) {
            templateContext.put((Object)subject, (Object)this.resourceBundleService.getSharedString("Notification.subject.onetoone.MatrixMentionReceivedNotificationPlugin", Locale.of(language)).replace("$USER", senderIdentity.getProfile().getFullName()));
        } else {
            templateContext.put((Object)subject, (Object)this.resourceBundleService.getSharedString("Notification.subject.space.MatrixMentionReceivedNotificationPlugin", Locale.of(language)).replace("$USER", senderIdentity.getProfile().getFullName()).replace("$ROOM", roomName));
        }
        String message = notification.getValueOwnerParameter("MATRIX_MESSAGE_CONTENT");
        templateContext.put((Object)"MESSAGE_CONTENT", (Object)message);
        MessageInfo messageInfo = new MessageInfo();
        TemplateUtils.processSubject((TemplateContext)templateContext);
        messageInfo.subject((String)templateContext.get((Object)subject));
        messageInfo.body(TemplateUtils.processGroovy((TemplateContext)templateContext));
        notificationContext.setException(templateContext.getException());
        return messageInfo.end();
    }

    protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
        return false;
    }
}

