/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.stereotype.Service;

@Service
public class MatrixSynchronizationService {
    private static final Log LOG = ExoLogger.getExoLogger(MatrixSynchronizationService.class);
    private MatrixService matrixService;
    private SpaceService spaceService;
    private OrganizationService organizationService;
    private IdentityManager identityManager;
    private static final int SPACES_THRESHOLD = 20;
    private static final int LOADED_USERS_COUNT = 50;

    public MatrixSynchronizationService(MatrixService matrixService, SpaceService spaceService, IdentityManager identityManager, OrganizationService organizationService) {
        this.matrixService = matrixService;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.organizationService = organizationService;
    }

    public void synchronizeSpaces() {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start:: create Matrix rooms for spaces");
        int failedToMigrateSpaces = 0;
        int successfullyMigratedSpaces = 0;
        int spacesCount = 0;
        int ignoredSpaces = 0;
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            Space[] spacesToMigrate;
            ListAccess spaces = this.spaceService.getAllSpacesByFilter(new SpaceFilter());
            spacesCount = spaces.getSize();
            for (int loadedSpaces = 0; loadedSpaces < spacesCount; loadedSpaces += spacesToMigrate.length) {
                int actualSpacesToLoadCount = loadedSpaces + 20 < spacesCount ? 20 : spacesCount - loadedSpaces;
                for (Space space : spacesToMigrate = (Space[])spaces.load(loadedSpaces, actualSpacesToLoadCount)) {
                    Room room = this.matrixService.getRoomBySpace(space);
                    if (room == null || StringUtils.isBlank((CharSequence)room.getRoomId())) {
                        try {
                            String roomId = this.matrixService.createRoom(space);
                            for (String member : space.getMembers()) {
                                Identity memberIdentity = this.identityManager.getOrCreateUserIdentity(member);
                                if (memberIdentity == null || !StringUtils.isNotBlank((CharSequence)((String)memberIdentity.getProfile().getProperty("matrixId")))) continue;
                                String matrixIdOfUser = (String)memberIdentity.getProfile().getProperty("matrixId");
                                this.matrixService.joinUserToRoom(roomId, matrixIdOfUser);
                            }
                            this.matrixService.updateRoomAvatar(space, roomId);
                            ++successfullyMigratedSpaces;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            LOG.error("Could not create a room for space {}", new Object[]{space.getDisplayName(), ie});
                            ++failedToMigrateSpaces;
                        }
                        catch (Exception e) {
                            LOG.error("Could not create a room for space {}", new Object[]{space.getDisplayName(), e});
                            ++failedToMigrateSpaces;
                        }
                        continue;
                    }
                    this.matrixService.updateRoomAvatar(space, room.getRoomId());
                    ++ignoredSpaces;
                    LOG.debug("The space {} has already a room with Id {}", new Object[]{space.getDisplayName(), room.getRoomId()});
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Error while retrieving spaces", ie);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving spaces", e);
        }
        finally {
            RequestLifeCycle.end();
        }
        LOG.info("Summary :: create Matrix rooms for spaces, {} created rooms for {} spaces, {} ignored spaces, {} rooms failed to be created !", new Object[]{successfullyMigratedSpaces, spacesCount, ignoredSpaces, failedToMigrateSpaces});
        if (failedToMigrateSpaces > 0) {
            throw new RuntimeException("Some spaces were not upgraded!");
        }
        LOG.info("End:: create Matrix rooms for spaces in {}", new Object[]{System.currentTimeMillis() - startupTime});
    }

    public void synchronizeUsers() {
        LOG.info((Object)"Start:: create Matrix accounts for users");
        long startupTime = System.currentTimeMillis();
        int totalCheckedUsers = 0;
        int totalUserCount = 0;
        ListAccess users = null;
        String[] restrictedGroups = this.matrixService.getRestrictedGroups();
        if (restrictedGroups == null || restrictedGroups.length == 0) {
            restrictedGroups = new String[]{"/platform/users", "/platform/externals"};
        }
        for (String group : restrictedGroups) {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            try {
                int usersCount;
                users = this.organizationService.getUserHandler().findUsersByGroupId(group);
                int checkedUsers = 0;
                int n = usersCount = users == null ? 0 : users.getSize();
                if (usersCount == 0) {
                    LOG.warn((Object)("No users to migrate in group " + group + ", check that the group has already users, or that its name is wrong in the property matrix.restricted.users.groupId ."));
                }
                while (checkedUsers < usersCount) {
                    User[] usersArray;
                    int usersToCheck = usersCount > checkedUsers + 50 ? 50 : usersCount - checkedUsers;
                    for (User user : usersArray = (User[])users.load(checkedUsers, usersToCheck)) {
                        Space[] spaceArray;
                        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(user.getUserName());
                        Profile userProfile = userIdentity.getProfile();
                        String userMatrixId = (String)userProfile.getProperty("matrixId");
                        String adminOfMatrix = PropertyManager.getProperty((String)"meeds.matrix.user.name");
                        if (StringUtils.isBlank((CharSequence)userMatrixId)) {
                            try {
                                boolean isNew = !userIdentity.getRemoteId().equals(adminOfMatrix);
                                userMatrixId = this.matrixService.saveUserAccount(userIdentity, isNew);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                LOG.warn("Can not create the user {} on Matrix", new Object[]{userIdentity.getRemoteId(), ie.getCause()});
                            }
                            catch (Exception e) {
                                LOG.warn("Can not create the user {} on Matrix", new Object[]{userIdentity.getRemoteId(), e.getCause()});
                            }
                        }
                        if (!StringUtils.isNotBlank((CharSequence)userMatrixId)) continue;
                        this.matrixService.updateUserAvatar(userProfile, userMatrixId);
                        ListAccess userSpaces = this.spaceService.getMemberSpaces(userIdentity.getRemoteId());
                        for (Space space : spaceArray = (Space[])userSpaces.load(0, userSpaces.getSize())) {
                            Room room = this.matrixService.getRoomBySpace(space);
                            if (room == null || !StringUtils.isNotBlank((CharSequence)room.getRoomId())) continue;
                            this.matrixService.joinUserToRoom(room.getRoomId(), userMatrixId);
                        }
                    }
                    LOG.info("Checked Matrix account for {} of {} users", new Object[]{checkedUsers += usersArray.length, usersCount});
                }
                totalCheckedUsers += checkedUsers;
                totalUserCount += usersCount;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Error while creating accounts for users on Matrix", ie);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while creating accounts for users on Matrix", e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
        LOG.info("Summary :: create Matrix accounts for {} users, {} users were checked with their Matrix accounts, {} accounts failed to be created !", new Object[]{totalCheckedUsers, totalUserCount, totalUserCount - totalCheckedUsers});
        if (totalUserCount - totalCheckedUsers > 0) {
            throw new RuntimeException("Some user accounts were not synchronized with Matrix!");
        }
        LOG.info("End:: create Matrix accounts for users took {}", new Object[]{System.currentTimeMillis() - startupTime});
    }
}

