/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service.utils;

import io.meeds.chat.service.utils.HTTPHelper;
import io.meeds.chat.service.utils.MatrixHttpClient;
import java.io.IOException;
import java.net.http.HttpResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class MatrixHttpClientTest {
    MockedStatic<HTTPHelper> MATRIX_HTTP_HELPER;
    String jwtToken = "ThisIsAJWTToken";
    String accessToken = "ThisIsAnAccessTokenForUser";
    HttpResponse<String> responseOK;
    HttpResponse<String> responseTooManyRequests;
    MatrixHttpClient matrixHttpClient = new MatrixHttpClient();

    MatrixHttpClientTest() {
    }

    @Test
    void getAdminAccessToken() throws JsonException, IOException, InterruptedException {
        Mockito.when((Object)this.responseOK.statusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.responseOK.body()).thenReturn((Object)"{\"access_token\":\"thisIsAnAccessToken\"}");
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPostRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(this.responseOK);
        String result = "";
        try {
            result = this.matrixHttpClient.getAdminAccessToken(this.jwtToken);
        }
        catch (Exception e) {
            Assertions.fail();
            throw e;
        }
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"thisIsAnAccessToken", (Object)result);
        HttpResponse response1 = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response1.statusCode()).thenReturn((Object)429);
        Mockito.when(response1.body()).thenReturn((Object)"{\"retry_after_ms\":\"120\"}");
        HttpResponse response2 = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response2.statusCode()).thenReturn((Object)200);
        Mockito.when(response2.body()).thenReturn((Object)"{\"access_token\":\"thisIsAnAccessToken\"}");
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPostRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)response1, new Object[]{response2});
        try {
            result = this.matrixHttpClient.getAdminAccessToken(this.jwtToken);
        }
        catch (Exception e) {
            Assertions.fail();
            throw e;
        }
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"thisIsAnAccessToken", (Object)result);
        ((HttpResponse)Mockito.verify((Object)response1, (VerificationMode)Mockito.times((int)1))).body();
        ((HttpResponse)Mockito.verify((Object)response2, (VerificationMode)Mockito.times((int)1))).body();
    }

    @BeforeEach
    void setUp() {
        PropertyManager.setProperty((String)"meeds.matrix.server.url", (String)"http://matrix:8008");
        PropertyManager.setProperty((String)"meeds.matrix.server.name", (String)"matrix.exo.com");
        PropertyManager.setProperty((String)"meeds.matrix.shared_secret_registration", (String)"sharedSecretRegistration");
        this.MATRIX_HTTP_HELPER = Mockito.mockStatic(HTTPHelper.class);
        this.responseOK = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)this.responseOK.statusCode()).thenReturn((Object)200);
        this.responseTooManyRequests = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)this.responseTooManyRequests.statusCode()).thenReturn((Object)429);
        Mockito.when((Object)this.responseTooManyRequests.body()).thenReturn((Object)"{\"retry_after_ms\":\"120\"}");
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpGetRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(this.responseOK);
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPostRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(this.responseOK);
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPostRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (byte[])((byte[])Mockito.any()))).thenReturn(this.responseOK);
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPutRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(this.responseOK);
    }

    @AfterEach
    void tearDown() {
        this.MATRIX_HTTP_HELPER.close();
    }

    @Test
    void updateUserDisplayName() {
        try {
            this.matrixHttpClient.updateUserDisplayName("@user:matrix.server.com", "Chat Bot", this.accessToken);
        }
        catch (Exception e) {
            Assertions.fail();
        }
        HttpResponse response1 = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response1.statusCode()).thenReturn((Object)429);
        Mockito.when(response1.body()).thenReturn((Object)"{\"retry_after_ms\":\"120\"}");
        HttpResponse response2 = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)response2.statusCode()).thenReturn((Object)200);
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPutRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)response1, new Object[]{response2});
        try {
            this.matrixHttpClient.updateUserDisplayName("@user:matrix.server.com", "Chat Bot", this.accessToken);
        }
        catch (Exception e) {
            Assertions.fail();
        }
        ((HttpResponse)Mockito.verify((Object)response1, (VerificationMode)Mockito.times((int)1))).body();
        ((HttpResponse)Mockito.verify((Object)response2, (VerificationMode)Mockito.times((int)0))).body();
    }

    @Test
    void getUserDisplayName() throws JsonException, IOException, InterruptedException {
        Mockito.when((Object)this.responseOK.body()).thenReturn((Object)"{\"displayname\":\"Chat Bot\"}");
        String displayName = this.matrixHttpClient.getUserDisplayName("@user:matrix.server.com", this.accessToken);
        Assertions.assertNotNull((Object)displayName);
        Assertions.assertEquals((Object)"Chat Bot", (Object)displayName);
    }

    @Test
    void authenticateUser() {
        Mockito.when((Object)this.responseOK.body()).thenReturn((Object)"{\"access_token\":\"Access token for ali\"}");
        String result = null;
        try {
            result = this.matrixHttpClient.authenticateUser("ali", "password");
            Assertions.assertNotNull((Object)result);
            Assertions.assertEquals((Object)"Access token for ali", (Object)result);
            ((HttpResponse)Mockito.verify(this.responseOK, (VerificationMode)Mockito.times((int)1))).body();
        }
        catch (Exception e) {
            Assertions.fail();
        }
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPostRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(this.responseTooManyRequests, new Object[]{this.responseOK});
        try {
            result = this.matrixHttpClient.authenticateUser("ali", "password");
            Assertions.assertNotNull((Object)result);
            Assertions.assertEquals((Object)"Access token for ali", (Object)result);
            ((HttpResponse)Mockito.verify(this.responseTooManyRequests, (VerificationMode)Mockito.times((int)1))).body();
            ((HttpResponse)Mockito.verify(this.responseOK, (VerificationMode)Mockito.times((int)2))).body();
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    void createRoom() {
        Mockito.when((Object)this.responseOK.body()).thenReturn((Object)"{\"room_id\":\"!RoomIdentifier:matrix.exo.com\"}");
        String result = null;
        try {
            result = this.matrixHttpClient.createRoom("Internal Communication", "Discussion room for planning internal news and announcements communication", this.accessToken);
            Assertions.assertNotNull((Object)result);
            Assertions.assertEquals((Object)"!RoomIdentifier", (Object)result);
            ((HttpResponse)Mockito.verify(this.responseOK, (VerificationMode)Mockito.times((int)1))).body();
        }
        catch (Exception e) {
            Assertions.fail();
        }
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPostRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(this.responseTooManyRequests, new Object[]{this.responseOK});
        try {
            result = this.matrixHttpClient.createRoom("Internal Communication", "Discussion room for planning internal news and announcements communication", this.accessToken);
            Assertions.assertNotNull((Object)result);
            Assertions.assertEquals((Object)"!RoomIdentifier", (Object)result);
            ((HttpResponse)Mockito.verify(this.responseTooManyRequests, (VerificationMode)Mockito.times((int)1))).body();
            ((HttpResponse)Mockito.verify(this.responseOK, (VerificationMode)Mockito.times((int)2))).body();
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    void createUserAccount() {
        Mockito.when((Object)this.responseOK.body()).thenReturn((Object)"{\"user_id\":\"@harun:matrix.exo.com\"}");
        HttpResponse nonceResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)nonceResponse.statusCode()).thenReturn((Object)200);
        Mockito.when(nonceResponse.body()).thenReturn((Object)"{\"nonce\":\"ThisIsANonce\"}");
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpGetRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)nonceResponse);
        UserImpl user = new UserImpl("harun");
        String result = null;
        result = this.matrixHttpClient.createUserAccount((User)user, this.accessToken);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"@harun:matrix.exo.com", (Object)result);
        ((HttpResponse)Mockito.verify(this.responseOK, (VerificationMode)Mockito.times((int)1))).body();
    }

    @Test
    void testUpdateUserDisplayName() {
    }

    @Test
    void saveUserAccount() {
    }

    @Test
    void disableAccount() {
    }

    @Test
    void renameRoom() {
    }

    @Test
    void inviteUserToRoom() {
    }

    @Test
    void kickUserFromRoom() {
    }

    @Test
    void joinUserToRoom() {
    }

    @Test
    void makeUserAdminInRoom() {
    }

    @Test
    void getRoomSettings() {
    }

    @Test
    void updateRoomSettings() {
    }

    @Test
    void uploadFile() {
    }

    @Test
    void updateRoomAvatar() {
    }

    @Test
    void updateUserAvatar() {
    }

    @Test
    void deleteRoom() {
    }

    @Test
    void getUserPresence() {
        Mockito.when((Object)this.responseOK.body()).thenReturn((Object)"{\"last_active_ago\": 420845,\"presence\": \"online\"}");
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpGetRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(this.responseOK);
        String result = null;
        try {
            result = this.matrixHttpClient.getUserPresence("user", this.accessToken);
        }
        catch (Exception e) {
            Assertions.fail();
        }
        Assertions.assertNotNull(result);
        Assertions.assertEquals((Object)"online", (Object)result);
        ((HttpResponse)Mockito.verify(this.responseOK, (VerificationMode)Mockito.times((int)1))).body();
    }

    @Test
    void setUserPresence() {
        Mockito.when((Object)this.responseOK.body()).thenReturn((Object)"{}");
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPutRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(this.responseOK);
        String result = null;
        try {
            result = this.matrixHttpClient.setUserPresence("user", "online", "I am online", this.accessToken);
        }
        catch (Exception e) {
            Assertions.fail();
        }
        Assertions.assertNotNull(result);
        ((HttpResponse)Mockito.verify(this.responseOK, (VerificationMode)Mockito.times((int)1))).body();
        this.MATRIX_HTTP_HELPER.when(() -> HTTPHelper.sendHttpPutRequest((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn(this.responseTooManyRequests, new Object[]{this.responseOK});
        try {
            result = this.matrixHttpClient.setUserPresence("user", "online", "I am online", this.accessToken);
            Assertions.assertNotNull((Object)result);
            ((HttpResponse)Mockito.verify(this.responseTooManyRequests, (VerificationMode)Mockito.times((int)1))).body();
            ((HttpResponse)Mockito.verify(this.responseOK, (VerificationMode)Mockito.times((int)2))).body();
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }
}

