/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.chat.model.Room;
import io.meeds.chat.rest.MatrixRest;
import io.meeds.chat.rest.model.Member;
import io.meeds.chat.rest.model.Message;
import io.meeds.chat.rest.model.Presence;
import io.meeds.chat.rest.model.RoomEntity;
import io.meeds.chat.rest.model.RoomList;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.MatrixSynchronizationService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={MatrixRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
class MatrixRestTest {
    private static final String SIMPLE_USER = "user";
    private static final String ADMIN_USER = "admin";
    private static final String TEST_PASSWORD = "testPassword";
    private static final String REST_PATH = "/matrix";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockBean
    private SpaceService spaceService;
    @MockBean
    private MatrixService matrixService;
    @MockBean
    private MatrixSynchronizationService matrixSynchronizationService;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private ResourceBundleService resourceBundleService;
    @MockBean
    private NotificationService notificationService;
    private MockMvc mockMvc;

    MatrixRestTest() {
    }

    @BeforeEach
    public void setUp() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
        PropertyManager.setProperty((String)"meeds.matrix.server.name", (String)"matrix.exo.tn");
    }

    @Test
    public void testProcessRooms() throws Exception {
        RoomEntity roomEntity = this.createRoomEntity(0);
        Room room = new Room();
        room.setRoomId("!testRoom0:matrix.exo.tn");
        room.setSpaceId("spaceId");
        RoomList roomsList = new RoomList();
        roomsList.setTotalUnreadMessages(5L);
        roomsList.setRooms(Collections.singletonList(roomEntity));
        Mockito.when((Object)this.matrixService.getById("!testRoom0")).thenReturn((Object)room);
        Space space = new Space();
        space.setDisplayName("Space of Heroes");
        space.setAvatarUrl("/Url/Of/Avatar.png");
        Mockito.when((Object)this.spaceService.getSpaceById("spaceId")).thenReturn((Object)space);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/processRooms", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).content(MatrixRestTest.asJsonString(roomsList)));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        room.setSpaceId(null);
        room.setFirstParticipant("root");
        room.setSecondParticipant(SIMPLE_USER);
        Identity identity = new Identity();
        identity.setRemoteId(SIMPLE_USER);
        identity.setId("1");
        Profile profile = new Profile();
        profile.setAvatarUrl("/avatar/of/root");
        profile.setProperty("firstName", (Object)"User");
        profile.setProperty("lastName", (Object)"Root");
        identity.setProfile(profile);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("root")).thenReturn((Object)identity);
        Mockito.when((Object)this.matrixService.extractUserId(ArgumentMatchers.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.resourceBundleService.getSharedString(ArgumentMatchers.anyString(), (Locale)ArgumentMatchers.any())).thenReturn((Object)"This is a translated Message ");
        ResultActions response1 = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/processRooms", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).content(MatrixRestTest.asJsonString(roomsList)));
        response1.andExpect(MockMvcResultMatchers.status().isOk());
    }

    private RoomList createRoomsList(int numberOfRooms) {
        ArrayList<RoomEntity> rooms = new ArrayList<RoomEntity>();
        for (int i = 0; i < numberOfRooms; ++i) {
            rooms.add(this.createRoomEntity(i));
        }
        RoomList roomList = new RoomList();
        roomList.setTotalUnreadMessages(20L);
        roomList.setRooms(rooms);
        return roomList;
    }

    private RoomEntity createRoomEntity(int index) {
        RoomEntity room = new RoomEntity();
        room.setId("!testRoom" + index + ":matrix.exo.tn");
        room.setAvatarUrl("/avatar/" + index);
        room.setName("Chat number " + index);
        Member root = new Member("1", "root", "/user/avatar1", System.currentTimeMillis());
        Member user = new Member("2", SIMPLE_USER, "/user/avatar2", System.currentTimeMillis());
        room.setMembers(Arrays.asList(user, root));
        room.setUnreadMessages((long)index);
        room.setPresence("online");
        room.setTopic("No topic");
        room.setUpdated(System.currentTimeMillis());
        Message message = new Message("This is a new message", "@root:matrix.exo.tn");
        room.setLastMessage(message);
        return room;
    }

    private RequestPostProcessor simpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    private RequestPostProcessor adminUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("administrators")});
    }

    public static String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    @Test
    void updatePresenceStatus() throws Exception {
        Presence presence = new Presence();
        presence.setPresence("online");
        presence.setStatusMessage("I am available");
        presence.setUserIdOnMatrix("@user:matrix.exo.tn");
        Mockito.when((Object)this.matrixService.updateUserPresence(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)presence.getPresence());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/matrix/setStatus", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).content(MatrixRestTest.asJsonString(presence)));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().string("online"));
    }

    @Test
    void getIdentityByUserMatrixId() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/userByMatrixId", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("userMatrixId", new String[]{"@user:matrix.exo.tn"}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        Identity identity = new Identity();
        identity.setRemoteId(SIMPLE_USER);
        MockedStatic REST_UTILS = Mockito.mockStatic(RestUtils.class);
        MockedStatic ENTITY_BUILDER = Mockito.mockStatic(EntityBuilder.class);
        ENTITY_BUILDER.when(() -> EntityBuilder.buildEntityProfile((Profile)((Profile)ArgumentMatchers.any(Profile.class)), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)new ProfileEntity());
        REST_UTILS.when(() -> RestUtils.getRestUrl((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenReturn((Object)"/matrix/rest/matrix");
        Mockito.when((Object)this.matrixService.findUserByMatrixId((String)ArgumentMatchers.eq((Object)"@user:matrix.exo.tn"))).thenReturn((Object)identity);
        ResultActions response1 = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/userByMatrixId", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("userMatrixId", new String[]{"@user:matrix.exo.tn"}));
        response1.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getRoomById() throws Exception {
        String roomId = "!testRoomIdentifier:matrix.exo.tn";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/byRoomId", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("roomId", new String[]{roomId}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Room room = new Room();
        room.setRoomId(roomId);
        room.setSpaceId("1");
        Space space = new Space();
        space.setAvatarUrl("/avatar/of/the/space");
        space.setDisplayName("Test space");
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        Mockito.when((Object)this.matrixService.getById((String)ArgumentMatchers.eq((Object)roomId))).thenReturn((Object)room);
        Mockito.when((Object)this.matrixService.canAccess((Room)ArgumentMatchers.eq((Object)room), ArgumentMatchers.anyString())).thenReturn((Object)true);
        ResultActions response1 = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/byRoomId", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("roomId", new String[]{roomId}));
        response1.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getDirectMessagingRoom() throws Exception {
        String roomId = "!testRoomIdentifier:matrix.exo.tn";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/dmRoom", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("firstParticipant", new String[]{"userOne"}).param("secondParticipant", new String[]{"userTwo"}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        Room room = new Room();
        room.setRoomId(roomId);
        room.setSpaceId(null);
        room.setFirstParticipant("userOne");
        room.setSecondParticipant("userTwo");
        Mockito.when((Object)this.matrixService.getDirectMessagingRoom((String)ArgumentMatchers.eq((Object)"userOne"), (String)ArgumentMatchers.eq((Object)"userTwo"))).thenReturn((Object)room);
        ResultActions response1 = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/dmRoom", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("firstParticipant", new String[]{"userOne"}).param("secondParticipant", new String[]{"userTwo"}));
        response1.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void syncUsersAndSpaces() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/sync", (Object[])new Object[0]).with(this.adminUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

