/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.stereotype.Service;

@Service
public class MatrixSynchronizationService {
    private static final Log LOG = ExoLogger.getExoLogger(MatrixSynchronizationService.class);
    private MatrixService matrixService;
    private SpaceService spaceService;
    private IdentityManager identityManager;
    private int SPACES_THRESHOLD = 20;
    private int LOADED_USERS_COUNT = 50;

    public MatrixSynchronizationService(MatrixService matrixService, SpaceService spaceService, IdentityManager identityManager) {
        this.matrixService = matrixService;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    public void synchronizeSpaces() {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start:: create Matrix rooms for spaces");
        int failedToMigrateSpaces = 0;
        int successfullyMigratedSpaces = 0;
        int spacesCount = 0;
        int ignoredSpaces = 0;
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            Space[] spacesToMigrate;
            ListAccess spaces = this.spaceService.getAllSpacesByFilter(new SpaceFilter());
            spacesCount = spaces.getSize();
            for (int loadedSpaces = 0; loadedSpaces < spacesCount; loadedSpaces += spacesToMigrate.length) {
                int actualSpacesToLoadCount = loadedSpaces + this.SPACES_THRESHOLD < spacesCount ? this.SPACES_THRESHOLD : spacesCount - loadedSpaces;
                for (Space space : spacesToMigrate = (Space[])spaces.load(loadedSpaces, actualSpacesToLoadCount)) {
                    Room room = this.matrixService.getRoomBySpace(space);
                    if (room == null || StringUtils.isBlank((CharSequence)room.getRoomId())) {
                        try {
                            String roomId = this.matrixService.createRoom(space);
                            for (String member : space.getMembers()) {
                                Identity memberIdentity = this.identityManager.getOrCreateUserIdentity(member);
                                if (memberIdentity == null || !StringUtils.isNotBlank((CharSequence)((String)memberIdentity.getProfile().getProperty("matrixId")))) continue;
                                String matrixIdOfUser = (String)memberIdentity.getProfile().getProperty("matrixId");
                                this.matrixService.joinUserToRoom(roomId, matrixIdOfUser);
                            }
                            this.matrixService.updateRoomAvatar(space, roomId);
                            ++successfullyMigratedSpaces;
                        }
                        catch (Exception e) {
                            LOG.error("Could not create a room for space {}", new Object[]{space.getDisplayName(), e});
                            ++failedToMigrateSpaces;
                        }
                        continue;
                    }
                    this.matrixService.updateRoomAvatar(space, room.getRoomId());
                    ++ignoredSpaces;
                    LOG.debug("The space {} has already a room with Id {}", new Object[]{space.getDisplayName(), room.getRoomId()});
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while retrieving spaces", e);
        }
        finally {
            RequestLifeCycle.end();
        }
        LOG.info("Summary :: create Matrix rooms for spaces, {} created rooms for {} spaces, {} ignored spaces, {} rooms failed to be created !", new Object[]{successfullyMigratedSpaces, spacesCount, ignoredSpaces, failedToMigrateSpaces});
        if (failedToMigrateSpaces > 0) {
            throw new RuntimeException("Some spaces were not upgraded!");
        }
        LOG.info("End:: create Matrix rooms for spaces in {}", new Object[]{System.currentTimeMillis() - startupTime});
    }

    public void synchronizeUsers() {
        LOG.info((Object)"Start:: create Matrix accounts for users");
        long startupTime = System.currentTimeMillis();
        int checkedUsers = 0;
        int usersCount = 0;
        ListAccess users = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId"))) {
                Space restrictedSpace = this.spaceService.getSpaceByGroupId(PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId"));
                if (restrictedSpace != null) {
                    users = this.identityManager.getSpaceIdentityByProfileFilter(restrictedSpace, new ProfileFilter(), SpaceMemberFilterListAccess.Type.MEMBER, false);
                }
            } else {
                users = this.identityManager.getIdentitiesByProfileFilter("organization", new ProfileFilter(), false);
            }
            usersCount = users == null ? 0 : users.getSize();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while checking users", e);
        }
        if (usersCount == 0) {
            throw new IllegalStateException("No users to migrate, please check the value of the property matrix.restricted.users.groupId or remove it to select all users.");
        }
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            while (checkedUsers < usersCount) {
                Identity[] usersArray;
                int usersToCheck = usersCount > checkedUsers + this.LOADED_USERS_COUNT ? this.LOADED_USERS_COUNT : usersCount - checkedUsers;
                for (Identity user : usersArray = (Identity[])users.load(checkedUsers, usersToCheck)) {
                    Space[] spaceArray;
                    Identity userIdentity = this.identityManager.getOrCreateUserIdentity(user.getRemoteId());
                    Profile userProfile = userIdentity.getProfile();
                    String userMatrixId = (String)userProfile.getProperty("matrixId");
                    String adminOfMatrix = PropertyManager.getProperty((String)"meeds.matrix.user.name");
                    if (StringUtils.isBlank((CharSequence)userMatrixId)) {
                        try {
                            boolean isNew = !user.getRemoteId().equals(adminOfMatrix);
                            userMatrixId = this.matrixService.saveUserAccount(user, isNew);
                        }
                        catch (Exception e) {
                            LOG.warn("Can not create the user {} on Matrix", new Object[]{user.getRemoteId(), e.getCause()});
                        }
                    }
                    if (!StringUtils.isNotBlank((CharSequence)userMatrixId)) continue;
                    this.matrixService.updateUserAvatar(userProfile, userMatrixId);
                    ListAccess userSpaces = this.spaceService.getMemberSpaces(user.getRemoteId());
                    for (Space space : spaceArray = (Space[])userSpaces.load(0, userSpaces.getSize())) {
                        Room room = this.matrixService.getRoomBySpace(space);
                        if (room == null || !StringUtils.isNotBlank((CharSequence)room.getRoomId())) continue;
                        this.matrixService.joinUserToRoom(room.getRoomId(), userMatrixId);
                    }
                }
                LOG.info("Checked Matrix account for {} of {} users", new Object[]{checkedUsers += usersArray.length, usersCount});
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating accounts for users on Matrix", e);
        }
        finally {
            RequestLifeCycle.end();
        }
        LOG.info("Summary :: create Matrix accounts for {} users, {} users were checked with their Matrix accounts, {} accounts failed to be created !", new Object[]{checkedUsers, usersCount, usersCount - checkedUsers});
        if (usersCount - checkedUsers > 0) {
            throw new RuntimeException("Some user accounts were not synchronized with Matrix!");
        }
        LOG.info("End:: create Matrix accounts for users took {}", new Object[]{System.currentTimeMillis() - startupTime});
    }
}

