/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.meeds.chat.MatrixBaseTest;
import io.meeds.chat.model.MatrixMessage;
import io.meeds.chat.model.Room;
import io.meeds.chat.service.ChatNotificationService;
import io.meeds.chat.service.MatrixService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.service.PwaNotificationService;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={MatrixBaseTest.class})
class ChatNotificationServiceTest
extends MatrixBaseTest {
    @Autowired
    MatrixService matrixService;
    @Autowired
    IdentityManager identityManager;
    @Autowired
    ChatNotificationService chatNotificationService;
    @Autowired
    PwaNotificationService pwaNotificationService;

    ChatNotificationServiceTest() {
    }

    @Test
    void sendCreateNotificationAction() {
        ScheduledFuture action = this.chatNotificationService.sendCreateNotificationAction("eventIDOnMatrix", "demo", "!roomId:matrix.meeds.tn", 5);
        Assertions.assertNotNull((Object)action);
    }

    @Test
    void createNotification() throws Exception {
        String eventId = "eventIDOnMatrix";
        Space space = this.getSpaceInstance(1);
        String roomId = this.matrixService.createRoom(space);
        this.roomsToDelete.add(roomId);
        String userName = "demo";
        Identity demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        String userIdOnMatrix = this.matrixService.saveUserAccount(demoIdentity, true);
        MatrixMessage matrixMessage = new MatrixMessage(eventId, roomId, "m.room.message", "This is a chat message", "m.text", userIdOnMatrix, new ArrayList());
        Mockito.when((Object)this.matrixHttpClient.getEventById(eventId, this.matrixRoomId, this.accessToken)).thenReturn((Object)matrixMessage);
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(Locale.ENGLISH);
        localeConfig.setOrientation(Orientation.LT);
        PwaNotificationMessage pwaNotificationMessage = this.chatNotificationService.createNotification(eventId, this.matrixRoomId, userName, this.accessToken);
        Assertions.assertNotNull((Object)pwaNotificationMessage);
        Assertions.assertEquals((Object)"Demo exo in my space 1", (Object)pwaNotificationMessage.getTitle());
        Assertions.assertEquals((Object)"This is a chat message", (Object)pwaNotificationMessage.getBody());
        Room oneToOneRoom = new Room();
        oneToOneRoom.setRoomId("!oneToOneRoom:matrix.meeds.tn");
        oneToOneRoom.setFirstParticipant("demo");
        oneToOneRoom.setSecondParticipant("tom");
        oneToOneRoom = this.matrixService.createDirectMessagingRoom(oneToOneRoom);
        Identity tomIdentity = this.identityManager.getOrCreateUserIdentity("tom");
        matrixMessage = new MatrixMessage(eventId, oneToOneRoom.getRoomId(), "m.room.message", "This is a private chat message", "m.text", userIdOnMatrix, new ArrayList());
        Mockito.when((Object)this.matrixHttpClient.getEventById(eventId, oneToOneRoom.getRoomId(), this.accessToken)).thenReturn((Object)matrixMessage);
        pwaNotificationMessage = this.chatNotificationService.createNotification(eventId, oneToOneRoom.getRoomId(), userName, this.accessToken);
        Assertions.assertNotNull((Object)pwaNotificationMessage);
        Assertions.assertNotNull((Object)pwaNotificationMessage.getIcon());
        Assertions.assertEquals((Object)tomIdentity.getProfile().getFullName(), (Object)pwaNotificationMessage.getTitle());
        Assertions.assertEquals((Object)"This is a private chat message", (Object)pwaNotificationMessage.getBody());
    }
}

