/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service.utils;

import io.meeds.chat.model.MatrixMessage;
import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.service.utils.HTTPHelper;
import io.meeds.chat.service.utils.PasswordKeyGenerator;
import java.io.IOException;
import java.net.URLEncoder;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.jsoup.Jsoup;
import org.springframework.stereotype.Component;

@Component
public class MatrixHttpClient {
    private static final Log LOG = ExoLogger.getLogger((String)MatrixHttpClient.class.toString());

    public String getAdminAccessToken(String userJWTToken) throws JsonException, IOException, InterruptedException {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        if (StringUtils.isEmpty((CharSequence)userJWTToken)) {
            throw new IllegalArgumentException("The username of the admin the Matrix server is required, please provide it using System properties !");
        }
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/r0/login";
        String payload = "{\n  \"type\":\"org.matrix.login.jwt\",\n  \"token\": \"%s\"\n}\n".formatted(userJWTToken);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, "", payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
                return jsonGenerator.createJsonObjectFromString(response.body()).getElement("access_token").getStringValue();
            }
            if (response.statusCode() == 429) {
                long sleepInMs = new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("retry_after_ms").getLongValue();
                LOG.warn("Too many requests on Matrix server, retrying the authentication of the admin after {}ms", new Object[]{sleepInMs});
                Thread.sleep(sleepInMs);
                return this.getAdminAccessToken(userJWTToken);
            }
            LOG.error("Error Authenticating admin account with JWT, Matrix server returned HTTP {} error {}", new Object[]{String.valueOf(response.statusCode()), response.body()});
            throw new IllegalStateException("Could not authenticate Admin account on Matrix");
        }
        catch (Exception e) {
            LOG.error("Could not authenticate Admin account with JWT on Matrix", new Object[]{e.getMessage()});
            throw e;
        }
    }

    public String authenticateUser(String userName, String password) throws JsonException, IOException, InterruptedException {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/login";
        String payload = "  {\n    \"identifier\": {\n      \"type\": \"m.id.user\",\n      \"user\": \"%s\"\n    },\n    \"password\": \"%s\",\n      \"type\": \"m.login.password\"\n  }\n\n".formatted(userName, password);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, "", payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
                return jsonGenerator.createJsonObjectFromString(response.body()).getElement("access_token").getStringValue();
            }
            if (response.statusCode() == 429) {
                long sleepInMs = new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("retry_after_ms").getLongValue();
                LOG.warn("Too many requests on Matrix server, retrying the authentication of {} after {}ms", new Object[]{userName, sleepInMs});
                Thread.sleep(sleepInMs);
                return this.authenticateUser(userName, password);
            }
            LOG.error("Error Authenticating user {} with a password, Matrix server returned HTTP {} error {}", new Object[]{userName, String.valueOf(response.statusCode()), response.body()});
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not authenticate Admin account with JWT on Matrix", (Throwable)e);
            throw e;
        }
    }

    public String createRoom(String name, String description, String token) throws Exception {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/createRoom";
        String payload = "{\n  \"name\": \"%s\",\n  \"topic\": \"%s\",\n  \"preset\": \"private_chat\",\n  \"visibility\": \"private\",\n  \"initial_state\": [\n    {\n      \"type\": \"m.room.guest_access\",\n      \"state_key\": \"\",\n      \"content\": {\n        \"guest_access\": \"forbidden\"\n      }\n    }\n  ]\n}\n".formatted(name.replace("\"", "\\\""), this.cleanDescription(description));
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, token, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
                String roomId = jsonGenerator.createJsonObjectFromString(response.body()).getElement("room_id").getStringValue();
                return roomId.substring(0, roomId.indexOf(":" + PropertyManager.getProperty((String)"meeds.matrix.server.name")));
            }
            if (response.statusCode() == 429) {
                long sleepInMs = new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("retry_after_ms").getLongValue();
                LOG.warn("Too many requests on Matrix server, retrying the creation of the room of {} after {}ms", new Object[]{name, sleepInMs});
                Thread.sleep(sleepInMs);
                return this.createRoom(name, description, token);
            }
            LOG.error("Error creating a team, Matrix server returned HTTP {} error {}", new Object[]{String.valueOf(response.statusCode()), response.body()});
            throw new Exception("Error creating a team, Matrix server returned HTTP %s error %s".formatted(String.valueOf(response.statusCode()), response.body()));
        }
        catch (Exception e) {
            LOG.error((Object)"Could not create a team on Matrix", (Throwable)e);
            throw e;
        }
    }

    private String cleanDescription(String description) {
        String plainTextDescription = Jsoup.parse((String)description).text();
        if (StringUtils.isNotBlank((CharSequence)plainTextDescription)) {
            return plainTextDescription.replace("\"", "\\\"");
        }
        return "";
    }

    public String createUserAccount(User user, String token) {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String nonce = this.getRegistrationNonce(token);
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_synapse/admin/v1/register";
        String hmac = this.hmacUserProperties(nonce, user.getUserName(), user.getUserName(), false);
        String payload = "{\n   \"nonce\": \"%s\",\n   \"username\": \"%s\",\n   \"displayname\": \"%s\",\n   \"password\": \"%s\",\n   \"admin\": false,\n   \"mac\": \"%s\"\n  }\n".formatted(nonce, this.cleanMatrixUsername(user.getUserName()), user.getDisplayName(), user.getUserName(), hmac);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, token, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
                JsonValue userAccount = jsonGenerator.createJsonObjectFromString(response.body());
                return userAccount.getElement("user_id").getStringValue();
            }
            LOG.error("Error creating a user account, Matrix server returned HTTP {} error {}", new Object[]{String.valueOf(response.statusCode()), response.body()});
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not create a user account on Matrix", (Throwable)e);
            return null;
        }
    }

    public void updateUserDisplayName(String userMatrixId, String displayName, String token) throws IOException, InterruptedException, JsonException {
        String payload;
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String encodedUserMatrixId = URLEncoder.encode(userMatrixId, StandardCharsets.UTF_8);
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/profile/" + encodedUserMatrixId + "/displayname";
        HttpResponse<String> response = HTTPHelper.sendHttpPutRequest(url, token, payload = "{\n  \"displayname\": \"%s\"\n}\n".formatted(displayName));
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            LOG.info("The display name of the User {} was updated successfully", new Object[]{userMatrixId});
        } else if (response.statusCode() == 429) {
            long sleepInMs = new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("retry_after_ms").getLongValue();
            LOG.warn("Too many requests on Matrix server, retrying to update the display name of the user {} after {}ms", new Object[]{userMatrixId, sleepInMs});
            Thread.sleep(sleepInMs);
            this.updateUserDisplayName(userMatrixId, displayName, token);
        } else {
            throw new RuntimeException("Error Updating the display name of the user %s, Matrix server returned HTTP %s error %s".formatted(userMatrixId, String.valueOf(response.statusCode()), response.body()));
        }
    }

    public String saveUserAccount(Identity user, String matrixUserId, boolean isNew, String token) {
        return this.saveUserAccount(user, matrixUserId, isNew, token, false, true);
    }

    public String saveUserAccount(Identity user, String matrixUserId, boolean isNew, String token, boolean isEnableUserOperation, boolean isUserEnabled) {
        String payload;
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String fullMatrixUserId = "@%s:%s".formatted(this.cleanMatrixUsername(matrixUserId), PropertyManager.getProperty((String)"meeds.matrix.server.name"));
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_synapse/admin/v2/users/" + fullMatrixUserId;
        String password = null;
        if (isNew) {
            password = PasswordKeyGenerator.generatePassword(10);
            payload = " {\n  \"password\": \"%s\",\n  \"logout_devices\": false,\n  \"displayname\": \"%s\",\n  \"threepids\": [\n      {\n          \"medium\": \"email\",\n          \"address\": \"%s\"\n      }\n  ],\n  \"user_type\": null,\n  \"locked\": false\n}\n".formatted(password, user.getRemoteId(), user.getProfile().getEmail());
        } else {
            payload = isEnableUserOperation && isUserEnabled ? "{\n \"password\": \"%s\",\n \"displayname\": \"%s\",\n \"threepids\": [\n   {\n     \"medium\": \"email\",\n     \"address\": \"%s\"\n   }\n ],\n \"deactivated\": %s\n }\n".formatted(PasswordKeyGenerator.generatePassword(10), user.getProfile().getFullName(), user.getProfile().getEmail(), String.valueOf(false)) : "{\n  \"displayname\": \"%s\",\n  \"threepids\": [\n    {\n      \"medium\": \"email\",\n      \"address\": \"%s\"\n    }\n  ],\n  \"deactivated\": %s\n}\n".formatted(user.getProfile().getFullName(), user.getProfile().getEmail(), String.valueOf(!isUserEnabled));
        }
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPutRequest(url, token, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
                JsonValue userAccount = jsonGenerator.createJsonObjectFromString(response.body());
                String fullMatrixID = userAccount.getElement("name").getStringValue();
                if (isNew) {
                    this.authenticateUser(matrixUserId, password);
                    LOG.info("User {} authenticated successfully", new Object[]{user.getRemoteId()});
                }
                return fullMatrixID.contains(":") ? fullMatrixID.substring(1, fullMatrixID.indexOf(":")) : fullMatrixID;
            }
            throw new RuntimeException("Error creating a user account, Matrix server returned HTTP %s error %s".formatted(response.statusCode(), response.body()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create a user account on Matrix", e);
        }
    }

    private String hmacUserProperties(String nonce, String userName, String password, boolean isAdmin) {
        String userProperties = nonce + "\u0000" + userName + "\u0000" + password + "\u0000" + (isAdmin ? "admin" : "notadmin");
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_1, PropertyManager.getProperty((String)"meeds.matrix.shared_secret_registration")).hmacHex(userProperties);
    }

    private String getRegistrationNonce(String accessToken) {
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_synapse/admin/v1/register";
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpGetRequest(url, accessToken);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
                JsonValue jsonResponse = jsonGenerator.createJsonObjectFromString(response.body());
                return jsonResponse.getElement("nonce").getStringValue();
            }
            LOG.error("Error getting Nonce, Matrix server returned HTTloginP {} error {}", new Object[]{String.valueOf(response.statusCode()), response.body()});
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not get the nonce on Matrix", (Throwable)e);
            return null;
        }
    }

    public String disableAccount(String userName, boolean eraseData, String token) {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_synapse/admin/v1/deactivate/" + userName;
        String payload = "{\n  \"erase\": %s\n}\n".formatted(Boolean.FALSE.toString());
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, token, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
                JsonValue jsonResponse = jsonGenerator.createJsonObjectFromString(response.body());
                return jsonResponse.getElement("id_server_unbind_result").getStringValue();
            }
            LOG.error("Error deactivating user, Matrix server returned HTTP {} error {}", new Object[]{String.valueOf(response.statusCode()), response.body()});
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not deactivate the user on Matrix", (Throwable)e);
            return null;
        }
    }

    public String renameRoom(String roomId, String newRoomName, String token) {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String fullRoomId = roomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/rooms/" + fullRoomId + "/state/m.room.name/";
        String payload = "{\n  \"name\": \"%s\"\n}\n".formatted(newRoomName);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPutRequest(url, token, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
                JsonValue jsonResponse = jsonGenerator.createJsonObjectFromString(response.body());
                return jsonResponse.getElement("event_id").getStringValue();
            }
            LOG.error("Error renaming the room {}, Matrix server returned HTTP {} error {}", new Object[]{roomId, String.valueOf(response.statusCode()), response.body()});
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not rename the room on Matrix", (Throwable)e);
            return null;
        }
    }

    public boolean inviteUserToRoom(String roomId, String userMatrixId, String invitationMessage, String token) {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String fullRoomId = roomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String fullMatrixUserId = "@%s:%s".formatted(userMatrixId, PropertyManager.getProperty((String)"meeds.matrix.server.name"));
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/rooms/" + fullRoomId + "/invite";
        String payload = "  {\n    \"reason\": \"%s\",\n    \"user_id\": \"%s\"\n  }\n".formatted(invitationMessage, fullMatrixUserId);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, token, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOG.info("User {} successfully invited to room {}", new Object[]{userMatrixId, roomId});
                return true;
            }
            LOG.error("Error inviting user {} to the room {}, Matrix server returned HTTP {} error {}", new Object[]{userMatrixId, roomId, String.valueOf(response.statusCode()), response.body()});
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not invite a user to a room on Matrix", (Throwable)e);
            return false;
        }
    }

    public void kickUserFromRoom(String roomId, String userMatrixId, String raisonMessage, String token) {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String fullRoomId = roomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String fullMatrixUserId = "@%s:%s".formatted(userMatrixId, PropertyManager.getProperty((String)"meeds.matrix.server.name"));
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/rooms/" + fullRoomId + "/kick";
        String payload = "  {\n    \"reason\": \"%s\",\n    \"user_id\": \"%s\"\n  }\n".formatted(raisonMessage, fullMatrixUserId);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, token, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOG.info("User {} successfully kicked out of room {}", new Object[]{userMatrixId, roomId});
            } else {
                LOG.error("Error kicking user {} from room {}, Matrix server returned HTTP {} error {}", new Object[]{userMatrixId, roomId, String.valueOf(response.statusCode()), response.body()});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not kick out a user from the room on Matrix", (Throwable)e);
        }
    }

    public boolean joinUserToRoom(String matrixRoomId, String matrixIdOfUser, String token) {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String fullUserMatrixId = "@%s:%s".formatted(matrixIdOfUser, PropertyManager.getProperty((String)"meeds.matrix.server.name"));
        String fullRoomId = matrixRoomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_synapse/admin/v1/join/" + fullRoomId;
        String payload = "  {\n    \"user_id\": \"%s\"\n  }\n".formatted(fullUserMatrixId);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, token, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOG.info("User {} successfully joined the room {}", new Object[]{matrixIdOfUser, matrixRoomId});
                return true;
            }
            if (response.statusCode() == 429) {
                long sleepInMs = new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("retry_after_ms").getLongValue();
                LOG.warn("Too many requests on Matrix server, retrying to join the user {} on the room {} after {}ms", new Object[]{matrixIdOfUser, matrixRoomId, sleepInMs});
                Thread.sleep(sleepInMs);
                return this.joinUserToRoom(matrixRoomId, matrixIdOfUser, token);
            }
            LOG.error("Error joining user {} to the room {}, Matrix server returned HTTP {} error {}", new Object[]{matrixIdOfUser, matrixRoomId, String.valueOf(response.statusCode()), response.body()});
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not join a user to a room on Matrix", (Throwable)e);
            return false;
        }
    }

    public boolean makeUserAdminInRoom(String matrixRoomId, String matrixIdOfUser, String token) {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String fullUserMatrixId = "@%s:%s".formatted(matrixIdOfUser, PropertyManager.getProperty((String)"meeds.matrix.server.name"));
        String fullRoomId = matrixRoomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_synapse/admin/v1/rooms/" + fullRoomId + "/make_room_admin";
        String payload = "  {\n    \"user_id\": \"%s\"\n  }\n".formatted(fullUserMatrixId);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, token, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOG.info("User {} is successfully an admin of the room {}", new Object[]{matrixIdOfUser, matrixRoomId});
                return true;
            }
            LOG.error("Error upgrading user {} to Admin in the room {}, Matrix server returned HTTP {} error {}", new Object[]{matrixIdOfUser, matrixRoomId, String.valueOf(response.statusCode()), response.body()});
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not make a user an admin in a room on Matrix", (Throwable)e);
            return false;
        }
    }

    public MatrixRoomPermissions getRoomSettings(String matrixRoomId, String accessToken) throws IOException, InterruptedException, JsonException {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String fullRoomId = matrixRoomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/rooms/" + fullRoomId + "/state/m.room.power_levels/";
        HttpResponse<String> response = HTTPHelper.sendHttpGetRequest(url, accessToken);
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            LOG.info("Permissions of room  {} were successfully loaded !", new Object[]{matrixRoomId});
            JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
            JsonValue jsonResponse = jsonGenerator.createJsonObjectFromString(response.body());
            return MatrixRoomPermissions.fromJson(jsonResponse);
        }
        throw new RuntimeException("Error getting room permissions of %s ,Matrix server returned HTTP %s error %s".formatted(matrixRoomId, String.valueOf(response.statusCode()), response.body()));
    }

    public String updateRoomSettings(String matrixRoomId, MatrixRoomPermissions roomSettings, String accessToken) throws IOException, InterruptedException, JsonException {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String payload = roomSettings.toJson();
        String fullRoomId = matrixRoomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/rooms/" + fullRoomId + "/state/m.room.power_levels/";
        HttpResponse<String> response = HTTPHelper.sendHttpPutRequest(url, accessToken, payload);
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            LOG.info("Permissions of room  {} were successfully updated !", new Object[]{matrixRoomId});
            JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
            JsonValue jsonResponse = jsonGenerator.createJsonObjectFromString(response.body());
            return jsonResponse.getElement("event_id").getStringValue();
        }
        if (response.statusCode() == 429) {
            long sleepInMs = new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("retry_after_ms").getLongValue();
            LOG.warn("Too many requests on Matrix server, retrying to update the settings of the room {} after {}ms", new Object[]{matrixRoomId, sleepInMs});
            Thread.sleep(sleepInMs);
            return this.updateRoomSettings(matrixRoomId, roomSettings, accessToken);
        }
        throw new RuntimeException("Error updating room permissions of %s ,Matrix server returned HTTP %s error %s".formatted(matrixRoomId, String.valueOf(response.statusCode()), response.body()));
    }

    public String uploadFile(String fileName, String mimeType, byte[] imageBytes, String accessToken) {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/media/v3/upload?filename=" + fileName;
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, accessToken, mimeType, imageBytes);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOG.info((Object)"File uploaded successfully !");
                JsonGeneratorImpl jsonGenerator = new JsonGeneratorImpl();
                JsonValue jsonResponse = jsonGenerator.createJsonObjectFromString(response.body());
                return jsonResponse.getElement("content_uri").getStringValue();
            }
            LOG.error("Error uploading the file ,Matrix server returned HTTP {} error {}", new Object[]{String.valueOf(response.statusCode()), response.body()});
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not upload the file on Matrix", (Throwable)e);
            return null;
        }
    }

    public boolean updateRoomAvatar(String matrixRoomId, String avatarURL, String accessToken) {
        String fullRoomId = matrixRoomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/rooms/" + URLEncoder.encode(fullRoomId, StandardCharsets.UTF_8) + "/state/m.room.avatar/";
        String payload = "{\n  \"url\":\"%s\"\n}\n".formatted(avatarURL);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPutRequest(url, accessToken, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOG.info("Avatar of room {} updated successfully !", new Object[]{matrixRoomId});
                return true;
            }
            if (response.statusCode() == 429) {
                long sleepInMs = new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("retry_after_ms").getLongValue();
                LOG.warn("Too many requests on Matrix server, retrying the update of the room avatar after {}ms", new Object[]{sleepInMs});
                Thread.sleep(sleepInMs);
                return this.updateRoomAvatar(matrixRoomId, avatarURL, accessToken);
            }
            throw new RuntimeException("Error updating the avatar of the room %s ,Matrix server returned HTTP %s error %s".formatted(matrixRoomId, String.valueOf(response.statusCode()), response.body()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not update the avatar of the room on Matrix", e);
        }
    }

    public boolean updateUserAvatar(String userMatrixId, String avatarURL, String accessToken) {
        String fullMatrixUserId = "@%s:%s".formatted(userMatrixId, PropertyManager.getProperty((String)"meeds.matrix.server.name"));
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/profile/" + fullMatrixUserId + "/avatar_url";
        String payload = "{\n  \"avatar_url\":\"%s\"\n}\n".formatted(avatarURL);
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPutRequest(url, accessToken, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOG.info("Avatar of user {} updated successfully !", new Object[]{userMatrixId});
                return true;
            }
            if (response.statusCode() == 429) {
                long sleepInMs = new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("retry_after_ms").getLongValue();
                LOG.warn("Too many requests on Matrix server, retrying the update of the room avatar after {}ms", new Object[]{sleepInMs});
                Thread.sleep(sleepInMs);
                return this.updateUserAvatar(userMatrixId, avatarURL, accessToken);
            }
            LOG.error("Error updating the avatar of the user {} ,Matrix server returned HTTP {} error {}", new Object[]{userMatrixId, String.valueOf(response.statusCode()), response.body()});
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not update the avatar of the user on Matrix", (Throwable)e);
            return false;
        }
    }

    public boolean updateRoomDescription(String matrixRoomId, String description, String accessToken) {
        String fullRoomId = matrixRoomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/rooms/" + URLEncoder.encode(fullRoomId, StandardCharsets.UTF_8) + "/state/m.room.topic/";
        String plainDescription = description.replaceAll("<[^>]*>", "").replace("\n", "");
        String payload = "{\n\"topic\":\"%s\",\n\"org.matrix.msc3765.topic\":\n  [\n    {\n      \"body\":\"%s\",\n      \"mimetype\":\"text/html\"\n    }\n  ]\n}\n".formatted(plainDescription, URLEncoder.encode(description, StandardCharsets.UTF_8));
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpPutRequest(url, accessToken, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOG.info("Description of room {} updated successfully !", new Object[]{matrixRoomId});
                return true;
            }
            LOG.error("Error updating the description of the room {} ,Matrix server returned HTTP {} error {}", new Object[]{matrixRoomId, String.valueOf(response.statusCode()), response.body()});
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not update the description of the room on Matrix", (Throwable)e);
            return false;
        }
    }

    public boolean deleteRoom(String matrixRoomId, String accessToken) {
        String fullRoomId = matrixRoomId + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_synapse/admin/v1/rooms/" + URLEncoder.encode(fullRoomId, StandardCharsets.UTF_8);
        String payload = "  {\n  }\n";
        try {
            HttpResponse<String> response = HTTPHelper.sendHttpDeleteRequest(url, accessToken, payload);
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                LOG.info("The room {} was deleted successfully !", new Object[]{matrixRoomId});
                return true;
            }
            LOG.error("Error deleting the room {} ,Matrix server returned HTTP {} error {}", new Object[]{matrixRoomId, String.valueOf(response.statusCode()), response.body()});
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not delete the room on Matrix", (Throwable)e);
            return false;
        }
    }

    public String cleanMatrixUsername(String userName) {
        return userName.replaceAll("[^a-zA-Z0-9=_\\-\\.\\/+]+", "-").toLowerCase();
    }

    public String getUserDisplayName(String userMatrixId, String matrixAccessToken) throws IOException, InterruptedException, JsonException {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String encodedUserMatrixId = URLEncoder.encode(userMatrixId, StandardCharsets.UTF_8);
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/profile/" + encodedUserMatrixId + "/displayname";
        HttpResponse<String> response = HTTPHelper.sendHttpGetRequest(url, matrixAccessToken);
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            return new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("displayname").getStringValue();
        }
        throw new RuntimeException("Error Updating the display name of the user %s, Matrix server returned HTTP %s error %s".formatted(userMatrixId, String.valueOf(response.statusCode()), response.body()));
    }

    public String getUserPresence(String matrixIdOfUser, String accessToken) throws IOException, InterruptedException, JsonException {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String encodedUserMatrixId = URLEncoder.encode(matrixIdOfUser, StandardCharsets.UTF_8);
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/presence/" + encodedUserMatrixId + "/status";
        HttpResponse<String> response = HTTPHelper.sendHttpGetRequest(url, accessToken);
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            return new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("presence").getStringValue();
        }
        throw new RuntimeException("Error retrieving the presence of the user %s ,Matrix server returned HTTP %s error %s".formatted(matrixIdOfUser, String.valueOf(response.statusCode()), response.body()));
    }

    public String setUserPresence(String matrixIdOfUser, String presence, String statusMessage, String accessToken) throws IOException, InterruptedException, JsonException {
        String payload;
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String encodedUserMatrixId = URLEncoder.encode(matrixIdOfUser, StandardCharsets.UTF_8);
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/presence/" + encodedUserMatrixId + "/status";
        HttpResponse<String> response = HTTPHelper.sendHttpPutRequest(url, accessToken, payload = "{\n  \"presence\": \"%s\",\n  \"status_msg\": \"%s\"\n}\n".formatted(presence, statusMessage));
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            return response.body();
        }
        if (response.statusCode() == 429) {
            long sleepInMs = new JsonGeneratorImpl().createJsonObjectFromString(response.body()).getElement("retry_after_ms").getLongValue();
            LOG.warn("Too many requests on Matrix server, retrying to retrieve the user presence after {}ms", new Object[]{sleepInMs});
            Thread.sleep(sleepInMs);
            return this.setUserPresence(matrixIdOfUser, presence, statusMessage, accessToken);
        }
        throw new RuntimeException("Error retrieving the presence of the user %s ,Matrix server returned HTTP %s error %s".formatted(matrixIdOfUser, String.valueOf(response.statusCode()), response.body()));
    }

    public String overrideRateLimitForUser(String userIdOnMatrix, int messagesPerSecond, int burstCount, String accessToken) throws IOException, InterruptedException {
        String payload;
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String encodedUserMatrixId = URLEncoder.encode(userIdOnMatrix, StandardCharsets.UTF_8);
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_synapse/admin/v1/users/" + encodedUserMatrixId + "/override_ratelimit";
        HttpResponse<String> response = HTTPHelper.sendHttpPostRequest(url, accessToken, payload = "{\n  \"messages_per_second\": %s,\n  \"burst_count\": %s\n}\n".formatted(messagesPerSecond, burstCount));
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            return response.body();
        }
        throw new RuntimeException("Error overriding the rate limits for the user %s ,Matrix server returned HTTP %s error %s".formatted(userIdOnMatrix, String.valueOf(response.statusCode()), response.body()));
    }

    public String getOverriddenRateLimitForUser(String userIdOnMatrix, String accessToken) throws IOException, InterruptedException {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String encodedUserMatrixId = URLEncoder.encode(userIdOnMatrix, StandardCharsets.UTF_8);
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_synapse/admin/v1/users/" + encodedUserMatrixId + "/override_ratelimit";
        HttpResponse<String> response = HTTPHelper.sendHttpGetRequest(url, accessToken);
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            return response.body();
        }
        throw new RuntimeException("Error overriding the rate limits for the user %s ,Matrix server returned HTTP %s error %s".formatted(userIdOnMatrix, String.valueOf(response.statusCode()), response.body()));
    }

    public MatrixMessage getEventById(String eventId, String roomId, String accessToken) throws IOException, InterruptedException, JsonException {
        if (StringUtils.isBlank((CharSequence)PropertyManager.getProperty((String)"meeds.matrix.server.url"))) {
            throw new IllegalArgumentException("The URL of the Matrix server is required, please provide it using System properties !");
        }
        String url = PropertyManager.getProperty((String)"meeds.matrix.server.url") + "/_matrix/client/v3/rooms/" + roomId + "/event/" + eventId;
        HttpResponse<String> response = HTTPHelper.sendHttpGetRequest(url, accessToken);
        if (response.statusCode() >= 200 && response.statusCode() < 300) {
            JsonValue jsonMessage = new JsonGeneratorImpl().createJsonObjectFromString(response.body());
            MatrixMessage message = new MatrixMessage();
            message.setEventId(eventId);
            message.setRoomId(jsonMessage.getElement("room_id").getStringValue());
            message.setType(jsonMessage.getElement("type").getStringValue());
            message.setSender(jsonMessage.getElement("sender").getStringValue());
            if (jsonMessage.getElement("content") != null) {
                JsonValue mentionedUsersElement;
                JsonValue mentionsElement;
                JsonValue content = jsonMessage.getElement("content");
                message.setMessageContent(content.getElement("body").getStringValue());
                message.setMessageType(content.getElement("msgtype").getStringValue());
                if ("m.text".equals(message.getMessageType()) && content.getElement("org.matrix.custom.html") != null) {
                    message.setMessageContent(jsonMessage.getElement("formatted_body").getStringValue());
                }
                if ((mentionsElement = content.getElement("m.mentions")) != null && (mentionedUsersElement = mentionsElement.getElement("user_ids")) != null) {
                    Iterator mentionedUsersIterator = mentionedUsersElement.getElements();
                    ArrayList<String> mentionedUsers = new ArrayList<String>();
                    while (mentionedUsersIterator.hasNext()) {
                        JsonValue nextMentioned = (JsonValue)mentionedUsersIterator.next();
                        mentionedUsers.add(nextMentioned.getStringValue());
                    }
                    message.setMentionedUsers(mentionedUsers);
                }
            }
            return message;
        }
        if (response.statusCode() != 404) {
            throw new RuntimeException("Error retrieving the message of the event %s ,Matrix server returned HTTP %s error %s".formatted(eventId, String.valueOf(response.statusCode()), response.body()));
        }
        return null;
    }
}

