/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.chat.entity.RoomStatus;
import io.meeds.chat.model.Room;
import io.meeds.chat.rest.MatrixRest;
import io.meeds.chat.rest.model.LastMessage;
import io.meeds.chat.rest.model.Member;
import io.meeds.chat.rest.model.Presence;
import io.meeds.chat.rest.model.RoomEntity;
import io.meeds.chat.rest.model.RoomList;
import io.meeds.chat.service.ChatNotificationService;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.MatrixSynchronizationService;
import io.meeds.pwa.service.PwaNotificationService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={MatrixRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
class MatrixRestTest {
    private static final String SIMPLE_USER = "user";
    private static final String ADMIN_USER = "admin";
    private static final String TEST_PASSWORD = "testPassword";
    private static final String REST_PATH = "/matrix";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    @MockBean
    private SpaceService spaceService;
    @MockBean
    private MatrixService matrixService;
    @MockBean
    private MatrixSynchronizationService matrixSynchronizationService;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private ResourceBundleService resourceBundleService;
    @MockBean
    private NotificationService notificationService;
    @MockBean
    private ChatNotificationService chatNotificationService;
    @MockBean
    PwaNotificationService pwaNotificationService;
    MockedStatic<LinkProvider> LINK_PROVIDER;
    MockedStatic<RestUtils> REST_UTILS;
    MockedStatic<EntityBuilder> ENTITY_BUILDER;
    private MockMvc mockMvc;

    MatrixRestTest() {
    }

    @BeforeEach
    public void setUp() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
        PropertyManager.setProperty((String)"meeds.matrix.server.name", (String)"matrix.meeds.tn");
        this.LINK_PROVIDER = Mockito.mockStatic(LinkProvider.class);
        this.REST_UTILS = Mockito.mockStatic(RestUtils.class);
        this.ENTITY_BUILDER = Mockito.mockStatic(EntityBuilder.class);
    }

    @AfterEach
    void tearDown() {
        this.LINK_PROVIDER.close();
        this.REST_UTILS.close();
        this.ENTITY_BUILDER.close();
    }

    @Test
    public void testProcessRooms() throws Exception {
        RoomEntity roomEntity1 = this.createRoomEntity(1);
        roomEntity1.setSpaceId("1");
        RoomEntity roomEntity2 = this.createRoomEntity(2);
        roomEntity2.setSpaceId("2");
        RoomEntity roomEntity3 = this.createRoomEntity(3);
        roomEntity3.setSpaceId("3");
        Room room1 = new Room();
        room1.setRoomId("!testRoom1:matrix.meeds.tn");
        room1.setSpaceId("1");
        room1.setStatus(RoomStatus.ENABLED.name());
        Room room2 = new Room();
        room2.setRoomId("!testRoom2:matrix.meeds.tn");
        room2.setSpaceId("2");
        room2.setStatus(RoomStatus.ENABLED.name());
        Room room3 = new Room();
        room3.setRoomId("!testRoom3:matrix.meeds.tn");
        room3.setSpaceId("3");
        room3.setStatus(RoomStatus.ENABLED.name());
        Mockito.when((Object)this.matrixService.getById("!testRoom1", true)).thenReturn((Object)room1);
        Mockito.when((Object)this.matrixService.getById("!testRoom1")).thenReturn((Object)room1);
        Mockito.when((Object)this.matrixService.getById("!testRoom2", true)).thenReturn((Object)room2);
        Mockito.when((Object)this.matrixService.getById("!testRoom2")).thenReturn((Object)room2);
        Mockito.when((Object)this.matrixService.getById("!testRoom3", true)).thenReturn((Object)room3);
        Mockito.when((Object)this.matrixService.getById("!testRoom3")).thenReturn((Object)room3);
        Space space1 = new Space();
        space1.setDisplayName("Space of Heroes 1");
        space1.setAvatarUrl("/Url/Of/Avatar.png");
        space1.setMembers(new String[]{"user1", "user2"});
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        Mockito.when((Object)this.matrixService.getRoomBySpaceId("1")).thenReturn((Object)room1);
        Space space2 = new Space();
        space2.setDisplayName("Space of Heroes 2");
        space2.setAvatarUrl("/Url/Of/Avatar.png");
        space2.setMembers(new String[]{"user1", "user2"});
        Mockito.when((Object)this.spaceService.getSpaceById("2")).thenReturn((Object)space2);
        Mockito.when((Object)this.matrixService.getRoomBySpaceId("2")).thenReturn((Object)room2);
        Space space3 = new Space();
        space3.setDisplayName("Space of Heroes 3");
        space3.setAvatarUrl("/Url/Of/Avatar.png");
        space3.setMembers(new String[]{"user1", "user2"});
        Mockito.when((Object)this.spaceService.getSpaceById("3")).thenReturn((Object)space3);
        Mockito.when((Object)this.matrixService.getRoomBySpaceId("3")).thenReturn((Object)room3);
        RoomEntity privateRoomEntity1 = this.createRoomEntity(4);
        privateRoomEntity1.setDirectChat(true);
        Room privateRoom1 = new Room();
        privateRoom1.setRoomId("!testRoom4:matrix.meeds.tn");
        privateRoom1.setSpaceId(null);
        privateRoom1.setFirstParticipant(SIMPLE_USER);
        privateRoom1.setSecondParticipant("user2");
        privateRoom1.setStatus(RoomStatus.ENABLED.name());
        this.createUserIdentity("user2");
        Mockito.when((Object)this.matrixService.getById("!testRoom4", true)).thenReturn((Object)privateRoom1);
        Mockito.when((Object)this.matrixService.getById("!testRoom4")).thenReturn((Object)privateRoom1);
        RoomList roomsList = new RoomList();
        roomsList.setTotalUnreadMessages(5L);
        roomsList.setRooms(List.of(roomEntity1, roomEntity2, privateRoomEntity1));
        Mockito.when((Object)this.spaceService.getMemberSpacesIds(SIMPLE_USER, 0, -1)).thenReturn(new ArrayList<String>(List.of(new String[]{"1", "2", "3"})));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/processRooms", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).content(MatrixRestTest.asJsonString(roomsList)));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().contentType(MediaType.APPLICATION_JSON));
        RoomList expectedRoomList = MatrixRestTest.fromJsonString(response.andReturn().getResponse().getContentAsString(), RoomList.class);
        Assertions.assertNotNull((Object)expectedRoomList);
        Assertions.assertNotNull((Object)expectedRoomList.getRooms());
        Assertions.assertEquals((int)4, (int)expectedRoomList.getRooms().size());
        Assertions.assertEquals((long)5L, (long)expectedRoomList.getTotalUnreadMessages());
        Room room = new Room();
        room.setSpaceId(null);
        room.setFirstParticipant("root");
        room.setSecondParticipant(SIMPLE_USER);
        this.createUserIdentity("root");
        ResultActions response1 = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/processRooms", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).content(MatrixRestTest.asJsonString(roomsList)));
        response1.andExpect(MockMvcResultMatchers.status().isOk());
    }

    private void createUserIdentity(String userName) {
        Identity identity = new Identity();
        identity.setRemoteId(userName);
        identity.setId("1");
        Profile profile = new Profile();
        profile.setAvatarUrl("/avatar/of/root");
        profile.setProperty("firstName", (Object)userName);
        profile.setProperty("lastName", (Object)"The king");
        identity.setProfile(profile);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(userName)).thenReturn((Object)identity);
    }

    private RoomEntity createRoomEntity(int index) {
        RoomEntity room = new RoomEntity();
        room.setId("!testRoom" + index + ":matrix.meeds.tn");
        room.setAvatarUrl("/avatar/" + index);
        room.setName("Chat number " + index);
        Member root = new Member("1", "userId", "matrixId", "root", "/user/avatar1", System.currentTimeMillis());
        Member user = new Member("2", "userId", "matrixId", SIMPLE_USER, "/user/avatar2", System.currentTimeMillis());
        room.setMembers(Arrays.asList(user, root));
        room.setUnreadMessages((long)index);
        room.setPresence("online");
        room.setTopic("No topic");
        room.setUpdated(System.currentTimeMillis());
        LastMessage lastMessage = new LastMessage();
        lastMessage.setContent("This is a new message");
        lastMessage.setSender("@root:matrix.meeds.tn");
        room.setLastMessage(lastMessage);
        room.setStatus(RoomStatus.ENABLED.name());
        return room;
    }

    private RequestPostProcessor simpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    private RequestPostProcessor adminUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("administrators")});
    }

    public static String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    @Test
    void updatePresenceStatus() throws Exception {
        Presence presence = new Presence();
        presence.setPresence("online");
        presence.setStatusMessage("I am available");
        presence.setUserIdOnMatrix("@user:matrix.meeds.tn");
        Mockito.when((Object)this.matrixService.updateUserPresence(Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)presence.getPresence());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/matrix/setStatus", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).content(MatrixRestTest.asJsonString(presence)));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().string("online"));
    }

    @Test
    void getRoomById() throws Exception {
        String roomId = "!testRoomIdentifier:matrix.meeds.tn";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/byRoomId", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("roomId", new String[]{roomId}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Room room = new Room();
        room.setRoomId(roomId);
        room.setSpaceId("1");
        Space space = new Space();
        space.setAvatarUrl("/avatar/of/the/space");
        space.setDisplayName("Test space");
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        Mockito.when((Object)this.matrixService.getById(roomId)).thenReturn((Object)room);
        Mockito.when((Object)this.matrixService.canAccess((Room)Mockito.eq((Object)room), Mockito.anyString())).thenReturn((Object)true);
        ResultActions response1 = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/byRoomId", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("roomId", new String[]{roomId}));
        response1.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getDirectMessagingRoom() throws Exception {
        String roomId = "!testRoomIdentifier:matrix.meeds.tn";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/dmRoom", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("firstParticipant", new String[]{"userOne"}).param("secondParticipant", new String[]{"userTwo"}));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        Room room = new Room();
        room.setRoomId(roomId);
        room.setSpaceId(null);
        room.setFirstParticipant("userOne");
        room.setSecondParticipant("userTwo");
        Mockito.when((Object)this.matrixService.getDirectMessagingRoom((String)Mockito.eq((Object)"userOne"), (String)Mockito.eq((Object)"userTwo"))).thenReturn((Object)room);
        ResultActions response1 = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/dmRoom", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON).param("firstParticipant", new String[]{"userOne"}).param("secondParticipant", new String[]{"userTwo"}));
        response1.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void syncUsersAndSpaces() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/sync", (Object[])new Object[0]).with(this.adminUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getMatrixRoomBySpaceId() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.adminUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.simpleUser()).param("spaceId", new String[]{"1"}).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        Space space = new Space();
        space.setAvatarUrl("/avatar/of/the/space");
        space.setDisplayName("Test space");
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.isMember(space, SIMPLE_USER)).thenReturn((Object)true);
        Room room = new Room();
        room.setRoomId("!testRoom:matrix.meeds.tn");
        room.setSpaceId("1");
        Mockito.when((Object)this.matrixService.getRoomBySpace(space)).thenReturn((Object)room);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.simpleUser()).param("spaceId", new String[]{"1"}).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void linkSpaceToRoom() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/linkRoom", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/linkRoom", (Object[])new Object[0]).with(this.simpleUser()).param("spaceGroupId", new String[]{"groupOne"}).param("roomId", new String[]{"!roomIdenitifier:matrix.meeds.tn"}).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
        Space space = new Space();
        space.setAvatarUrl("/avatar/of/the/space");
        space.setDisplayName("Test space");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("/spaces/groupOne")).thenReturn((Object)space);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/linkRoom", (Object[])new Object[0]).with(this.simpleUser()).param("spaceGroupId", new String[]{"groupOne"}).param("roomId", new String[]{"!roomIdenitifier:matrix.meeds.tn"}).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getByRoomId() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/byRoomId", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/byRoomId", (Object[])new Object[0]).with(this.simpleUser()).param("roomId", new String[]{"!roomIdentifier"}).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Room room = new Room();
        room.setRoomId("!testRoom:matrix.meeds.tn");
        room.setSpaceId("1");
        Mockito.when((Object)this.matrixService.getById("!testRoom:matrix.meeds.tn")).thenReturn((Object)room);
        Mockito.when((Object)this.matrixService.canAccess(room, SIMPLE_USER)).thenReturn((Object)true);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/byRoomId", (Object[])new Object[0]).with(this.simpleUser()).param("roomId", new String[]{"!testRoom:matrix.meeds.tn"}).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getUserDirectMessagingRooms() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/dmRooms", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/dmRooms", (Object[])new Object[0]).with(this.simpleUser()).param(SIMPLE_USER, new String[]{"john"}).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().string("{}"));
        Room room = new Room();
        room.setRoomId("!ThisIsARoom:matrix.meeds.tn");
        room.setSpaceId(null);
        room.setFirstParticipant("userOne");
        room.setSecondParticipant(SIMPLE_USER);
        Mockito.when((Object)this.matrixService.getMatrixDMRoomsOfUser(SIMPLE_USER)).thenReturn(Collections.singletonList(room));
        Identity userIdentity = new Identity();
        userIdentity.setRemoteId("userOne");
        userIdentity.setId("1");
        Profile profile = new Profile(userIdentity);
        profile.getProperties().put("matrixId", "userOne");
        userIdentity.setProfile(profile);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("userOne")).thenReturn((Object)userIdentity);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/dmRooms", (Object[])new Object[0]).with(this.simpleUser()).param(SIMPLE_USER, new String[]{SIMPLE_USER}).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().string("{\"@userOne:matrix.meeds.tn\":[\"!ThisIsARoom:matrix.meeds.tn\"]}"));
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return (T)OBJECT_MAPPER.readValue(value, resultClass);
    }

    @Test
    void enableChat() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/matrix/enable/1", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Space space1 = new Space();
        space1.setId(1L);
        space1.setDisplayName("Space of Heroes");
        space1.setAvatarUrl("/Url/Of/Avatar.png");
        space1.setMembers(new String[]{"user1", "user2"});
        Room room = new Room();
        room.setRoomId("!testRoom:matrix.meeds.tn");
        room.setSpaceId("1");
        Mockito.when((Object)this.matrixService.enableSpaceChat(space1, true)).thenReturn((Object)room);
        Mockito.when((Object)this.matrixService.getRoomBySpace(space1, true)).thenReturn((Object)room);
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        Mockito.when((Object)this.spaceService.canManageSpace(space1, SIMPLE_USER)).thenReturn((Object)true);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/matrix/enable/1", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void disableChat() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/matrix/disable/1", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Space space1 = new Space();
        space1.setId(1L);
        space1.setDisplayName("Space of Heroes");
        space1.setAvatarUrl("/Url/Of/Avatar.png");
        space1.setMembers(new String[]{"user1", "user2"});
        Room room = new Room();
        room.setRoomId("!testRoom:matrix.meeds.tn");
        room.setSpaceId("1");
        Mockito.when((Object)this.matrixService.enableSpaceChat(space1, false)).thenReturn((Object)room);
        Mockito.when((Object)this.matrixService.getRoomBySpace(space1, true)).thenReturn((Object)room);
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        Mockito.when((Object)this.spaceService.canManageSpace(space1, SIMPLE_USER)).thenReturn((Object)true);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/matrix/disable/1", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void muteRoom() throws Exception {
        String roomId = "!testRoomToMute:matrix.meeds.tn";
        ((ChatNotificationService)Mockito.doNothing().when((Object)this.chatNotificationService)).toggleMutePrivateRoom(SIMPLE_USER, roomId);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/muteRoom", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_FORM_URLENCODED).param("roomId", new String[]{roomId}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().string("Room muted successfully"));
        ((ChatNotificationService)Mockito.verify((Object)this.chatNotificationService, (VerificationMode)Mockito.times((int)1))).toggleMutePrivateRoom(SIMPLE_USER, roomId);
    }

    @Test
    void testNotify() throws Exception {
        PropertyManager.setProperty((String)"meeds.matrix.jwt.secret", (String)"InsufficientToken");
        String jsonNotification = "{\n  \"notification\": {\n    \"content\": {\n      \"body\": \"I'm floating in a most peculiar way.\",\n      \"msgtype\": \"m.text\"\n    },\n    \"counts\": {\n      \"missed_calls\": 1,\n      \"unread\": 2\n    },\n    \"devices\": [\n      {\n        \"app_id\": \"org.matrix.matrixConsole.ios\",\n        \"data\": {},\n        \"pushkey\": \"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiJ1c2VyIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0._yNyipMgOp5G2giBZPrne1jcCHeyEiKda_kQOW_bvZM\",\n        \"pushkey_ts\": 12345678,\n        \"tweaks\": {\n          \"sound\": \"bing\"\n        }\n      }\n    ],\n    \"event_id\": \"$3957tyerfgewrf384\",\n    \"prio\": \"high\",\n    \"room_alias\": \"#exampleroom:matrix.org\",\n    \"room_id\": \"!slw48wfj34rtnrf:example.com\",\n    \"room_name\": \"Mission Control\",\n    \"sender\": \"@exampleuser:matrix.org\",\n    \"sender_display_name\": \"Major Tom\",\n    \"type\": \"m.room.message\"\n  }\n}\n";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/notify", (Object[])new Object[0]).with(this.simpleUser()).content(jsonNotification).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isInternalServerError());
        PropertyManager.setProperty((String)"meeds.matrix.jwt.secret", (String)"ThisIsASampleJWTTokenFoeTestingPurposes");
        Mockito.when((Object)this.identityManager.identityExisted("organization", SIMPLE_USER)).thenReturn((Object)true);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/notify", (Object[])new Object[0]).with(this.simpleUser()).content(jsonNotification).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().string("{\n  \"rejected\": []\n}\n"));
    }

    @Test
    void isPushNotificationsEnabled() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/isPushNotificationsEnabled/demo", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_FORM_URLENCODED));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/isPushNotificationsEnabled/user", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_FORM_URLENCODED));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().string("false"));
        Mockito.when((Object)this.chatNotificationService.isPushNotificationsEnabled(SIMPLE_USER)).thenReturn((Object)true);
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/matrix/isPushNotificationsEnabled/user", (Object[])new Object[0]).with(this.simpleUser()).contentType(MediaType.APPLICATION_FORM_URLENCODED));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        response.andExpect(MockMvcResultMatchers.content().string("true"));
    }

    @Test
    void updatePushNotificationsSettings() throws Exception {
        String content = "{\n  \"active\": true\n}\n";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/enablePushNotificationsSettings", (Object[])new Object[0]).with(this.simpleUser()).content(content).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        content = "{ \"userName\": test,\n  \"active\": true\n}\n";
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/enablePushNotificationsSettings", (Object[])new Object[0]).with(this.simpleUser()).content(content).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        content = "{ \"userName\": user,\n  \"active\": true\n}\n";
        response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/matrix/enablePushNotificationsSettings", (Object[])new Object[0]).with(this.simpleUser()).content(content).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

