/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.MatrixBaseTest;
import io.meeds.chat.service.utils.MatrixHttpClient;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

@SpringJUnitConfig(value={MatrixBaseTest.class})
class MatrixListenerTest
extends MatrixBaseTest {
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    ListenerService listenerService;
    @Autowired
    IdentityManager identityManager;

    MatrixListenerTest() {
    }

    @Test
    void testUserListener() throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName("raul");
        this.organizationService.getUserHandler().saveUser(user, true);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).saveUserAccount((Identity)ArgumentMatchers.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
        this.organizationService.getUserHandler().setEnabled("raul", false, true);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).disableAccount(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString());
        this.organizationService.getUserHandler().setEnabled("raul", true, true);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)2))).saveUserAccount((Identity)ArgumentMatchers.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
    }

    @Test
    void testUserLoginListener() {
        org.exoplatform.services.security.Identity identity = new org.exoplatform.services.security.Identity("ghost");
        ConversationState state = new ConversationState(identity);
        Identity ghostIdentity = this.identityManager.getOrCreateUserIdentity("ghost");
        Profile profile = ghostIdentity.getProfile();
        profile.setProperty("matrixId", (Object)"");
        this.identityManager.updateProfile(profile);
        this.listenerService.broadcast("exo.core.security.ConversationRegistry.register", (Object)this, (Object)state);
        ((MatrixHttpClient)Mockito.verify((Object)this.matrixHttpClient, (VerificationMode)Mockito.times((int)1))).saveUserAccount((Identity)ArgumentMatchers.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean());
    }
}

