/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.service;

import io.meeds.notes.model.TermsAndConditionPage;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TermsAndConditionsService {
    public static final String TC_NOTE_TYPE = "terms";
    public static final String TC_NOTE_NAME = "termsAndConditions";
    public static final Scope SETTINGS_APP_SCOPE = Scope.APPLICATION.id("TERMS_AND_CONDITIONS");
    public static final String SETTINGS_KEY = "TERMS_AND_CONDITIONS_ACCEPTED_VERSION";
    public static final String PUBLISHED = "published";
    public static final String PUBLISHED_DATE = "publishedDate";
    public static final String PUBLISHED_VERSION_ID = "latestVersionId";
    public static final String EVENT_NAME_ADDED = "terms.and.conditions.added";
    public static final String EVENT_NAME_UPDATED = "terms.and.conditions.updated";
    public static final String EVENT_NAME_ACCEPTED = "terms.and.conditions.accepted";
    public static final String LATEST_VERSION_ID = "latestVersionId";
    public static final String TC_METADATA_OBJECT_TYPE = "termsAndConditions";
    public static final MetadataType TC_METADATA_TYPE = new MetadataType(1002L, "termsAndConditions");
    public static final MetadataKey TC_METADATA_KEY = new MetadataKey(TC_METADATA_TYPE.getName(), "termsAndConditions", 0L);
    @Autowired
    private NoteService noteService;
    @Autowired
    private WikiService noteBookService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private UserACL userACL;

    public TermsAndConditionPage saveTermsAndConditions(String content, String lang, Identity currentUserAclIdentity) throws IllegalAccessException {
        String username = currentUserAclIdentity.getUserId();
        if (!this.userACL.isAdministrator(currentUserAclIdentity)) {
            throw new IllegalAccessException("User doesn't have enough privileges to create terms and conditions page");
        }
        return this.saveTermsAndConditions(content, lang, username);
    }

    public TermsAndConditionPage updateTermsAndConditionsSettings(boolean published, String lang, Identity currentUserAclIdentity) throws IllegalAccessException {
        String eventName;
        if (!this.userACL.isAdministrator(currentUserAclIdentity)) {
            throw new IllegalAccessException("User doesn't have enough privileges to update terms and conditions settings");
        }
        TermsAndConditionPage page = this.getTermsAndConditions(lang);
        MetadataItem metadataItem = this.getTermsAndConditionsMetadataItem(page.getId());
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(PUBLISHED, String.valueOf(published));
        settings.put(PUBLISHED_DATE, published ? String.valueOf(System.currentTimeMillis()) : "");
        settings.put("latestVersionId", String.valueOf(page.getLatestVersionId()));
        if (metadataItem != null) {
            String storedLatestVersionId = (String)metadataItem.getProperties().get("latestVersionId");
            metadataItem.setProperties(settings);
            this.metadataService.updateMetadataItem(metadataItem, Long.parseLong(page.getId()), false);
            eventName = !page.getLatestVersionId().equals(storedLatestVersionId) ? EVENT_NAME_UPDATED : null;
        } else {
            MetadataObject metadataObject = new MetadataObject("termsAndConditions", page.getId());
            this.metadataService.createMetadataItem(metadataObject, TC_METADATA_KEY, settings, Long.parseLong(page.getId()));
            eventName = EVENT_NAME_ADDED;
        }
        if (published && eventName != null) {
            this.listenerService.broadcast(eventName, (Object)page.getId(), null);
        }
        return this.getTermsAndConditions(lang);
    }

    public TermsAndConditionPage getTermsAndConditions(String lang) {
        Page page = this.noteService.getNoteOfNoteBookByName(TC_NOTE_TYPE, IdentityConstants.SYSTEM, "termsAndConditions");
        if (page != null && StringUtils.isNotBlank((CharSequence)lang) && !StringUtils.equals((CharSequence)lang, (CharSequence)page.getLang())) {
            PageVersion publishedVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.parseLong(page.getId()), lang);
            PageVersion pageVersion = publishedVersion = publishedVersion != null ? publishedVersion : this.noteService.getPublishedVersionByPageIdAndLang(Long.parseLong(page.getId()), Locale.ENGLISH.getLanguage());
            if (publishedVersion != null) {
                page.setTitle(publishedVersion.getTitle());
                page.setContent(publishedVersion.getContent());
                page.setLang(publishedVersion.getLang());
                page.setProperties(publishedVersion.getProperties());
                page.setLatestVersionId(publishedVersion.getId());
            }
            return this.buildTermsAndConditionPage(page);
        }
        return null;
    }

    public void markTermsAsAcceptedForUser(String userId, String lang) {
        TermsAndConditionPage terms = this.getTermsAndConditions(lang);
        if (terms != null) {
            this.settingService.set(Context.USER.id(userId), SETTINGS_APP_SCOPE, SETTINGS_KEY, SettingValue.create((String)terms.getLatestPublishedVersionId()));
            this.listenerService.broadcast(EVENT_NAME_ACCEPTED, (Object)userId, null);
        }
    }

    public boolean isTermsAcceptedForUser(String userId, String lang) {
        TermsAndConditionPage terms = this.getTermsAndConditions(lang);
        if (terms != null && terms.isPublished()) {
            SettingValue acceptedVersion = this.settingService.get(Context.USER.id(userId), SETTINGS_APP_SCOPE, SETTINGS_KEY);
            String acceptedVersionValue = acceptedVersion == null || acceptedVersion.getValue() == null ? null : acceptedVersion.getValue().toString();
            return acceptedVersionValue != null && acceptedVersionValue.equals(terms.getLatestPublishedVersionId());
        }
        return true;
    }

    private TermsAndConditionPage saveTermsAndConditions(String content, String lang, String username) {
        Wiki noteBook = this.geTermsAndConditions();
        TermsAndConditionPage termsAndConditionPage = this.getTermsAndConditions(lang);
        if (termsAndConditionPage == null) {
            Page page = new Page("termsAndConditions", "");
            page.setContent(content);
            page.setCreatedDate(new Date());
            page.setUpdatedDate(new Date());
            page.setAuthor(username);
            page.setOwner(IdentityConstants.SYSTEM);
            page.setLang(lang);
            page.setToBePublished(true);
            page = this.noteService.createNote(noteBook, noteBook.getWikiHome(), page);
            this.noteService.createVersionOfNote(page, username);
        }
        return this.getTermsAndConditions(lang);
    }

    private Wiki geTermsAndConditions() {
        Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(TC_NOTE_TYPE, IdentityConstants.SYSTEM);
        if (noteBook == null) {
            return this.noteBookService.createWiki(TC_NOTE_TYPE, IdentityConstants.SYSTEM);
        }
        return noteBook;
    }

    private TermsAndConditionPage buildTermsAndConditionPage(Page page) {
        TermsAndConditionPage termsAndConditionPage = new TermsAndConditionPage();
        termsAndConditionPage.setId(page.getId());
        termsAndConditionPage.setParentPageId(page.getParentPageId());
        termsAndConditionPage.setName(page.getName());
        termsAndConditionPage.setTitle(page.getTitle());
        termsAndConditionPage.setContent(page.getContent());
        termsAndConditionPage.setLang(page.getLang());
        termsAndConditionPage.setProperties(page.getProperties());
        termsAndConditionPage.setLatestVersionId(page.getLatestVersionId());
        MetadataItem metadataItem = this.getTermsAndConditionsMetadataItem(page.getId());
        if (metadataItem != null) {
            boolean published = MapUtils.isNotEmpty((Map)metadataItem.getProperties()) && Boolean.parseBoolean((String)metadataItem.getProperties().get(PUBLISHED));
            String publishedDateStr = (String)metadataItem.getProperties().get(PUBLISHED_DATE);
            long publishedDate = StringUtils.isNotBlank((CharSequence)publishedDateStr) ? Long.parseLong(publishedDateStr) : 0L;
            String latestPublishedVersionId = MapUtils.isNotEmpty((Map)metadataItem.getProperties()) ? (String)metadataItem.getProperties().get("latestVersionId") : "";
            termsAndConditionPage.setPublished(published);
            termsAndConditionPage.setPublishedDate(publishedDate);
            termsAndConditionPage.setLatestPublishedVersionId(latestPublishedVersionId);
        }
        return termsAndConditionPage;
    }

    private MetadataItem getTermsAndConditionsMetadataItem(String pageId) {
        MetadataObject metadataObject = new MetadataObject("termsAndConditions", pageId);
        return this.metadataService.getMetadataItemsByMetadataAndObject(TC_METADATA_KEY, metadataObject).stream().findFirst().orElse(null);
    }
}

