/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;

public class SpaceTreeNode
extends TreeNode {
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public SpaceTreeNode(String name) throws Exception {
        super(name, TreeNodeType.SPACE);
        this.path = this.buildPath();
        try {
            WikiType wikiType = WikiType.valueOf(name.toUpperCase());
            this.hasChild = this.wikiService.getWikisByType(wikiType.toString()).size() > 0;
        }
        catch (IllegalArgumentException ex) {
            this.hasChild = false;
        }
    }

    @Override
    protected void addChildren(Map<String, Object> context, String userId) throws Exception {
        try {
            WikiType wikiType = WikiType.valueOf(this.name.toUpperCase());
            List<Wiki> wikis = this.wikiService.getWikisByType(wikiType.toString());
            Iterator childWikiIterator = wikis.iterator();
            int size = this.getNumberOfChildren(context, wikis.size());
            for (int count = 0; childWikiIterator.hasNext() && count < size; ++count) {
                WikiTreeNode child = new WikiTreeNode((Wiki)childWikiIterator.next());
                this.children.add(child);
            }
            super.addChildren(context, userId);
        }
        catch (IllegalArgumentException ex) {
            this.hasChild = false;
        }
    }

    public WikiTreeNode getChildByName(String name) throws Exception {
        for (TreeNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return (WikiTreeNode)child;
        }
        return null;
    }

    @Override
    public String buildPath() {
        return TreeUtils.getPathFromPageParams(new WikiPageParams(this.name, null, null));
    }
}

