/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.Date;
import org.exoplatform.wiki.jpa.entity.PageEntity;

@Entity(name="WikiPageMoveEntity")
@Table(name="WIKI_PAGE_MOVES")
@NamedQueries(value={@NamedQuery(name="wikiPageMove.getPreviousPage", query="SELECT p FROM WikiPageMoveEntity p WHERE p.wikiType = :wikiType AND p.wikiOwner = :wikiOwner AND p.pageName = :pageName")})
public class PageMoveEntity {
    @Id
    @SequenceGenerator(name="SEQ_WIKI_PAGE_MOVES_MOVE_ID", sequenceName="SEQ_WIKI_PAGE_MOVES_MOVE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_PAGE_MOVES_MOVE_ID")
    @Column(name="PAGE_MOVE_ID")
    private long id;
    @ManyToOne
    @JoinColumn(name="PAGE_ID")
    private PageEntity page;
    @Column(name="WIKI_TYPE")
    private String wikiType;
    @Column(name="WIKI_OWNER")
    private String wikiOwner;
    @Column(name="PAGE_NAME")
    private String pageName;
    @Column(name="CREATED_DATE")
    private Date createdDate;

    public PageMoveEntity() {
    }

    public PageMoveEntity(String wikiType, String wikiOwner, String pageName, Date createdDate) {
        this.wikiType = wikiType;
        this.wikiOwner = wikiOwner;
        this.pageName = pageName;
        this.createdDate = createdDate;
    }

    public long getId() {
        return this.id;
    }

    public PageEntity getPage() {
        return this.page;
    }

    public void setPage(PageEntity page) {
        this.page = page;
    }

    public String getWikiType() {
        return this.wikiType;
    }

    public void setWikiType(String wikiType) {
        this.wikiType = wikiType;
    }

    public String getWikiOwner() {
        return this.wikiOwner;
    }

    public void setWikiOwner(String wikiOwner) {
        this.wikiOwner = wikiOwner;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }
}

