/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.notes.listener.AnalyticsAddTagListener;
import java.util.HashSet;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.tag.model.TagName;
import org.exoplatform.social.metadata.tag.model.TagObject;
import org.exoplatform.wiki.model.Page;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnalyticsAddTagListenerTest {
    @Mock
    private IdentityManager identityManager;
    @Mock
    private org.exoplatform.services.security.Identity identity;
    private static final MockedStatic<ConversationState> CONVERSATION_STATE = Mockito.mockStatic(ConversationState.class);
    private static final MockedStatic<AnalyticsUtils> ANALYTICS_UTILS = Mockito.mockStatic(AnalyticsUtils.class);
    private AnalyticsAddTagListener analyticsAddTagListener;

    @Before
    public void setUp() throws Exception {
        this.analyticsAddTagListener = new AnalyticsAddTagListener(this.identityManager);
        ConversationState conversationState = (ConversationState)Mockito.mock(ConversationState.class);
        CONVERSATION_STATE.when(ConversationState::getCurrent).thenReturn((Object)conversationState);
        CONVERSATION_STATE.when(() -> ConversationState.getCurrent().getIdentity()).thenReturn((Object)this.identity);
        Mockito.when((Object)this.identity.getUserId()).thenReturn((Object)"user");
        Identity socialIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("user")).thenReturn((Object)socialIdentity);
        Mockito.when((Object)socialIdentity.getId()).thenReturn((Object)"1");
    }

    @Test
    public void onEvent() {
        Page note = new Page();
        note.setId("1");
        note.setWikiOwner("/spaces/space");
        note.setContent("test ><a class=\"metadata-tag\">#testTag</a></span>");
        TagName testTag = new TagName("testTag");
        HashSet<TagName> tagSet = new HashSet<TagName>();
        tagSet.add(testTag);
        Event event = new Event("metadata.tag.added", (Object)new TagObject("notes", note.getId(), note.getParentPageId()), tagSet);
        this.analyticsAddTagListener.onEvent(event);
        ANALYTICS_UTILS.verify(Mockito.times((int)1), () -> AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)Mockito.any())));
    }

    @After
    public void tearDown() throws Exception {
        CONVERSATION_STATE.close();
        ANALYTICS_UTILS.close();
    }
}

