/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.notification.plugin;

import io.meeds.notes.notifications.plugin.MentionInNoteNotificationPlugin;
import java.util.Collections;
import java.util.HashSet;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.NotificationCompletionService;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.utils.Utils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MentionInNoteNotificationPluginTest {
    @Mock
    private UserHandler userhandler;
    @Mock
    private InitParams initParams;
    @Mock
    private OrganizationService orgService;
    @Mock
    private SpaceService spaceService;
    @Mock
    private PortalContainer portalContainer;
    @Mock
    private IdentityManager identityManager;
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<Utils> SOCIAL_UTILS = Mockito.mockStatic(Utils.class);
    private static final MockedStatic<PluginKey> PLUGIN_KEY = Mockito.mockStatic(PluginKey.class);
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<PortalContainer> PORTAL_CONTAINER = Mockito.mockStatic(PortalContainer.class);

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        SOCIAL_UTILS.close();
        PLUGIN_KEY.close();
        EXO_CONTAINER_CONTEXT.close();
        PORTAL_CONTAINER.close();
    }

    @Test
    public void testShouldMakeNotificationForMentionInNoteContext() throws Exception {
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)this.userhandler);
        MentionInNoteNotificationPlugin notePlugin = new MentionInNoteNotificationPlugin(this.initParams);
        HashSet<String> mentionedIds = new HashSet<String>(Collections.singleton("1"));
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationService.class)).thenReturn(null);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationCompletionService.class)).thenReturn(null);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(MentionInNoteNotificationPlugin.NOTE_TITLE, (Object)"title").append(MentionInNoteNotificationPlugin.NOTE_AUTHOR, (Object)"root").append(MentionInNoteNotificationPlugin.CURRENT_USER, (Object)"root").append(MentionInNoteNotificationPlugin.SPACE_ID, (Object)"1").append(MentionInNoteNotificationPlugin.MENTIONED_IDS, mentionedIds).append(MentionInNoteNotificationPlugin.AUTHOR_AVATAR_URL, (Object)"http://localhost:8080/portal/rest/v1/social/users/default-image/avatar").append(MentionInNoteNotificationPlugin.ACTIVITY_LINK, (Object)"http://localhost:8080/portal/g/:spaces:space_test/space_test/notes/1");
        User currentUser = (User)Mockito.mock(User.class);
        Mockito.when((Object)this.userhandler.findUserByName("root")).thenReturn((Object)currentUser);
        Mockito.when((Object)currentUser.getFullName()).thenReturn((Object)"root root");
        Space space = new Space();
        space.setId("1");
        space.setGroupId("space_test");
        COMMONS_UTILS.when(() -> CommonsUtils.getService(OrganizationService.class)).thenReturn((Object)this.orgService);
        PORTAL_CONTAINER.when(PortalContainer::getInstance).thenReturn((Object)this.portalContainer);
        Mockito.when((Object)((SpaceService)this.portalContainer.getComponentInstanceOfType(SpaceService.class))).thenReturn((Object)this.spaceService);
        Mockito.when((Object)((IdentityManager)this.portalContainer.getComponentInstanceOfType(IdentityManager.class))).thenReturn((Object)this.identityManager);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"receiver");
        Mockito.when((Object)this.identityManager.getIdentity(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenReturn((Object)identity);
        Mockito.when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space);
        NotificationInfo notificationInfo = notePlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getFrom());
        Assert.assertEquals((Object)"", (Object)notificationInfo.getTitle());
        Assert.assertEquals((Object)"title", (Object)notificationInfo.getValueOwnerParameter("NOTE_TITLE"));
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getValueOwnerParameter("NOTE_AUTHOR"));
        Assert.assertEquals((Object)"http://localhost:8080/portal/rest/v1/social/users/default-image/avatar", (Object)notificationInfo.getValueOwnerParameter("AUTHOR_AVATAR_URL"));
        Assert.assertEquals((Object)"http://localhost:8080/portal/g/:spaces:space_test/space_test/notes/1", (Object)notificationInfo.getValueOwnerParameter("ACTIVITY_LINK"));
    }
}

