/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;

public class PageTreeNode
extends TreeNode {
    private static final Log log = ExoLogger.getLogger(PageTreeNode.class);
    private Page page;
    private NoteService noteService = (NoteService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NoteService.class);
    private SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);

    public PageTreeNode(Page page) throws Exception {
        super(page.getTitle(), TreeNodeType.PAGE);
        this.page = page;
        this.id = page.getId();
        this.path = this.buildPath();
        this.hasChild = !page.isDraftPage() && !this.noteService.getChildrenNoteOf(page, true, false).isEmpty();
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    @Override
    protected void addChildren(HashMap<String, Object> context, String userId) throws Exception {
        boolean withDrafts = context.containsKey("withDrafts") && (Boolean)context.get("withDrafts") != false;
        List<Page> pages = this.noteService.getChildrenNoteOf(this.page, withDrafts, false);
        Iterator childPageIterator = pages.iterator();
        int size = this.getNumberOfChildren(context, pages.size());
        Page currentPage = (Page)context.get("selectedPage");
        for (int count = 0; childPageIterator.hasNext() && count < size; ++count) {
            Page childPage = (Page)childPageIterator.next();
            if (!this.noteService.hasPermissionOnPage(childPage, PermissionType.VIEWPAGE, ConversationState.getCurrent().getIdentity()) && (currentPage == null || !Utils.isDescendantPage(currentPage, childPage))) continue;
            Space space = this.spaceService.getSpaceByGroupId(childPage.getWikiOwner());
            if (childPage.isDraftPage() && !Utils.canManageNotes(userId, space, childPage)) continue;
            PageTreeNode child = new PageTreeNode(childPage);
            this.children.add(child);
        }
        super.addChildren(context, userId);
    }

    public PageTreeNode getChildByName(String name) throws Exception {
        for (TreeNode child : this.children) {
            if (!child.getName().equals(name)) continue;
            return (PageTreeNode)child;
        }
        return null;
    }

    @Override
    public String buildPath() {
        try {
            WikiPageParams params = new WikiPageParams(this.page.getWikiType(), this.page.getWikiOwner(), this.page.getName());
            return TreeUtils.getPathFromPageParams(params);
        }
        catch (Exception e) {
            log.error((Object)("Cannot build path of wiki page " + this.page.getWikiType() + ":" + this.page.getWikiOwner() + ":" + this.page.getName() + " - Cause : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

