/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.notification.provider;

import io.meeds.notes.notifications.provider.MailTemplateProvider;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MailTemplateProviderTest {
    private MailTemplateProvider.TemplateBuilder templateBuilder;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private NotificationContext ctx;
    @Mock
    private NotificationInfo notificationInfo;
    @Mock
    private Identity receiver;
    @Mock
    private Profile profile;
    private static final MockedStatic<TemplateUtils> TEMPLATE_UTILS = Mockito.mockStatic(TemplateUtils.class);
    private static final MockedStatic<NotificationPluginUtils> NOTIFICATION_PLUGIN_UTILS = Mockito.mockStatic(NotificationPluginUtils.class);
    private static final MockedStatic<LinkProviderUtils> LINK_PROVIDER_UTILS = Mockito.mockStatic(LinkProviderUtils.class);

    @Before
    public void setUp() {
        MailTemplateProvider mailTemplateProvider = new MailTemplateProvider(new InitParams(), this.identityManager);
        this.templateBuilder = new MailTemplateProvider.TemplateBuilder(mailTemplateProvider);
    }

    @After
    public void tearDown() {
        TEMPLATE_UTILS.close();
        NOTIFICATION_PLUGIN_UTILS.close();
        LINK_PROVIDER_UTILS.close();
    }

    @Test
    public void testMakeMessage() {
        Mockito.when((Object)this.ctx.getNotificationInfo()).thenReturn((Object)this.notificationInfo);
        Mockito.when((Object)this.notificationInfo.getKey()).thenReturn((Object)new PluginKey("MentionInNoteNotificationPlugin"));
        Mockito.when((Object)this.notificationInfo.getValueOwnerParameter(Mockito.anyString())).thenReturn((Object)"testValue");
        Mockito.when((Object)this.notificationInfo.getTo()).thenReturn((Object)"receiverId");
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "receiverId")).thenReturn((Object)this.receiver);
        Mockito.when((Object)this.receiver.getProfile()).thenReturn((Object)this.profile);
        Mockito.when((Object)this.receiver.getRemoteId()).thenReturn((Object)"receiverId");
        Mockito.when((Object)this.profile.getProperty("firstName")).thenReturn((Object)"ReceiverFirstName");
        TEMPLATE_UTILS.when(() -> TemplateUtils.processGroovy((TemplateContext)((TemplateContext)Mockito.any(TemplateContext.class)))).thenReturn((Object)"you have been mentioned in a note");
        TEMPLATE_UTILS.when(() -> TemplateUtils.processSubject((TemplateContext)((TemplateContext)Mockito.any(TemplateContext.class)))).thenReturn((Object)"author mentioned you in the note test");
        NOTIFICATION_PLUGIN_UTILS.when(() -> NotificationPluginUtils.getLanguage((String)Mockito.anyString())).thenReturn((Object)"en");
        LINK_PROVIDER_UTILS.when(() -> LinkProviderUtils.getBaseUrl()).thenReturn((Object)"baseUrl");
        LINK_PROVIDER_UTILS.when(() -> LinkProviderUtils.getRedirectUrl((String)Mockito.anyString(), (String)Mockito.anyString())).thenReturn((Object)"notifications/settings/redirect/url");
        MessageInfo messageInfo = this.templateBuilder.makeMessage(this.ctx);
        Assert.assertNotNull((Object)messageInfo);
        Assert.assertTrue((boolean)messageInfo.getBody().equals("you have been mentioned in a note"));
        Assert.assertTrue((boolean)messageInfo.getSubject().equals("author mentioned you in the note test"));
    }
}

