/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.plugin.layout.renderer;

import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstancePreferencePlugin;
import io.meeds.notes.model.NotePageData;
import io.meeds.notes.service.NotePageViewService;
import io.meeds.social.util.JsonUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;

public class NoteSingleViewRenderPlugin
implements PortletInstancePreferencePlugin {
    private static final String CMS_SETTING_PREFERENCE_NAME = "name";
    private static final String DATA_INIT_PREFERENCE_NAME = "data.init";
    private NotePageViewService notePageViewService;

    public NoteSingleViewRenderPlugin(NotePageViewService notePageViewService) {
        this.notePageViewService = notePageViewService;
    }

    public String getPortletName() {
        return "NotePageView";
    }

    public List<PortletInstancePreference> generatePreferences(Application application, Portlet preferences) {
        String settingName = this.getCmsSettingName(preferences);
        if (StringUtils.isBlank((CharSequence)settingName)) {
            if (preferences != null && preferences.getPreference(DATA_INIT_PREFERENCE_NAME) != null) {
                return Collections.singletonList(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, preferences.getPreference(DATA_INIT_PREFERENCE_NAME).getValue()));
            }
            return Collections.emptyList();
        }
        NotePageData notePageData = this.notePageViewService.getNotePageData(settingName);
        return Collections.singletonList(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, JsonUtils.toJsonString((Object)notePageData)));
    }

    private String getCmsSettingName(Portlet preferences) {
        if (preferences == null) {
            return null;
        }
        Preference settingNamePreference = preferences.getPreference(CMS_SETTING_PREFERENCE_NAME);
        return settingNamePreference == null ? null : settingNamePreference.getValue();
    }
}

