/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.PageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.PageMoveEntity;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;
import org.exoplatform.wiki.jpa.entity.PermissionEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;

@Entity(name="WikiPageEntity")
@Table(name="WIKI_PAGES")
@NamedQueries(value={@NamedQuery(name="wikiPage.getAllIds", query="SELECT p.id FROM WikiPageEntity p  WHERE p.deleted = false ORDER BY p.id"), @NamedQuery(name="wikiPage.countAllIds", query="SELECT COUNT(*) FROM WikiPageEntity p  WHERE p.deleted = false"), @NamedQuery(name="wikiPage.getPageOfWikiByName", query="SELECT p FROM WikiPageEntity p JOIN p.wiki w WHERE p.name = :name AND w.type = :type AND w.owner = :owner AND p.deleted = false"), @NamedQuery(name="wikiPage.getAllPagesOfWiki", query="SELECT p FROM WikiPageEntity p JOIN p.wiki w WHERE w.type = :type AND w.owner = :owner"), @NamedQuery(name="wikiPage.getPagesOfWiki", query="SELECT p FROM WikiPageEntity p JOIN p.wiki w WHERE w.type = :type AND w.owner = :owner AND p.deleted = :deleted"), @NamedQuery(name="wikiPage.getChildrenPages", query="SELECT p FROM WikiPageEntity p WHERE p.parentPage.id = :id AND p.deleted = false ORDER BY p.name"), @NamedQuery(name="wikiPage.getAllPagesBySyntax", query="SELECT p FROM WikiPageEntity p WHERE p.syntax = :syntax OR p.syntax IS NULL ORDER BY p.updatedDate DESC"), @NamedQuery(name="wikiPage.countPageChildrenById", query="SELECT COUNT(*) FROM WikiPageEntity p WHERE p.parentPage.id = :id AND p.deleted = false")})
public class PageEntity
extends BasePageEntity {
    @Id
    @Column(name="PAGE_ID")
    @SequenceGenerator(name="SEQ_WIKI_PAGES_PAGE_ID", sequenceName="SEQ_WIKI_PAGES_PAGE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_PAGES_PAGE_ID")
    private long id;
    @ManyToOne
    @JoinColumn(name="WIKI_ID")
    private WikiEntity wiki;
    @ManyToOne
    @JoinColumn(name="PARENT_PAGE_ID")
    private PageEntity parentPage;
    @OneToMany(mappedBy="page", cascade={CascadeType.ALL})
    private List<PageVersionEntity> versions;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="page")
    private List<PageAttachmentEntity> attachments;
    @ManyToMany
    @JoinTable(name="WIKI_PAGES_RELATED_PAGES", joinColumns={@JoinColumn(name="PAGE_ID")}, inverseJoinColumns={@JoinColumn(name="RELATED_PAGE_ID")})
    private List<PageEntity> relatedPages;
    @Column(name="OWNER")
    private String owner;
    @Column(name="EDITION_COMMENT")
    private String comment;
    @Column(name="URL")
    private String url;
    @Column(name="MINOR_EDIT")
    private boolean minorEdit;
    @Column(name="ACTIVITY_ID")
    private String activityId;
    @ElementCollection
    @CollectionTable(name="WIKI_WATCHERS", joinColumns={@JoinColumn(name="PAGE_ID")})
    @Column(name="USERNAME")
    private Set<String> watchers = new HashSet<String>();
    @ElementCollection
    @CollectionTable(name="WIKI_PAGE_PERMISSIONS", joinColumns={@JoinColumn(name="PAGE_ID")})
    private List<PermissionEntity> permissions;
    @OneToMany(mappedBy="page", cascade={CascadeType.ALL})
    private List<PageMoveEntity> moves = new ArrayList<PageMoveEntity>();
    @Column(name="DELETED")
    private boolean deleted;

    public long getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isMinorEdit() {
        return this.minorEdit;
    }

    public void setMinorEdit(boolean minorEdit) {
        this.minorEdit = minorEdit;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public List<PermissionEntity> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<PermissionEntity> permission) {
        this.permissions = permission;
    }

    public WikiEntity getWiki() {
        return this.wiki;
    }

    public void setWiki(WikiEntity wiki) {
        this.wiki = wiki;
    }

    public PageEntity getParentPage() {
        return this.parentPage;
    }

    public void setParentPage(PageEntity parentPage) {
        this.parentPage = parentPage;
    }

    public List<PageVersionEntity> getVersions() {
        return this.versions;
    }

    public void setVersions(List<PageVersionEntity> versions) {
        this.versions = versions;
    }

    public List<PageAttachmentEntity> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<PageAttachmentEntity> attachments) {
        this.attachments = attachments;
    }

    public Set<String> getWatchers() {
        return this.watchers;
    }

    public void setWatchers(Set<String> watchers) {
        this.watchers = watchers;
    }

    public List<PageEntity> getRelatedPages() {
        return this.relatedPages;
    }

    public void setRelatedPages(List<PageEntity> relatedPages) {
        this.relatedPages = relatedPages;
    }

    public List<PageMoveEntity> getMoves() {
        return this.moves;
    }

    public void setMoves(List<PageMoveEntity> moves) {
        this.moves = moves;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}

