/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.mow.core.api;

import java.util.Iterator;
import java.util.List;
import org.exoplatform.wiki.jpa.BaseTest;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;

public class TestVersioning
extends BaseTest {
    private NoteService noteService;
    private WikiService wikiService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.noteService = (NoteService)this.getContainer().getComponentInstanceOfType(NoteService.class);
        this.wikiService = (WikiService)this.getContainer().getComponentInstanceOfType(WikiService.class);
    }

    public void testGetVersionHistory() throws Exception {
        Wiki wiki = this.getOrCreateWiki(this.wikiService, WikiType.PORTAL.toString(), "versioning1");
        Page page = new Page("testGetVersionHistory-001", "testGetVersionHistory-001");
        page = this.noteService.createNote(wiki, wiki.getWikiHome(), page);
        this.noteService.createVersionOfNote(page, "");
        page = this.noteService.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), "testGetVersionHistory-001");
        TestVersioning.assertNotNull((Object)page);
        List versions = this.noteService.getVersionsHistoryOfNote(page, "");
        TestVersioning.assertNotNull((Object)versions);
    }

    public void testCreateVersionHistoryTree() throws Exception {
        Wiki wiki = this.getOrCreateWiki(this.wikiService, WikiType.PORTAL.toString(), "versioning2");
        Page page = new Page("testCreateVersionHistoryTree-001", "testCreateVersionHistoryTree-001");
        page.setContent("testCreateVersionHistoryTree-ver0.0");
        page = this.noteService.createNote(wiki, wiki.getWikiHome(), page);
        page.setTitle("testCreateVersionHistoryTree");
        page.setContent("testCreateVersionHistoryTree-ver1.0");
        this.noteService.updateNote(page);
        this.noteService.createVersionOfNote(page, "");
        page.setContent("testCreateVersionHistoryTree-ver2.0");
        this.noteService.updateNote(page);
        this.noteService.createVersionOfNote(page, "");
        List versions = this.noteService.getVersionsHistoryOfNote(page, "");
        TestVersioning.assertNotNull((Object)versions);
        TestVersioning.assertEquals((int)2, (int)versions.size());
        this.noteService.restoreVersionOfNote(String.valueOf(((PageHistory)versions.get(0)).getVersionNumber()), page, "");
        page = this.wikiService.getPageOfWikiByName(wiki.getType(), wiki.getOwner(), page.getName());
        TestVersioning.assertEquals((String)"testCreateVersionHistoryTree-ver1.0", (String)page.getContent());
        page.setContent("testCreateVersionHistoryTree-ver3.0");
        page.setContent("testCreateVersionHistoryTree-ver2.0");
        this.noteService.updateNote(page);
        this.noteService.createVersionOfNote(page, "");
        versions = this.noteService.getVersionsHistoryOfNote(page, "");
        TestVersioning.assertNotNull((Object)versions);
        TestVersioning.assertEquals((int)4, (int)versions.size());
        Iterator itVersions = versions.iterator();
        PageHistory pageVersion = (PageHistory)itVersions.next();
        TestVersioning.assertEquals((String)"testCreateVersionHistoryTree-ver1.0", (String)pageVersion.getContent());
        pageVersion = (PageHistory)itVersions.next();
        TestVersioning.assertEquals((String)"testCreateVersionHistoryTree-ver2.0", (String)pageVersion.getContent());
        pageVersion = (PageHistory)itVersions.next();
        TestVersioning.assertEquals((String)"testCreateVersionHistoryTree-ver2.0", (String)pageVersion.getContent());
        pageVersion = (PageHistory)itVersions.next();
        TestVersioning.assertEquals((String)"testCreateVersionHistoryTree-ver2.0", (String)pageVersion.getContent());
    }
}

