/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.exoplatform.wiki.jpa.dao.WikiBaseDAO;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.model.WikiType;

public class PageDAO
extends WikiBaseDAO<PageEntity, Long> {
    public List<PageEntity> getAllPagesOfWiki(String wikiType, String wikiOwner) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getAllPagesOfWiki", PageEntity.class).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner);
        return query.getResultList();
    }

    public List<PageEntity> getPagesOfWiki(String wikiType, String wikiOwner, boolean deleted) {
        if (wikiType.toUpperCase().equals(WikiType.GROUP.name())) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getPagesOfWiki", PageEntity.class).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner).setParameter("deleted", (Object)deleted);
        return query.getResultList();
    }

    public PageEntity getPageOfWikiByName(String wikiType, String wikiOwner, String pageName) {
        if (WikiType.GROUP.isSame(wikiType)) {
            wikiOwner = this.validateGroupWikiOwner(wikiOwner);
        }
        PageEntity pageEntity = null;
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getPageOfWikiByName", PageEntity.class).setParameter("name", (Object)pageName).setParameter("type", (Object)wikiType).setParameter("owner", (Object)wikiOwner);
        List results = query.getResultList();
        if (results != null) {
            for (PageEntity pageEntityResult : results) {
                if (!pageEntityResult.getName().equals(pageName)) continue;
                if (pageEntity == null) {
                    pageEntity = pageEntityResult;
                    continue;
                }
                throw new NonUniqueResultException("More than 1 page with the name " + pageName + " in the wiki " + wikiType + ":" + wikiOwner + " has been returned");
            }
        }
        return pageEntity;
    }

    public List<PageEntity> getChildrenPages(PageEntity page) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getChildrenPages", PageEntity.class).setParameter("id", (Object)page.getId());
        return query.getResultList();
    }

    public List<Long> findAllIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPage.getAllIds", Long.class);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public Long countAllIds() {
        return (Long)this.getEntityManager().createNamedQuery("wikiPage.countAllIds").getSingleResult();
    }

    public List<PageEntity> findAllBySyntax(String syntax, int offset, int limit) {
        return this.getEntityManager().createNamedQuery("wikiPage.getAllPagesBySyntax").setParameter("syntax", (Object)syntax).setFirstResult(offset).setMaxResults(limit).getResultList();
    }

    public Long countPageChildrenById(Long pageId) {
        return (Long)this.getEntityManager().createNamedQuery("wikiPage.countPageChildrenById").setParameter("id", (Object)pageId).getSingleResult();
    }
}

