/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.organization;

import java.util.List;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.dao.TemplateDAO;
import org.exoplatform.wiki.jpa.dao.WikiDAO;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.TemplateEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.storage.EntityConverter;

public class WikiGroupEventListener
extends GroupEventListener {
    private static final Log LOG = ExoLogger.getLogger(WikiGroupEventListener.class);
    private WikiDAO wikiDAO;
    private PageDAO pageDAO;
    private TemplateDAO templateDAO;
    private IndexingService indexingService;
    private NoteService noteService;

    public WikiGroupEventListener(WikiDAO wikiDAO, PageDAO pageDAO, TemplateDAO templateDAO, IndexingService indexingService, NoteService noteService) {
        this.wikiDAO = wikiDAO;
        this.pageDAO = pageDAO;
        this.templateDAO = templateDAO;
        this.indexingService = indexingService;
        this.noteService = noteService;
    }

    public void postDelete(Group group) throws Exception {
        WikiEntity wikiGroup;
        List<TemplateEntity> templates;
        LOG.info((Object)("Removing all wiki data of the group " + group.getId()));
        List<PageEntity> pages = this.pageDAO.getAllPagesOfWiki(WikiType.GROUP.toString().toLowerCase(), group.getId());
        if (pages != null) {
            for (PageEntity page : pages) {
                this.indexingService.unindex("wiki-page", String.valueOf(page.getId()));
                this.noteService.removeDraftOfNote(EntityConverter.convertPageEntityToPage(page));
                this.noteService.removeOrphanDraftPagesByParentPage(page.getId());
            }
            this.pageDAO.deleteAll(pages);
        }
        if ((templates = this.templateDAO.getTemplatesOfWiki(WikiType.GROUP.toString().toLowerCase(), group.getId())) != null) {
            this.templateDAO.deleteAll(templates);
        }
        if ((wikiGroup = this.wikiDAO.getWikiByTypeAndOwner(WikiType.GROUP.toString().toLowerCase(), group.getId())) != null) {
            this.wikiDAO.delete(wikiGroup);
        }
    }
}

