/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.plugin;

import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NoteContentLinkPlugin
implements ContentLinkPlugin {
    public static final String OBJECT_TYPE = "notes";
    private static final String TITLE_KEY = "contentLink.note";
    private static final String ICON = "fa fa-clipboard";
    private static final String COMMAND = "note";
    private static final ContentLinkExtension EXTENSION = new ContentLinkExtension("notes", "contentLink.note", "fa fa-clipboard", "note");
    @Autowired
    private ContentLinkPluginService contentLinkPluginService;
    @Autowired
    private NoteService noteService;
    @Autowired
    private UserACL userAcl;

    @PostConstruct
    public void init() {
        this.contentLinkPluginService.addPlugin((ContentLinkPlugin)this);
    }

    public ContentLinkExtension getExtension() {
        return EXTENSION;
    }

    public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
        WikiSearchData data = new WikiSearchData(keyword, identity == null ? null : identity.getUserId());
        data.setLimit(limit + offset);
        data.setWikiType("group");
        List results = this.noteService.search(data).getAll();
        return results.stream().map(searchResult -> this.toContentLink((SearchResult)searchResult, identity, locale)).filter(Objects::nonNull).toList();
    }

    public String getContentTitle(String objectId, Locale locale) {
        Page note = this.noteService.getNoteByIdAndLang(Long.parseLong(objectId), locale == null ? null : locale.toLanguageTag());
        if (note == null) {
            note = this.noteService.getNoteById(objectId);
        }
        return note == null || note.isDeleted() ? null : note.getTitle();
    }

    private ContentLinkSearchResult toContentLink(SearchResult searchResult, Identity identity, Locale locale) {
        Page pageWithLang;
        if (!this.userAcl.hasAccessPermission(OBJECT_TYPE, String.valueOf(searchResult.getId()), identity)) {
            return null;
        }
        Page page = this.noteService.getNoteByIdAndLang(searchResult.getId(), searchResult.getLang());
        if (!StringUtils.equals((CharSequence)locale.toLanguageTag(), (CharSequence)searchResult.getLang()) && (pageWithLang = this.noteService.getNoteByIdAndLang(searchResult.getId(), locale.toLanguageTag())) != null) {
            page = pageWithLang;
        }
        return new ContentLinkSearchResult(OBJECT_TYPE, String.valueOf(searchResult.getId()), page.getTitle(), EXTENSION.getIcon());
    }
}

