/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.storage;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.BaseWikiJPAIntegrationTest;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.storage.NoteDataStorage;
import org.junit.Test;
import org.mockito.Mockito;

public class NoteDataStorageTest
extends BaseWikiJPAIntegrationTest {
    private static final String WIKI_OWNER = "wiki1";
    private static final String WIKI_TYPE_PORTAL = "portal";
    protected NoteDataStorage storage;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.storage = (NoteDataStorage)PortalContainer.getInstance().getComponentInstanceOfType(NoteDataStorage.class);
    }

    @Test
    public void testCreateWiki() throws Exception {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        this.storage.createWiki(wiki);
        Wiki createdWiki = this.storage.getWikiByTypeAndOwner(WIKI_TYPE_PORTAL, WIKI_OWNER);
        Page wikiHomePage = createdWiki.getWikiHome();
        NoteDataStorageTest.assertNotNull((Object)createdWiki);
        NoteDataStorageTest.assertEquals((String)WIKI_TYPE_PORTAL, (String)createdWiki.getType());
        NoteDataStorageTest.assertEquals((String)WIKI_OWNER, (String)createdWiki.getOwner());
        NoteDataStorageTest.assertNotNull((Object)wikiHomePage);
        NoteDataStorageTest.assertEquals((String)"Home", (String)wikiHomePage.getName());
        NoteDataStorageTest.assertEquals((String)"Home", (String)wikiHomePage.getTitle());
        NoteDataStorageTest.assertNotNull((Object)wikiHomePage.getCreatedDate());
        NoteDataStorageTest.assertNotNull((Object)wikiHomePage.getUpdatedDate());
        NoteDataStorageTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)wikiHomePage.getContent()));
    }

    @Test
    public void testParentPageOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page parentPage = new Page();
        parentPage.setWikiId(wiki.getId());
        parentPage.setWikiType(wiki.getType());
        parentPage.setWikiOwner(wiki.getOwner());
        parentPage.setName("page0");
        parentPage.setTitle("Page 0");
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        this.storage.createPage(wiki, wiki.getWikiHome(), parentPage);
        this.storage.createPage(wiki, parentPage, page);
        Page pageOfWikiByName = this.storage.getPageOfWikiByName(WIKI_TYPE_PORTAL, WIKI_OWNER, "page1");
        NoteDataStorageTest.assertEquals((int)3, (int)this.pageDAO.findAll().size());
        NoteDataStorageTest.assertNotNull((Object)pageOfWikiByName);
        NoteDataStorageTest.assertEquals((String)WIKI_TYPE_PORTAL, (String)pageOfWikiByName.getWikiType());
        NoteDataStorageTest.assertEquals((String)WIKI_OWNER, (String)pageOfWikiByName.getWikiOwner());
        NoteDataStorageTest.assertEquals((String)"page1", (String)pageOfWikiByName.getName());
        NoteDataStorageTest.assertEquals((String)"Page 1", (String)pageOfWikiByName.getTitle());
    }

    @Test
    public void testGetAllWikiPages() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner("wikiTest4");
        wiki = this.storage.createWiki(wiki);
        Page parentPage = new Page();
        parentPage.setWikiId(wiki.getId());
        parentPage.setWikiType(wiki.getType());
        parentPage.setWikiOwner(wiki.getType());
        parentPage.setName("page0");
        parentPage.setTitle("Page 0");
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        this.storage.createPage(wiki, wiki.getWikiHome(), parentPage);
        this.storage.createPage(wiki, parentPage, page);
        List pagesOfWiki = this.storage.getPagesOfWiki(wiki.getType(), wiki.getOwner());
        NoteDataStorageTest.assertNotNull((Object)pagesOfWiki);
        NoteDataStorageTest.assertEquals((int)3, (int)pagesOfWiki.size());
    }

    @Test
    public void testChildrenPagesOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page parentPage = new Page();
        parentPage.setWikiId(wiki.getId());
        parentPage.setWikiType(wiki.getType());
        parentPage.setWikiOwner(wiki.getOwner());
        parentPage.setName("page0");
        parentPage.setTitle("Page 0");
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page2 = new Page();
        page2.setWikiId(wiki.getId());
        page2.setWikiType(wiki.getType());
        page2.setWikiOwner(wiki.getOwner());
        page2.setName("page2");
        page2.setTitle("Page 2");
        this.storage.createPage(wiki, wiki.getWikiHome(), parentPage);
        this.storage.createPage(wiki, parentPage, page1);
        this.storage.createPage(wiki, parentPage, page2);
        List childrenPages = this.storage.getChildrenPageOf(parentPage, true, true);
        NoteDataStorageTest.assertEquals((int)4, (int)this.pageDAO.findAll().size());
        NoteDataStorageTest.assertNotNull((Object)childrenPages);
        NoteDataStorageTest.assertEquals((int)2, (int)childrenPages.size());
    }

    @Test
    public void testDeletePage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        NoteDataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.storage.deletePage(wiki.getType(), wiki.getOwner(), page1.getName());
        NoteDataStorageTest.assertEquals((int)1, (int)this.pageDAO.findAllIds(0, 0).size());
        List pages = this.pageDAO.getAllPagesOfWiki(wiki.getType(), wiki.getOwner());
        NoteDataStorageTest.assertEquals((int)2, (int)pages.size());
        pages = this.pageDAO.getPagesOfWiki(wiki.getType(), wiki.getOwner(), false);
        NoteDataStorageTest.assertEquals((int)1, (int)pages.size());
        NoteDataStorageTest.assertEquals((String)"Home", (String)((PageEntity)pages.get(0)).getName());
        pages = this.pageDAO.getPagesOfWiki(wiki.getType(), wiki.getOwner(), true);
        NoteDataStorageTest.assertEquals((int)1, (int)pages.size());
        NoteDataStorageTest.assertEquals((String)"page1", (String)((PageEntity)pages.get(0)).getName());
    }

    @Test
    public void testDeletePageTree() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page2 = new Page();
        page2.setWikiId(wiki.getId());
        page2.setWikiType(wiki.getType());
        page2.setWikiOwner(wiki.getOwner());
        page2.setName("page2");
        page2.setTitle("Page 2");
        this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        this.storage.createPage(wiki, page1, page2);
        NoteDataStorageTest.assertEquals((int)3, (int)this.pageDAO.findAll().size());
        this.storage.deletePage(wiki.getType(), wiki.getOwner(), page1.getName());
        NoteDataStorageTest.assertEquals((int)1, (int)this.pageDAO.findAllIds(0, 0).size());
    }

    @Test
    public void testMovePage() throws WikiException {
        Wiki wiki1 = new Wiki();
        wiki1.setType(WIKI_TYPE_PORTAL);
        wiki1.setOwner(WIKI_OWNER);
        wiki1 = this.storage.createWiki(wiki1);
        Wiki wiki2 = new Wiki();
        wiki2.setType(WIKI_TYPE_PORTAL);
        wiki2.setOwner("wiki2");
        wiki2 = this.storage.createWiki(wiki2);
        Page page1 = new Page();
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page11 = new Page();
        page11.setName("page11");
        page11.setTitle("Page 11");
        Page page2 = new Page();
        page2.setName("page2");
        page2.setTitle("Page 2");
        this.storage.createPage(wiki1, wiki1.getWikiHome(), page1);
        this.storage.createPage(wiki1, page1, page11);
        this.storage.createPage(wiki1, wiki1.getWikiHome(), page2);
        NoteDataStorageTest.assertEquals((int)5, (int)this.pageDAO.findAll().size());
        NoteDataStorageTest.assertEquals((int)2, (int)this.storage.getChildrenPageOf(wiki1.getWikiHome(), true, false).size());
        this.storage.movePage(new WikiPageParams(wiki1.getType(), wiki1.getOwner(), page1.getName()), new WikiPageParams(wiki2.getType(), wiki2.getOwner(), wiki2.getWikiHome().getName()));
        NoteDataStorageTest.assertEquals((int)5, (int)this.pageDAO.findAll().size());
        NoteDataStorageTest.assertEquals((int)1, (int)this.storage.getChildrenPageOf(wiki1.getWikiHome(), true, false).size());
        List wiki2HomeChildrenPages = this.storage.getChildrenPageOf(wiki2.getWikiHome(), true, false);
        NoteDataStorageTest.assertEquals((int)1, (int)wiki2HomeChildrenPages.size());
        Page movedPage1 = (Page)wiki2HomeChildrenPages.get(0);
        NoteDataStorageTest.assertEquals((String)"page1", (String)movedPage1.getName());
        NoteDataStorageTest.assertEquals((String)"Page 1", (String)movedPage1.getTitle());
        NoteDataStorageTest.assertEquals((int)1, (int)this.storage.getChildrenPageOf(movedPage1, true, false).size());
        Page fetchedPage11 = this.storage.getPageOfWikiByName(PortalConfig.PORTAL_TYPE, "wiki2", "page11");
        NoteDataStorageTest.assertNotNull((Object)fetchedPage11);
        NoteDataStorageTest.assertEquals((String)"page11", (String)fetchedPage11.getName());
    }

    @Test
    public void testUpdatePage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        NoteDataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        createdPage.setTitle("Page 1 updated");
        this.storage.updatePage(createdPage);
        NoteDataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        Page updatedPage = this.storage.getPageById(createdPage.getId());
        NoteDataStorageTest.assertNotNull((Object)updatedPage);
        NoteDataStorageTest.assertEquals((String)"page1", (String)updatedPage.getName());
        NoteDataStorageTest.assertEquals((String)"Page 1 updated", (String)updatedPage.getTitle());
    }

    @Test
    public void testRenamePage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        NoteDataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.storage.renamePage(wiki.getType(), wiki.getOwner(), page1.getName(), "newName", "New Title");
        NoteDataStorageTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        Page renamedPage = this.storage.getPageById(createdPage.getId());
        NoteDataStorageTest.assertNotNull((Object)renamedPage);
        NoteDataStorageTest.assertEquals((String)"newName", (String)renamedPage.getName());
        NoteDataStorageTest.assertEquals((String)"New Title", (String)renamedPage.getTitle());
    }

    @Test
    public void testRelatedPagesOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page0");
        page.setTitle("Page 0");
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setCreatedDate(new Date());
        page1.setUpdatedDate(new Date());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page2 = new Page();
        page2.setWikiId(wiki.getId());
        page2.setWikiType(wiki.getType());
        page2.setWikiOwner(wiki.getOwner());
        page2.setCreatedDate(new Date());
        page2.setUpdatedDate(new Date());
        page2.setName("page2");
        page2.setTitle("Page 2");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Page createdPage1 = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        NoteDataStorageTest.assertNotNull((Object)createdPage1);
        Page createdPage2 = this.storage.createPage(wiki, wiki.getWikiHome(), page2);
        NoteDataStorageTest.assertNotNull((Object)createdPage2);
        this.storage.addRelatedPage(createdPage, createdPage1);
        this.storage.addRelatedPage(createdPage, createdPage2);
        NoteDataStorageTest.assertEquals((int)4, (int)this.pageDAO.findAll().size());
        NoteDataStorageTest.assertNotNull((Object)createdPage);
        NoteDataStorageTest.assertNotNull((Object)this.storage.getRelatedPagesOfPage(createdPage));
        NoteDataStorageTest.assertEquals((int)2, (int)this.storage.getRelatedPagesOfPage(createdPage).size());
    }

    @Test
    public void testRemoveRelatedPagesOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page0");
        page.setTitle("Page 0");
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setCreatedDate(new Date());
        page1.setUpdatedDate(new Date());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page page2 = new Page();
        page2.setWikiId(wiki.getId());
        page2.setWikiType(wiki.getType());
        page2.setWikiOwner(wiki.getOwner());
        page2.setCreatedDate(new Date());
        page2.setUpdatedDate(new Date());
        page2.setName("page2");
        page2.setTitle("Page 2");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        NoteDataStorageTest.assertNotNull((Object)createdPage);
        Page createdPage1 = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        NoteDataStorageTest.assertNotNull((Object)createdPage1);
        Page createdPage2 = this.storage.createPage(wiki, wiki.getWikiHome(), page2);
        NoteDataStorageTest.assertNotNull((Object)createdPage2);
        this.storage.addRelatedPage(createdPage, page1);
        this.storage.addRelatedPage(createdPage, page2);
        List relatedPagesBeforeDeletion = this.storage.getRelatedPagesOfPage(page);
        this.storage.removeRelatedPage(createdPage, createdPage1);
        List relatedPagesAfterDeletion = this.storage.getRelatedPagesOfPage(page);
        NoteDataStorageTest.assertNotNull((Object)relatedPagesBeforeDeletion);
        NoteDataStorageTest.assertEquals((int)2, (int)relatedPagesBeforeDeletion.size());
        NoteDataStorageTest.assertNotNull((Object)relatedPagesAfterDeletion);
        NoteDataStorageTest.assertEquals((int)1, (int)relatedPagesAfterDeletion.size());
    }

    @Test
    public void testGetDraftsOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.add(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 Updated");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setUpdatedDate(oneYearAgo);
        draftPage1.setCreatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user1");
        draftPage2.setName("DraftPage1");
        draftPage2.setTitle("DraftPage 1");
        draftPage2.setContent("Content Page 1 Updated Again");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("2");
        draftPage2.setUpdatedDate(now);
        draftPage2.setCreatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user1");
        List fetchedDrafts = this.storage.getDraftsOfPage(Long.valueOf(createdPage.getId()));
        NoteDataStorageTest.assertNotNull((Object)fetchedDrafts);
        NoteDataStorageTest.assertEquals((int)2, (int)fetchedDrafts.size());
    }

    @Test
    public void testGetLatestDraftOfPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.add(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 Updated");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setUpdatedDate(oneYearAgo);
        draftPage1.setCreatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user1");
        draftPage2.setName("DraftPage1");
        draftPage2.setTitle("DraftPage 1");
        draftPage2.setContent("Content Page 1 Updated Again");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("2");
        draftPage2.setUpdatedDate(now);
        draftPage2.setCreatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user1");
        DraftPage latestDraft = this.storage.getLatestDraftOfPage(createdPage);
        NoteDataStorageTest.assertNotNull((Object)latestDraft);
        NoteDataStorageTest.assertEquals((String)draftPage2.getName(), (String)latestDraft.getName());
    }

    @Test
    public void testDraftPageByNameAndTargetPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 Updated");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setUpdatedDate(oneYearAgo);
        draftPage1.setCreatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user1");
        draftPage2.setName("DraftPage2");
        draftPage2.setTitle("DraftPage 2");
        draftPage2.setContent("Content Page 2 Updated");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("1");
        draftPage2.setUpdatedDate(now);
        draftPage2.setCreatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user1");
        DraftPage fetchedDraftPage = this.storage.getDraft(new WikiPageParams(WIKI_TYPE_PORTAL, WIKI_OWNER, "page1"));
        NoteDataStorageTest.assertNotNull((Object)fetchedDraftPage);
        NoteDataStorageTest.assertEquals((String)"DraftPage2", (String)fetchedDraftPage.getName());
    }

    @Test
    public void testGetExistingOrNewDraftPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        NoteDataStorageTest.assertNotNull((Object)createdPage);
        Page page1 = this.storage.getExsitedOrNewDraftPageById(WIKI_TYPE_PORTAL, WIKI_OWNER, "page1", "user1");
        NoteDataStorageTest.assertNotNull((Object)page1);
        NoteDataStorageTest.assertTrue((boolean)(page1 instanceof DraftPage));
        NoteDataStorageTest.assertEquals((String)PortalConfig.USER_TYPE, (String)page1.getWikiType());
        NoteDataStorageTest.assertEquals((String)"user1", (String)page1.getWikiOwner());
        NoteDataStorageTest.assertEquals((String)"page1", (String)page1.getName());
    }

    @Test
    public void testDeleteDraftPageByNameAndTargetPage() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 User1");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setCreatedDate(oneYearAgo);
        draftPage1.setUpdatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user2");
        draftPage2.setName("DraftPage2");
        draftPage2.setTitle("DraftPage 2");
        draftPage2.setContent("Content Page 1 User 2");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("1");
        draftPage2.setCreatedDate(now);
        draftPage2.setUpdatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user2");
        this.storage.deleteDraftOfPage(createdPage);
        DraftPage initialDraftPage = this.storage.getDraft(new WikiPageParams(WIKI_TYPE_PORTAL, WIKI_OWNER, "page1"));
        NoteDataStorageTest.assertNull((Object)initialDraftPage);
    }

    @Test
    public void testDeleteDraftPageByName() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, -1);
        Date oneYearAgo = calendar.getTime();
        DraftPage draftPage1 = new DraftPage();
        draftPage1.setAuthor("user1");
        draftPage1.setName("DraftPage1");
        draftPage1.setTitle("DraftPage 1");
        draftPage1.setContent("Content Page 1 User1");
        draftPage1.setTargetPageId(createdPage.getId());
        draftPage1.setTargetPageRevision("1");
        draftPage1.setUpdatedDate(oneYearAgo);
        draftPage1.setCreatedDate(oneYearAgo);
        DraftPage draftPage2 = new DraftPage();
        draftPage2.setAuthor("user2");
        draftPage2.setName("DraftPage2");
        draftPage2.setTitle("DraftPage 2");
        draftPage2.setContent("Content Page 1 User 2");
        draftPage2.setTargetPageId(createdPage.getId());
        draftPage2.setTargetPageRevision("1");
        draftPage2.setUpdatedDate(now);
        draftPage2.setCreatedDate(now);
        this.storage.createDraftPageForUser(draftPage1, "user1");
        this.storage.createDraftPageForUser(draftPage2, "user2");
        this.storage.deleteDraftByName("DraftPage1");
        DraftPage initialDraftPage = this.storage.getDraft(new WikiPageParams(WIKI_TYPE_PORTAL, WIKI_OWNER, "page1"));
        NoteDataStorageTest.assertNotNull((Object)initialDraftPage);
        this.storage.deleteDraftByName("DraftPage2");
        initialDraftPage = this.storage.getDraft(new WikiPageParams(WIKI_TYPE_PORTAL, WIKI_OWNER, "page1"));
        NoteDataStorageTest.assertNull((Object)initialDraftPage);
    }

    @Test
    public void testPageVersions() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        this.storage.addPageVersion(createdPage, identity.getId());
        List pageVersions1 = this.storage.getVersionsOfPage(createdPage);
        this.storage.addPageVersion(createdPage, identity.getId());
        List pageVersions2 = this.storage.getVersionsOfPage(createdPage);
        NoteDataStorageTest.assertNotNull((Object)pageVersions1);
        NoteDataStorageTest.assertEquals((int)1, (int)pageVersions1.size());
        NoteDataStorageTest.assertEquals((String)"1", (String)((PageVersion)pageVersions1.get(0)).getName());
        NoteDataStorageTest.assertNotNull((Object)pageVersions2);
        NoteDataStorageTest.assertEquals((int)2, (int)pageVersions2.size());
        NoteDataStorageTest.assertEquals((String)"2", (String)((PageVersion)pageVersions2.get(0)).getName());
        NoteDataStorageTest.assertEquals((String)"1", (String)((PageVersion)pageVersions2.get(1)).getName());
    }

    @Test
    public void testPageVersionsHistory() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        this.storage.addPageVersion(createdPage, identity.getId());
        List pageVersions1 = this.storage.getHistoryOfPage(createdPage);
        this.storage.addPageVersion(createdPage, identity.getId());
        List pageVersions2 = this.storage.getHistoryOfPage(createdPage);
        NoteDataStorageTest.assertNotNull((Object)pageVersions1);
        NoteDataStorageTest.assertEquals((int)1, (int)pageVersions1.size());
        NoteDataStorageTest.assertEquals((String)"1", (String)Long.toString(((PageHistory)pageVersions1.get(0)).getVersionNumber()));
        NoteDataStorageTest.assertNotNull((Object)pageVersions2);
        NoteDataStorageTest.assertEquals((int)2, (int)pageVersions2.size());
        NoteDataStorageTest.assertEquals((String)"1", (String)Long.toString(((PageHistory)pageVersions2.get(0)).getVersionNumber()));
        NoteDataStorageTest.assertEquals((String)"2", (String)Long.toString(((PageHistory)pageVersions2.get(1)).getVersionNumber()));
    }

    @Test
    public void testRestorePageVersions() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("page1");
        page.setTitle("Page 1");
        page.setContent("Content Page Version 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        this.storage.addPageVersion(createdPage, identity.getId());
        createdPage.setContent("Content Page Version 2");
        this.storage.updatePage(createdPage);
        this.storage.addPageVersion(createdPage, identity.getId());
        Page pageBeforeRestore = this.storage.getPageById(createdPage.getId());
        this.storage.restoreVersionOfPage("1", createdPage);
        Page pageAfterRestore = this.storage.getPageById(createdPage.getId());
        NoteDataStorageTest.assertNotNull((Object)pageBeforeRestore);
        NoteDataStorageTest.assertEquals((String)"Content Page Version 2", (String)pageBeforeRestore.getContent());
        NoteDataStorageTest.assertNotNull((Object)pageAfterRestore);
        NoteDataStorageTest.assertEquals((String)"Content Page Version 1", (String)pageAfterRestore.getContent());
    }

    @Test
    public void testPageNames() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setName("page1");
        page.setTitle("Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        this.storage.renamePage(wiki.getType(), wiki.getOwner(), createdPage.getName(), "page2", "Page 1");
        this.storage.renamePage(wiki.getType(), wiki.getOwner(), "page2", "page3", "Page 1");
        List previousNames = this.storage.getPreviousNamesOfPage(createdPage);
        NoteDataStorageTest.assertNotNull((Object)previousNames);
        NoteDataStorageTest.assertEquals((int)2, (int)previousNames.size());
        NoteDataStorageTest.assertTrue((boolean)previousNames.contains("page1"));
        NoteDataStorageTest.assertTrue((boolean)previousNames.contains("page2"));
    }

    @Test
    public void testPageMoves() throws WikiException {
        Wiki wiki1 = new Wiki();
        wiki1.setType(WIKI_TYPE_PORTAL);
        wiki1.setOwner(WIKI_OWNER);
        wiki1 = this.storage.createWiki(wiki1);
        Wiki wiki2 = new Wiki();
        wiki2.setType(WIKI_TYPE_PORTAL);
        wiki2.setOwner("wiki2");
        wiki2 = this.storage.createWiki(wiki2);
        Page page1 = new Page();
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page createdPage1 = this.storage.createPage(wiki1, wiki1.getWikiHome(), page1);
        this.storage.renamePage(wiki1.getType(), wiki1.getOwner(), createdPage1.getName(), "page2", "Page 1");
        this.storage.movePage(new WikiPageParams(wiki1.getType(), wiki1.getOwner(), "page2"), new WikiPageParams(wiki2.getType(), wiki2.getOwner(), wiki2.getWikiHome().getName()));
        Page relatedPage1 = this.storage.getRelatedPage(wiki1.getType(), wiki1.getOwner(), "page1");
        Page relatedPage2 = this.storage.getRelatedPage(wiki1.getType(), wiki1.getOwner(), "page2");
        Page relatedPage3 = this.storage.getRelatedPage(wiki1.getType(), wiki1.getOwner(), "page3");
        NoteDataStorageTest.assertNotNull((Object)relatedPage1);
        NoteDataStorageTest.assertEquals((String)WIKI_TYPE_PORTAL, (String)relatedPage1.getWikiType());
        NoteDataStorageTest.assertEquals((String)"wiki2", (String)relatedPage1.getWikiOwner());
        NoteDataStorageTest.assertEquals((String)"page2", (String)relatedPage1.getName());
        NoteDataStorageTest.assertNotNull((Object)relatedPage2);
        NoteDataStorageTest.assertEquals((String)WIKI_TYPE_PORTAL, (String)relatedPage2.getWikiType());
        NoteDataStorageTest.assertEquals((String)"wiki2", (String)relatedPage2.getWikiOwner());
        NoteDataStorageTest.assertEquals((String)"page2", (String)relatedPage2.getName());
        NoteDataStorageTest.assertNull((Object)relatedPage3);
    }

    @Test
    public void testGetWatchers() throws WikiException {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page1 = new Page();
        page1.setWikiId(wiki.getId());
        page1.setWikiType(wiki.getType());
        page1.setWikiOwner(wiki.getOwner());
        page1.setName("page1");
        page1.setTitle("Page 1");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page1);
        List initialWatchers = this.storage.getWatchersOfPage(createdPage);
        this.storage.addWatcherToPage("user1", page1);
        List step1Watchers = this.storage.getWatchersOfPage(createdPage);
        this.storage.addWatcherToPage("user2", page1);
        List step2Watchers = this.storage.getWatchersOfPage(createdPage);
        this.storage.deleteWatcherOfPage("user1", page1);
        List step3Watchers = this.storage.getWatchersOfPage(createdPage);
        NoteDataStorageTest.assertNotNull((Object)initialWatchers);
        NoteDataStorageTest.assertEquals((int)0, (int)initialWatchers.size());
        NoteDataStorageTest.assertNotNull((Object)step1Watchers);
        NoteDataStorageTest.assertEquals((int)1, (int)step1Watchers.size());
        NoteDataStorageTest.assertTrue((boolean)step1Watchers.contains("user1"));
        NoteDataStorageTest.assertNotNull((Object)step2Watchers);
        NoteDataStorageTest.assertEquals((int)2, (int)step2Watchers.size());
        NoteDataStorageTest.assertTrue((boolean)step2Watchers.contains("user1"));
        NoteDataStorageTest.assertTrue((boolean)step2Watchers.contains("user2"));
        NoteDataStorageTest.assertEquals((int)1, (int)step3Watchers.size());
        NoteDataStorageTest.assertTrue((boolean)step3Watchers.contains("user2"));
    }

    public void testDeleteOrphanDraftPagesByParentPage() throws Exception {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner("root");
        wiki = this.storage.createWiki(wiki);
        PageEntity homePage = (PageEntity)this.pageDAO.find((Serializable)Long.valueOf(wiki.getWikiHome().getId()));
        DraftPageEntity draft = new DraftPageEntity();
        draft.setParentPage(homePage);
        draft.setName("orphanDraft");
        draft.setTargetPage(null);
        draft.setCreatedDate(new Date());
        draft.setUpdatedDate(new Date());
        draft = (DraftPageEntity)this.draftPageDAO.create((Object)draft);
        NoteDataStorageTest.assertNotNull((Object)draft);
        this.storage.deleteOrphanDraftPagesByParentPage(Long.parseLong(wiki.getWikiHome().getId()));
        this.restartTransaction();
        NoteDataStorageTest.assertNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(draft.getId())));
    }

    public void testGetVersionById() throws Exception {
        Wiki wiki = new Wiki();
        wiki.setType(WIKI_TYPE_PORTAL);
        wiki.setOwner(WIKI_OWNER);
        wiki = this.storage.createWiki(wiki);
        Page page = new Page();
        page.setWikiId(wiki.getId());
        page.setWikiType(wiki.getType());
        page.setWikiOwner(wiki.getOwner());
        page.setName("testGetVersionById");
        page.setTitle("testGetVersionById");
        page.setContent("content");
        Page createdPage = this.storage.createPage(wiki, wiki.getWikiHome(), page);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        PageVersion pageVersion = this.storage.addPageVersion(createdPage, identity.getId());
        NoteDataStorageTest.assertNotNull((Object)this.storage.getPageVersionById(Long.parseLong(pageVersion.getId())));
    }

    protected void startSessionAs(String user, Collection<MembershipEntry> memberships) {
        Identity identity = new Identity(user, memberships);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }
}

