/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.wiki.jpa.dao.WikiBaseDAO;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;

public class PageVersionDAO
extends WikiBaseDAO<PageVersionEntity, Long> {
    private static final String PAGE_ID_PARAM = "pageId";

    public Long getLastversionNumberOfPage(Long pageId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPageVersion.getLastversionNumberOfPage", Long.class).setParameter(PAGE_ID_PARAM, (Object)pageId);
        try {
            return (Long)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public PageVersionEntity getPageversionByPageIdAndVersion(Long pageId, Long versionNumber) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPageVersion.getPageversionByPageIdAndVersion", PageVersionEntity.class).setParameter(PAGE_ID_PARAM, (Object)pageId).setParameter("versionNumber", (Object)versionNumber);
        try {
            return (PageVersionEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<PageVersionEntity> findAllVersionsBySyntax(String syntax, int offset, int limit) {
        return this.getEntityManager().createNamedQuery("wikiPageVersion.getAllPagesVersionsBySyntax", PageVersionEntity.class).setParameter("syntax", (Object)syntax).setFirstResult(offset).setMaxResults(limit).getResultList();
    }

    public Long countPagesVersionsBySyntax(String syntax) {
        return (Long)this.getEntityManager().createNamedQuery("wikiPageVersion.countAllPagesVersionsBySyntax").setParameter("syntax", (Object)syntax).getSingleResult();
    }

    public List<PageVersionEntity> findPageVersionsByPageIdAndLang(Long pageId, String lang) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPageVersion.getPageVersionsByPageIdAndLang", PageVersionEntity.class).setParameter(PAGE_ID_PARAM, (Object)pageId).setParameter("lang", (Object)lang);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public PageVersionEntity findLatestVersionByPageIdAndLang(Long pageId, String lang) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPageVersion.getLatestPageVersionsByPageIdAndLang", PageVersionEntity.class).setParameter(PAGE_ID_PARAM, (Object)pageId).setParameter("lang", (Object)lang);
        query.setMaxResults(1);
        try {
            return (PageVersionEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> findPageAvailableTranslationLanguages(Long pageId) {
        return this.getEntityManager().createNamedQuery("wikiPageVersion.getPageAvailableTranslationLanguages", String.class).setParameter(PAGE_ID_PARAM, (Object)pageId).getResultList();
    }

    public List<PageVersionEntity> findVersionsByPage(Long pageId) {
        return this.getEntityManager().createNamedQuery("wikiPageVersion.findVersionsByPage", PageVersionEntity.class).setParameter(PAGE_ID_PARAM, (Object)pageId).getResultList();
    }

    public void deletePageVersions(long pageId) {
        List<PageVersionEntity> versions = this.findVersionsByPage(pageId);
        if (CollectionUtils.isNotEmpty(versions)) {
            versions.forEach(arg_0 -> ((PageVersionDAO)this).delete(arg_0));
        }
    }
}

