/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.rest;

import io.meeds.notes.model.NoteFeaturedImage;
import io.meeds.notes.model.NotePageProperties;
import io.meeds.notes.rest.model.DraftPageEntity;
import io.meeds.notes.rest.model.PageEntity;
import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.utils.HtmlUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.comparators.NaturalComparator;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.portal.application.localization.LocalizationFilter;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.NotesExportService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.impl.BeanToJsons;
import org.exoplatform.wiki.service.search.NoteSearchResult;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.tree.JsonNodeData;
import org.exoplatform.wiki.tree.PageTreeNode;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.WikiTreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.exoplatform.wiki.utils.Utils;
import org.gatein.api.EntityNotFoundException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/notes")
@Tag(name="/notes", description="Managing notes")
@RolesAllowed(value={"users"})
public class NotesRestService
implements ResourceContainer {
    private static final String NOTE_NAME_EXISTS = "Note name already exists";
    private static final Log LOG = ExoLogger.getLogger(NotesRestService.class);
    private final NoteService noteService;
    private final WikiService noteBookService;
    private final NotesExportService notesExportService;
    private final UploadService uploadService;
    private final IdentityManager identityManager;
    private final ResourceBundleService resourceBundleService;
    private final CacheControl cc;
    private static final int CACHE_DURATION_SECONDS = 31536000;
    private static final long CACHE_DURATION_MILLISECONDS = 31536000000L;
    private static final CacheControl ILLUSTRATION_CACHE_CONTROL = new CacheControl();
    private static final String DRAFTS_NOTE_TYPE = "drafts";

    public NotesRestService(NoteService noteService, WikiService noteBookService, UploadService uploadService, IdentityManager identityManager, ResourceBundleService resourceBundleService, NotesExportService notesExportService) {
        this.noteService = noteService;
        this.noteBookService = noteBookService;
        this.notesExportService = notesExportService;
        this.uploadService = uploadService;
        this.identityManager = identityManager;
        this.resourceBundleService = resourceBundleService;
        this.cc = new CacheControl();
        this.cc.setNoCache(true);
        this.cc.setNoStore(true);
    }

    @GET
    @Path(value="/note/{noteBookType}/{noteBookOwner:.+}/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get note by notes params", method="GET", description="This get the not if the authenticated user has permissions to view the objects linked to this note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getNote(@Parameter(description="NoteBook Type", required=true) @PathParam(value="noteBookType") String noteBookType, @Parameter(description="NoteBook Owner", required=true) @PathParam(value="noteBookOwner") String noteBookOwner, @Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="source", required=true) @QueryParam(value="source") String source, @Parameter(description="note content language") @QueryParam(value="lang") String lang) {
        try {
            Page note;
            EnvironmentContext env = EnvironmentContext.getCurrent();
            HttpServletRequest request = (HttpServletRequest)env.get(HttpServletRequest.class);
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (noteBookType.toUpperCase().equals(WikiType.GROUP.name())) {
                noteBookOwner = this.formatWikiOwnerToGroupId(noteBookOwner);
            }
            Wiki noteBook = null;
            noteBook = this.noteBookService.getWikiByTypeAndOwner(noteBookType, noteBookOwner);
            if (noteBook == null) {
                noteBook = this.noteBookService.createWiki(noteBookType, noteBookOwner);
            }
            if (noteId.equals("homeNote") || noteId.equals("Home")) {
                noteId = noteBook.getWikiHome().getId();
                note = this.noteService.getNoteById(noteId, identity, source);
            } else {
                note = this.noteService.getNoteOfNoteBookByName(noteBookType, noteBookOwner, noteId, identity, source);
            }
            if (note == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isNotBlank((CharSequence)lang)) {
                note = this.noteService.getNoteByIdAndLang(Long.valueOf(note.getId()), identity, source, lang);
            } else {
                PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(note.getId()), null);
                note.setLatestVersionId(pageVersion == null ? null : pageVersion.getId());
            }
            String content = note.getContent();
            if (content.contains("class=\"noteLink\" href=\"//-")) {
                while (content.contains("class=\"noteLink\" href=\"//-")) {
                    String linkedParams = content.split("class=\"noteLink\" href=\"//-")[1].split("-//\"")[0];
                    String NoteName = linkedParams.split("-////-")[2];
                    Page linkedNote = null;
                    linkedNote = this.noteService.getNoteOfNoteBookByName(note.getWikiType(), note.getWikiOwner(), NoteName);
                    if (linkedNote == null || !(content = content.replaceAll("\"noteLink\" href=\"//-" + linkedParams + "-//", "\"noteLink\" href=\"" + linkedNote.getId())).equals(note.getContent())) continue;
                    break;
                }
                if (!content.equals(note.getContent())) {
                    note.setContent(content);
                    this.noteService.updateNote(note);
                }
            }
            content = this.sanitizeAndSubstituteMentions(note.getContent(), lang);
            note.setContent(content);
            note.setBreadcrumb(this.noteService.getBreadCrumb(noteBookType, noteBookOwner, note.getName(), request.getLocale().getLanguage(), identity, false));
            return Response.ok((Object)note).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have view permissions on the note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error("Can't get note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/note/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get note by id", method="GET", description="This get the note if the authenticated user has permissions to view the objects linked to this note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getNoteById(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="noteBookType") @QueryParam(value="noteBookType") String noteBookType, @Parameter(description="noteBookOwner") @QueryParam(value="noteBookOwner") String noteBookOwner, @Parameter(description="withChildren") @QueryParam(value="withChildren") boolean withChildren, @Parameter(description="source") @QueryParam(value="source") String source, @Parameter(description="note content language") @QueryParam(value="lang") String lang, @QueryParam(value="includeDeleted") @DefaultValue(value="false") boolean includeDeleted) {
        try {
            EnvironmentContext env = EnvironmentContext.getCurrent();
            HttpServletRequest request = (HttpServletRequest)env.get(HttpServletRequest.class);
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteByIdAndLang(Long.valueOf(noteId), identity, source, lang);
            if (note == null || note.isDeleted() && !includeDeleted) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isNotEmpty((CharSequence)noteBookType) && !note.getWikiType().equals(noteBookType)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (StringUtils.isNotEmpty((CharSequence)noteBookOwner) && !note.getWikiOwner().equals(noteBookOwner)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (BooleanUtils.isTrue((Boolean)withChildren)) {
                note.setChildren(this.noteService.getChildrenNoteOf(note, false, withChildren));
            }
            if (note.getContent().contains("wiki-children-pages ck-widget")) {
                note = this.updateChildrenContainer(note);
            }
            note.setContent(this.sanitizeAndSubstituteMentions(note.getContent(), lang));
            note.setBreadcrumb(this.noteService.getBreadCrumb(note.getWikiType(), note.getWikiOwner(), note.getName(), request.getLocale().getLanguage(), identity, false));
            return Response.ok((Object)note).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have view permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error("Can't get note {}", new Object[]{noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/note/translation/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get available translation languages by page id", method="GET", description="This get gets the available translation languages by page id.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Server internal error")})
    public Response getPageAvailableTranslationLanguages(@Parameter(description="Note id", required=true) @PathParam(value="noteId") Long noteId, @QueryParam(value="withDrafts") Boolean withDrafts) {
        if (noteId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document title is mandatory").build();
        }
        try {
            List<String> languages = this.noteService.getPageAvailableTranslationLanguages(noteId, Boolean.TRUE.equals(withDrafts));
            return Response.ok(languages).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            LOG.error("Error while getting available translation languages of the page with id : {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="/note/translation/{noteId}/{lang}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete translation by page id and language", method="GET", description="This deletes translation by page id and language")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Server internal error")})
    public Response deleteTranslations(@Parameter(description="Note id", required=true) @PathParam(value="noteId") Long noteId, @PathParam(value="lang") String lang) {
        if (noteId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document title is mandatory").build();
        }
        try {
            this.noteService.deleteVersionsByNoteIdAndLang(noteId, lang, true);
            return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            LOG.error("Error while deleting translations of language : {} for the page with id : {}", new Object[]{lang, noteId, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/draftNote/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get draft note by id", method="GET", description="This returns the draft note if the authenticated user is the author of the draft.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getDraftNoteById(@Parameter(description="Note id", required=true) @PathParam(value="noteId") Long noteId, @Parameter(description="draft content language") @QueryParam(value="lang") String lang) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        String currentUserId = identity.getUserId();
        try {
            EnvironmentContext env = EnvironmentContext.getCurrent();
            HttpServletRequest request = (HttpServletRequest)env.get(HttpServletRequest.class);
            DraftPage draftNote = this.noteService.getDraftNoteById(String.valueOf(noteId), currentUserId);
            if (draftNote == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Page parentPage = this.noteService.getNoteById(draftNote.getParentPageId(), identity);
            if (parentPage == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            draftNote.setContent(this.sanitizeAndSubstituteMentions(draftNote.getContent(), lang));
            draftNote.setBreadcrumb(this.noteService.getBreadCrumb(parentPage.getWikiType(), parentPage.getWikiOwner(), draftNote.getId(), request.getLocale().getLanguage(), identity, true));
            return Response.ok((Object)draftNote).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User '{}' is not autorized to get draft note {}", new Object[]{currentUserId, noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error("Can't get draft note {}", new Object[]{noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/latestDraftNote/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get latest draft note of page", method="GET", description="This returns the latest draft of the note if the authenticated user is the author of the draft.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getLatestDraftOfPage(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="draft content language") @QueryParam(value="lang") String lang) {
        try {
            Page targetPage = this.noteService.getNoteById(noteId);
            if (targetPage == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            DraftPage draftNote = this.noteService.getLatestDraftPageByTargetPageAndLang(Long.valueOf(targetPage.getId()), lang);
            if (draftNote != null) {
                draftNote.setContent(this.sanitizeAndSubstituteMentions(draftNote.getContent(), lang));
            }
            return Response.ok((Object)(draftNote != null ? draftNote : org.json.JSONObject.NULL)).build();
        }
        catch (Exception e) {
            LOG.error("Can't get draft note {}", new Object[]{noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/versions/{noteId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get versions of note by id", method="GET", description="This get the versions of a note if the authenticated user has permissions to view the objects linked to this note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getNoteVersions(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="versions content language") @QueryParam(value="lang") String lang) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity);
            if (note == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            List<PageHistory> pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, identity.getUserId(), lang);
            pageHistories.forEach(pageHistory -> pageHistory.setContent(this.sanitizeAndSubstituteMentions(pageHistory.getContent(), lang)));
            return Response.ok(pageHistories).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have view permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error("Can't get versions list of note {}", new Object[]{noteId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/note")
    @RolesAllowed(value={"users"})
    @Operation(summary="Add a new note", method="POST", description="This adds a new note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response createNote(@Parameter(description="note object to be created", required=true) PageEntity note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String noteBookType = note.getWikiType();
        String noteBookOwner = note.getWikiOwner();
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (StringUtils.isNotEmpty((CharSequence)note.getParentPageId())) {
                Page note_ = this.noteService.getNoteById(note.getParentPageId(), identity);
                if (note_ != null) {
                    noteBookType = note_.getWikiType();
                    noteBookOwner = note_.getWikiOwner();
                    note.setParentPageName(note_.getName());
                } else {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            if (StringUtils.isEmpty((CharSequence)noteBookType) || StringUtils.isEmpty((CharSequence)noteBookOwner)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (this.noteService.isExisting(noteBookType, noteBookOwner, TitleResolver.getId(note.getTitle(), false))) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)NOTE_NAME_EXISTS).build();
            }
            Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(noteBookType, noteBookOwner);
            if (noteBook == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String syntaxId = this.noteBookService.getDefaultWikiSyntaxId();
            String currentUser = identity.getUserId();
            note.setAuthor(currentUser);
            note.setOwner(currentUser);
            note.setSyntax(syntaxId);
            note.setName(note.getTitle());
            note.setUrl("");
            Page createdNote = this.noteService.createNote(noteBook, note.getParentPageName(), io.meeds.notes.rest.utils.EntityBuilder.toPage(note), identity);
            createdNote.setContent(this.sanitizeAndSubstituteMentions(createdNote.getContent(), note.getLang()));
            return Response.ok((Object)createdNote, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have view permissions on the note {}", new Object[]{note.getName(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to perform save noteBook note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, note.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @POST
    @Path(value="saveDraft")
    @RolesAllowed(value={"users"})
    @Operation(summary="Add or update a new note draft page", method="POST", description="This adds a new note draft page or updates an existing one.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response saveDraft(@RequestBody(description="Note draft page object to be created", required=true) DraftPageEntity draftNoteToSave) {
        if (draftNoteToSave == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String noteBookType = draftNoteToSave.getWikiType();
        String noteBookOwner = draftNoteToSave.getWikiOwner();
        Page parentNote = null;
        Page targetNote = null;
        DraftPage savedDraftPage = null;
        try {
            DraftPage draftPage;
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{draftNoteToSave.getParentPageId()})) {
                parentNote = this.noteService.getNoteById(draftNoteToSave.getParentPageId(), identity);
            }
            if (parentNote != null) {
                noteBookType = parentNote.getWikiType();
                noteBookOwner = parentNote.getWikiOwner();
                draftNoteToSave.setParentPageName(parentNote.getName());
            }
            if (StringUtils.isEmpty((CharSequence)noteBookType) || StringUtils.isEmpty((CharSequence)noteBookOwner)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(noteBookType, noteBookOwner);
            if (noteBook == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{draftNoteToSave.getTargetPageId()})) {
                targetNote = this.noteService.getNoteById(draftNoteToSave.getTargetPageId());
            }
            String syntaxId = this.noteBookService.getDefaultWikiSyntaxId();
            String currentUser = identity.getUserId();
            draftNoteToSave.setAuthor(currentUser);
            draftNoteToSave.setSyntax(syntaxId);
            if (targetNote != null && (draftPage = this.noteService.getLatestDraftPageByTargetPageAndLang(Long.valueOf(draftNoteToSave.getTargetPageId()), draftNoteToSave.getLang())) != null) {
                draftNoteToSave.setId(draftPage.getId());
            }
            savedDraftPage = StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{draftNoteToSave.getId()}) ? (targetNote != null ? this.noteService.updateDraftForExistPage(io.meeds.notes.rest.utils.EntityBuilder.toDraftPage(draftNoteToSave), targetNote, null, System.currentTimeMillis(), currentUser) : this.noteService.updateDraftForNewPage(io.meeds.notes.rest.utils.EntityBuilder.toDraftPage(draftNoteToSave), System.currentTimeMillis(), RestUtils.getCurrentUserIdentityId())) : (targetNote != null ? this.noteService.createDraftForExistPage(io.meeds.notes.rest.utils.EntityBuilder.toDraftPage(draftNoteToSave), targetNote, null, System.currentTimeMillis(), currentUser) : this.noteService.createDraftForNewPage(io.meeds.notes.rest.utils.EntityBuilder.toDraftPage(draftNoteToSave), System.currentTimeMillis(), RestUtils.getCurrentUserIdentityId()));
            savedDraftPage.setContent(this.sanitizeAndSubstituteMentions(savedDraftPage.getContent(), draftNoteToSave.getLang()));
            return Response.ok((Object)savedDraftPage, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to perform save noteBook draft note {}:{}", new Object[]{noteBookType, noteBookOwner, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PUT
    @Path(value="/note/{noteBookType}/{noteBookOwner:.+}/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific note by note's params", method="PUT", description="This updates the note if the authenticated user has UPDATE permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response updateNote(@Parameter(description="NoteBook Type", required=true) @PathParam(value="noteBookType") String noteBookType, @Parameter(description="NoteBook Owner", required=true) @PathParam(value="noteBookOwner") String noteBookOwner, @Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @RequestBody(description="note object to be updated", required=true) PageEntity note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            if (noteBookType.toUpperCase().equals(WikiType.GROUP.name())) {
                noteBookOwner = this.formatWikiOwnerToGroupId(noteBookOwner);
            }
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note_ = this.noteService.getNoteOfNoteBookByName(noteBookType, noteBookOwner, noteId);
            if (note_ == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!note_.isCanManage()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            note_.setToBePublished(note.isToBePublished());
            if (!note_.getTitle().equals(note.getTitle()) && this.noteService.isExisting(noteBookType, noteBookOwner, TitleResolver.getId(note.getTitle(), false))) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)NOTE_NAME_EXISTS).build();
            }
            if (!note_.getTitle().equals(note.getTitle()) && !note_.getContent().equals(note.getContent())) {
                String newNoteName = TitleResolver.getId(note.getTitle(), false);
                note_.setTitle(note.getTitle());
                note_.setContent(note.getContent());
                if (!"Home".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(noteBookType, noteBookOwner, note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId(), true);
            } else if (!note_.getTitle().equals(note.getTitle())) {
                String newNoteName = TitleResolver.getId(note.getTitle(), false);
                if (!"Home".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                    this.noteService.renameNote(noteBookType, noteBookOwner, note_.getName(), newNoteName, note.getTitle());
                    note_.setName(newNoteName);
                }
                note_.setTitle(note.getTitle());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_TITLE, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId(), true);
            } else if (!note_.getContent().equals(note.getContent())) {
                note_.setContent(note.getContent());
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId(), true);
            }
            note_.setContent(this.sanitizeAndSubstituteMentions(note_.getContent(), note.getLang()));
            return Response.ok((Object)note_, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have view permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            LOG.error("Failed to perform update noteBook note {}:{}:{}", new Object[]{note.getWikiType(), note.getWikiOwner(), note.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PUT
    @Path(value="/note/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific note by id", method="PUT", description="This updates the note if the authenticated user has UPDATE permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response updateNoteById(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @RequestBody(description="note object to be updated", required=true) PageEntity note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note_ = this.noteService.getNoteById(noteId, identity);
            if (note_ == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!note_.isCanManage()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            if (!note_.getTitle().equals(note.getTitle()) && this.noteService.isExisting(note.getWikiType(), note.getWikiOwner(), TitleResolver.getId(note.getTitle(), false))) {
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)NOTE_NAME_EXISTS).build();
            }
            note_.setToBePublished(note.isToBePublished());
            NotePageProperties notePageProperties = io.meeds.notes.rest.utils.EntityBuilder.toNotePageProperties(note.getProperties());
            NoteFeaturedImage featuredImage = null;
            if (notePageProperties != null) {
                featuredImage = notePageProperties.getFeaturedImage();
            }
            String newNoteName = note_.getName();
            if (!note_.getTitle().equals(note.getTitle()) && !note_.getContent().equals(note.getContent())) {
                if (StringUtils.isBlank((CharSequence)note.getLang())) {
                    newNoteName = TitleResolver.getId(note.getTitle(), false);
                    note_.setTitle(note.getTitle());
                    note_.setContent(note.getContent());
                    note_.setProperties(notePageProperties);
                    if (!"Home".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                        this.noteService.renameNote(note_.getWikiType(), note_.getWikiOwner(), note_.getName(), newNoteName, note.getTitle());
                        note_.setName(newNoteName);
                    }
                    note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, identity);
                } else {
                    note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, identity);
                    note_.setLang(note.getLang());
                    note_.setTitle(note.getTitle());
                    note_.setContent(note.getContent());
                    note_.setProperties(notePageProperties);
                }
                this.noteService.createVersionOfNote(note_, identity.getUserId(), true);
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams, note.getLang());
                }
            } else if (!note_.getTitle().equals(note.getTitle())) {
                if (StringUtils.isBlank((CharSequence)note.getLang())) {
                    newNoteName = TitleResolver.getId(note.getTitle(), false);
                    if (!"Home".equals(note.getName()) && !note.getName().equals(newNoteName)) {
                        this.noteService.renameNote(note_.getWikiType(), note_.getWikiOwner(), note_.getName(), newNoteName, note.getTitle());
                        note_.setName(newNoteName);
                    }
                    note_.setTitle(note.getTitle());
                    note_.setProperties(notePageProperties);
                    note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_TITLE, identity);
                } else {
                    note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_TITLE, identity);
                    note_.setLang(note.getLang());
                    note_.setTitle(note.getTitle());
                    note_.setProperties(notePageProperties);
                }
                this.noteService.createVersionOfNote(note_, identity.getUserId());
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams, note.getLang());
                }
            } else if (!note_.getContent().equals(note.getContent())) {
                if (StringUtils.isBlank((CharSequence)note.getLang())) {
                    note_.setContent(note.getContent());
                    note_.setProperties(notePageProperties);
                    note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT, identity);
                } else {
                    note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT, identity);
                    note_.setLang(note.getLang());
                    note_.setContent(note.getContent());
                    note_.setProperties(notePageProperties);
                }
                this.noteService.createVersionOfNote(note_, identity.getUserId(), true);
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams, note.getLang());
                }
            } else if (featuredImage != null && (featuredImage.isToDelete() || featuredImage.getUploadId() != null) || !Objects.equals(note_.getProperties(), notePageProperties)) {
                if (StringUtils.isBlank((CharSequence)note.getLang())) {
                    note_.setProperties(notePageProperties);
                    note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_PROPERTIES, identity);
                } else {
                    note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_PROPERTIES, identity);
                    note_.setLang(note.getLang());
                    note_.setProperties(notePageProperties);
                }
                this.noteService.createVersionOfNote(note_, identity.getUserId(), true);
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams, note.getLang());
                }
            } else if (note_.isToBePublished()) {
                note_ = this.noteService.updateNote(note_, PageUpdateType.PUBLISH, identity);
            } else if (note.isExtensionDataUpdated()) {
                note_ = this.noteService.updateNote(note_, PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE, identity);
                this.noteService.createVersionOfNote(note_, identity.getUserId(), true);
                if (!"__anonim".equals(identity.getUserId())) {
                    WikiPageParams noteParams = new WikiPageParams(note_.getWikiType(), note_.getWikiOwner(), newNoteName);
                    this.noteService.removeDraftOfNote(noteParams, note.getLang());
                }
            } else {
                note_.setUrl(Utils.getPageUrl(io.meeds.notes.rest.utils.EntityBuilder.toPage(note)));
            }
            note_.setContent(this.sanitizeAndSubstituteMentions(note_.getContent(), note.getLang()));
            return Response.ok((Object)note_, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have edit permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            LOG.error("Failed to perform update noteBook note {}:{}:{}", new Object[]{note.getWikiType(), note.getWikiOwner(), note.getId(), ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PUT
    @Path(value="/restore/{noteVersion}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Restore a specific note version by version id", method="PUT", description="This restore the note if the authenticated user has UPDATE permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response RestoreNoteVersion(@Parameter(description="Version Number", required=true) @PathParam(value="noteVersion") String noteVersion, @RequestBody(description="note object to be updated", required=true) Page note) {
        if (note == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            String currentUser = identity.getUserId();
            Page note_ = this.noteService.getNoteById(note.getId(), identity);
            if (note_ == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!note_.isCanManage()) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.noteService.restoreVersionOfNote(noteVersion, note, currentUser);
            note_.setContent(this.sanitizeAndSubstituteMentions(note_.getContent(), note.getLang()));
            return Response.ok((Object)note_, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have permissions to restore the note {} version", new Object[]{note.getId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            LOG.error("Failed to perform restore note version {}", new Object[]{noteVersion, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @DELETE
    @Path(value="/note/{noteBookType}/{noteBookOwner:.+}/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete note by note's params", method="PUT", description="This delets the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response deleteNote(@Parameter(description="NoteBook Type", required=true) @PathParam(value="noteBookType") String noteBookType, @Parameter(description="NoteBook Owner", required=true) @PathParam(value="noteBookOwner") String noteBookOwner, @Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            Identity identity;
            Page note_;
            if (noteBookType.toUpperCase().equals(WikiType.GROUP.name())) {
                noteBookOwner = this.formatWikiOwnerToGroupId(noteBookOwner);
            }
            if ((note_ = this.noteService.getNoteOfNoteBookByName(noteBookType, noteBookOwner, noteId, identity = ConversationState.getCurrent().getIdentity())) == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.noteService.deleteNote(noteBookType, noteBookOwner, noteId, identity);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have delete permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to perform Delete of noteBook note {}:{}:{}", new Object[]{noteBookType, noteBookOwner, noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @DELETE
    @Path(value="/note/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete note by note's params", method="PUT", description="This deletes the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response deleteNoteById(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity);
            if (note == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            String noteName = note.getName();
            if (!"__anonim".equals(identity.getUserId())) {
                WikiPageParams noteParams = new WikiPageParams(note.getWikiType(), note.getWikiOwner(), noteName);
                this.noteService.removeDraftOfNote(noteParams);
            }
            this.noteService.deleteNote(note.getWikiType(), note.getWikiOwner(), noteName, identity);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have delete permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to perform Delete of noteBook note {}", new Object[]{noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @DELETE
    @Path(value="/draftNote/{noteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete note by note's params", method="PUT", description="This deletes the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response deleteDraftNote(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId) {
        try {
            String currentUserId = ConversationState.getCurrent().getIdentity().getUserId();
            DraftPage draftNote = this.noteService.getDraftNoteById(noteId, currentUserId);
            if (draftNote == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.noteService.removeDraftById(draftNote.getId());
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to perform Delete of noteBook note {}", new Object[]{noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @PATCH
    @Path(value="/note/move/{noteId}/{destinationNoteId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Move note under the destination one", method="PUT", description="This moves the note if the authenticated user has EDIT permissions.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response moveNote(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="Destination Note id", required=true) @PathParam(value="destinationNoteId") String toNoteId) {
        try {
            WikiPageParams newLocationParams;
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteById(noteId, identity);
            if (note == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Page toNote = this.noteService.getNoteById(toNoteId);
            if (toNote == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            WikiPageParams currentLocationParams = new WikiPageParams(note.getWikiType(), note.getWikiOwner(), note.getName());
            boolean isMoved = this.noteService.moveNote(currentLocationParams, newLocationParams = new WikiPageParams(toNote.getWikiType(), toNote.getWikiOwner(), toNote.getName()), identity);
            if (isMoved) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have move permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to perform move of noteBook note {} under {}", new Object[]{noteId, toNoteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/note/export/{exportId}/{notes}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Export notes", method="GET", description="This export selected notes and provide a zip file.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response exportNote(@Parameter(description="List of notes ids", required=true) @PathParam(value="notes") String notesList, @Parameter(description="export ID", required=true) @PathParam(value="exportId") int exportId, @Parameter(description="exportAll") @QueryParam(value="exportAll") Boolean exportAll) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            String[] notes = notesList.split(",");
            this.notesExportService.startExportNotes(exportId, notes, exportAll, identity);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to export notes ", (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/note/export/zip/{exportId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Export notes", method="GET", description="This export selected notes and provide a zip file.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getExportedZip(@Parameter(description="List of notes ids", required=true) @PathParam(value="exportId") int exportId) {
        try {
            byte[] filesBytes = this.notesExportService.getExportedNotes(exportId);
            return Response.ok((Object)filesBytes).type("application/zip").header("Content-Disposition", (Object)("attachment; filename=\"notesExport_" + new Date().getTime() + ".zip\"")).build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to export notes ", (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/note/export/status/{exportId}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Export notes", method="GET", description="This export selected notes and provide a zip file.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getExportNoteStatus(@Parameter(description="export id", required=true) @PathParam(value="exportId") int exportId) {
        try {
            return Response.ok((Object)this.notesExportService.getStatus(exportId)).build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to export notes ", (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/note/export/cancel/{exportId}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Export notes", method="GET", description="This cancel export.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response cancelExportNote(@Parameter(description="export id", required=true) @PathParam(value="exportId") int exportId) {
        try {
            this.notesExportService.cancelExportNotes(exportId);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to export notes ", (Throwable)ex);
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @POST
    @Path(value="/note/import/{noteId}/{uploadId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Import notes from a zip file", method="POST", description="This import notes from defined zip file under given note.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response importNote(@Parameter(description="Note id", required=true) @PathParam(value="noteId") String noteId, @Parameter(description="Upload id", required=true) @PathParam(value="uploadId") String uploadId, @Parameter(description="Conflict", required=true) @QueryParam(value="conflict") String conflict) {
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page parent = this.noteService.getNoteById(noteId, identity);
            if (parent == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
            if (uploadResource != null) {
                this.noteService.importNotes(uploadResource.getStoreLocation(), parent, conflict, identity);
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have move permissions on the note {}", new Object[]{noteId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ex) {
            LOG.warn("Failed to import note {} ", new Object[]{noteId, ex});
            return Response.status((int)500).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="/tree/{treeType}/{noteType}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Get node's tree data", method="GET", description="Display the current tree of a noteBook based on is path")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getNoteTreeData(@Parameter(description="Tree of selected path children or all notes") @PathParam(value="treeType") String treeType, @Parameter(description="Tree of drafts or notes") @PathParam(value="noteType") String noteType, @Parameter(description="Note path", required=true) @QueryParam(value="path") String path) {
        try {
            boolean withDrafts = Objects.equals(noteType, DRAFTS_NOTE_TYPE);
            Identity identity = ConversationState.getCurrent().getIdentity();
            List<Object> responseData = new ArrayList();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("withDrafts", withDrafts);
            EnvironmentContext env = EnvironmentContext.getCurrent();
            HttpServletRequest request = (HttpServletRequest)env.get(HttpServletRequest.class);
            path = URLDecoder.decode(path, StandardCharsets.UTF_8);
            context.put("path", path);
            WikiPageParams noteParam = TreeUtils.getPageParamsFromPath(path);
            Page note = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), noteParam.getPageName(), identity);
            if (note == null) {
                LOG.warn("User [{}] can not get noteBook path [{}]. Home is used instead", new Object[]{ConversationState.getCurrent().getIdentity().getUserId(), path});
                note = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), "Home");
                if (note == null) {
                    ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.portlet.wiki.WikiPortlet", request.getLocale());
                    String errorMessage = "";
                    if (resourceBundle != null) {
                        errorMessage = resourceBundle.getString("UIWikiMovePageForm.msg.no-permission-at-wiki-destination");
                    }
                    return Response.serverError().entity((Object)("{ \"message\": \"" + errorMessage + "\"}")).cacheControl(this.cc).build();
                }
            }
            context.put("selectedPage", note);
            context.put("canEdit", null);
            context.put("excerpt", null);
            Deque<WikiPageParams> stk = Utils.getStackParams(note);
            context.put("stackParams", stk);
            JsonNodeData rootNodeData = null;
            ArrayList<JsonNodeData> treeNodeData = new ArrayList<JsonNodeData>();
            if (withDrafts) {
                context.put("depth", "1");
                rootNodeData = this.getJsonTree(noteParam, context, identity, request.getLocale()).getFirst();
                rootNodeData.setChildren(new ArrayList<JsonNodeData>());
                rootNodeData.setHasDraftDescendant(true);
                this.buildNoteDraftsTree(rootNodeData, treeNodeData, noteParam, path, context, identity, request.getLocale());
            } else if (treeType.equalsIgnoreCase(TreeNode.TREETYPE.ALL.toString())) {
                responseData = this.getJsonTree(noteParam, context, identity, request.getLocale());
                rootNodeData = (JsonNodeData)responseData.getFirst();
                this.buildNotesTree(rootNodeData, treeNodeData, context, identity, request.getLocale());
            } else if (treeType.equalsIgnoreCase(TreeNode.TREETYPE.CHILDREN.toString())) {
                context.put("depth", "1");
                responseData = this.getJsonDescendants(noteParam, context, identity, request.getLocale());
                treeNodeData.addAll(responseData);
            } else {
                rootNodeData = this.getJsonTree(noteParam, context, identity, request.getLocale()).getFirst();
                treeNodeData.addAll(rootNodeData.getChildren());
            }
            if (rootNodeData != null) {
                responseData = List.of(rootNodeData);
            }
            BeanToJsons<JsonNodeData> toJsons = new BeanToJsons<JsonNodeData>(responseData, treeNodeData);
            return Response.ok(toJsons, (String)"application/json").cacheControl(this.cc).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("User does not have view permissions on the note {}", new Object[]{path, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed for get tree data by rest service - Cause : " + e.getMessage()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).cacheControl(this.cc).build();
        }
    }

    @GET
    @Path(value="contextsearch/")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response searchData(@Context UriInfo uriInfo, @QueryParam(value="keyword") String keyword, @QueryParam(value="limit") int limit, @QueryParam(value="wikiType") String wikiType, @QueryParam(value="wikiOwner") String wikiOwner, @QueryParam(value="favorites") boolean favorites, @QueryParam(value="tags") List<String> tagNames, @Parameter(description="Space id used to search notes of one space", required=false) @QueryParam(value="spaceId") List<Long> spaceIds, @QueryParam(value="isNotesTreeFilter") boolean isNotesTreeFilter) throws Exception {
        limit = limit > 0 ? limit : RestUtils.getLimit((UriInfo)uriInfo);
        try {
            keyword = keyword.toLowerCase();
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            WikiSearchData data = new WikiSearchData(keyword, currentIdentity.getUserId());
            data.setLimit(limit);
            data.setNotesTreeFilter(isNotesTreeFilter);
            data.setFavorites(favorites);
            data.setTagNames(tagNames);
            data.setWikiOwner(wikiOwner);
            data.setWikiType(wikiType);
            if (CollectionUtils.isNotEmpty(spaceIds)) {
                data.setSpaceIds(spaceIds.stream().map(String::valueOf).toList());
            }
            List results = this.noteService.search(data).getAll();
            ArrayList<NoteSearchResult> noteSearchResults = new ArrayList<NoteSearchResult>();
            for (SearchResult searchResult : results) {
                Page page = null;
                try {
                    page = this.noteService.getNoteOfNoteBookByName(searchResult.getWikiType(), searchResult.getWikiOwner(), searchResult.getPageName(), searchResult.getLang(), currentIdentity);
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot get page of search result " + searchResult.getWikiType() + ":" + searchResult.getWikiOwner() + ":" + searchResult.getPageName()), (Throwable)e);
                }
                if (page == null) continue;
                page.setUrl((String)(searchResult.getUrl() != null && !searchResult.getUrl().isBlank() ? searchResult.getUrl() : page.getUrl() + "?translation=" + searchResult.getLang()));
                if (searchResult.getPoster() == null && !searchResult.getPageName().equals("Home")) continue;
                PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.parseLong(page.getId()), null);
                org.exoplatform.social.core.identity.model.Identity poster = searchResult.getPoster();
                if (pageVersion != null) {
                    poster = this.identityManager.getOrCreateIdentity("organization", pageVersion.getAuthor());
                }
                IdentityEntity posterIdentity = poster != null ? EntityBuilder.buildEntityIdentity((org.exoplatform.social.core.identity.model.Identity)poster, (String)uriInfo.getPath(), (String)"all") : null;
                IdentityEntity wikiOwnerIdentity = searchResult.getWikiOwnerIdentity() != null ? EntityBuilder.buildEntityIdentity((org.exoplatform.social.core.identity.model.Identity)searchResult.getWikiOwnerIdentity(), (String)uriInfo.getPath(), (String)"all") : null;
                NoteSearchResult noteSearchResult = new NoteSearchResult();
                noteSearchResult.setTitle(searchResult.getTitle());
                noteSearchResult.setId(page.getId());
                noteSearchResult.setPageName(page.getName());
                noteSearchResult.setPageName(page.getName());
                noteSearchResult.setActivityId(page.getActivityId());
                if (posterIdentity != null) {
                    noteSearchResult.setPoster(posterIdentity);
                }
                noteSearchResult.setWikiOwner(wikiOwnerIdentity);
                noteSearchResult.setExcerpt(HtmlUtils.transform((String)searchResult.getExcerpt(), (HtmlTransformerContext)new HtmlTransformerContext(currentIdentity, LocalizationFilter.getCurrentLocale(), true)));
                noteSearchResult.setUpdateDate(searchResult.getUpdatedDate().getTimeInMillis());
                noteSearchResult.setType(searchResult.getType());
                noteSearchResult.setUrl(page.getUrl());
                noteSearchResult.setLang(searchResult.getLang());
                noteSearchResult.setMetadatas(page.getMetadatas());
                noteSearchResult.setContent(pageVersion != null ? pageVersion.getContent() : page.getContent());
                String summary = pageVersion != null && pageVersion.getProperties() != null ? pageVersion.getProperties().getSummary() : (page.getProperties() != null ? page.getProperties().getSummary() : null);
                noteSearchResult.setSummary(summary);
                noteSearchResults.add(noteSearchResult);
            }
            return Response.ok(new BeanToJsons(noteSearchResults), (String)"application/json").cacheControl(this.cc).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when search notes", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="languages")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAvailableLanguages(@Context UriInfo uriInfos, @QueryParam(value="lang") String lang) {
        try {
            Optional<Locale> opLocal;
            Set locales = LocaleContextInfoUtils.getSupportedLocales();
            ArrayList localesList = new ArrayList(locales);
            JSONArray localesJSON = new JSONArray();
            Locale currentLocal = Locale.ENGLISH;
            if (!lang.isEmpty() && (opLocal = Arrays.stream(Locale.getAvailableLocales()).filter(local -> local.getLanguage().equals(lang)).findAny()).isPresent()) {
                currentLocal = opLocal.get();
            }
            for (Locale locale : localesList) {
                JSONObject object = new JSONObject();
                if (locale.toString().equals("ma")) continue;
                object.put((Object)"value", (Object)locale.toString());
                object.put((Object)"text", (Object)locale.getDisplayName(currentLocal));
                localesJSON.add((Object)object);
            }
            return Response.ok((Object)localesJSON, (String)"application/json").build();
        }
        catch (Exception e) {
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="/illustration/{noteId}")
    @Operation(summary="Gets a note featured image illustration by note Id", description="Gets a note featured image illustration by note Id", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getFeaturedImageIllustration(@Context Request request, @Parameter(description="target note id", required=true) @PathParam(value="noteId") Long noteId, @Parameter(description="target version language", required=true) @QueryParam(value="isDraft") boolean isDraft, @Parameter(description="target version language", required=true) @QueryParam(value="lang") String lang, @Parameter(description="Optional size parameter", required=true) @QueryParam(value="size") String size, @Parameter(description="Optional last modified parameter") @QueryParam(value="v") long lastModified) {
        if (noteId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"note id is mandatory").build();
        }
        try {
            NoteFeaturedImage noteFeaturedImage = this.noteService.getNoteFeaturedImageInfo(noteId, lang, isDraft, size, RestUtils.getCurrentUserIdentityId());
            if (noteFeaturedImage == null) {
                return Response.status((int)404).build();
            }
            Long lastUpdated = noteFeaturedImage.getLastUpdated();
            EntityTag eTag = new EntityTag(lastUpdated + noteId + lang + size, true);
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream stream = noteFeaturedImage.getFileInputStream();
                builder = Response.ok((Object)stream, (String)noteFeaturedImage.getMimeType());
                builder.tag(eTag);
                if (lastModified > 0L) {
                    builder.lastModified(new Date(lastUpdated));
                    builder.expires(new Date(System.currentTimeMillis() + 31536000000L));
                    builder.cacheControl(ILLUSTRATION_CACHE_CONTROL);
                }
            }
            return builder.build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting featured image illustration", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/note/view/{noteId}")
    @Operation(summary="mark a note as viewed", method="POST", description="This marks a note as viewed.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="User not authorized to get the note"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response markNoteAsViewed(@Parameter(description="News id") @PathParam(value="noteId") String noteId, @Parameter(description="News target lang") @QueryParam(value="lang") String lang) {
        if (noteId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"note id is mandatory").build();
        }
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            Page note = this.noteService.getNoteByIdAndLang(Long.parseLong(noteId), identity, null, lang);
            this.noteService.markNoteAsViewed(note, identity);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.debug((Object)"User is not authorized to view note", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while marking a note as read", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private List<JsonNodeData> getJsonTree(WikiPageParams params, Map<String, Object> context, Identity identity, Locale locale) throws Exception {
        Wiki noteBook = this.noteBookService.getWikiByTypeAndOwner(params.getType(), params.getOwner());
        WikiTreeNode noteBookNode = new WikiTreeNode(noteBook);
        noteBookNode.pushDescendants(context, ConversationState.getCurrent().getIdentity().getUserId());
        return TreeUtils.tranformToJson(noteBookNode, context, identity, locale);
    }

    private List<JsonNodeData> getJsonDescendants(WikiPageParams params, Map<String, Object> context, Identity identity, Locale locale) throws Exception {
        TreeNode treeNode = TreeUtils.getDescendants(params, context, ConversationState.getCurrent().getIdentity().getUserId());
        return TreeUtils.tranformToJson(treeNode, context, identity, locale);
    }

    private Page updateChildrenContainer(Page note) throws WikiException {
        String content = note.getContent();
        String oldChildrenContainer = "<div class=\"wiki-children-pages ck-widget\" contenteditable=\"false\"><exo-wiki-children-pages>&nbsp;</exo-wiki-children-pages></div>";
        String childrenContainer = "<div class=\"navigation-img-wrapper\" contenteditable=\"false\" id=\"note-children-container\">\n<figure class=\"image-navigation\" contenteditable=\"false\"><img alt=\"\" data-plugin-name=\"selectImage\" referrerpolicy=\"no-referrer\" role=\"presentation\" src=\"/notes/images/children.png\" /><img alt=\"remove treeview\" data-plugin-name=\"selectImage\" id=\"remove-treeview\" referrerpolicy=\"no-referrer\" src=\"/notes/images/trash.png\" />\n<figcaption class=\"note-navigation-label\">Navigation</figcaption>\n</figure>\n</div>\n\n<p>&nbsp;</p>\n";
        content = content.replace(oldChildrenContainer, childrenContainer);
        note.setContent(content);
        return this.noteService.updateNote(note);
    }

    private String formatWikiOwnerToGroupId(String wikiOwner) {
        if (wikiOwner == null || ((String)wikiOwner).length() == 0) {
            return null;
        }
        if (!((String)wikiOwner).startsWith("/")) {
            wikiOwner = "/" + (String)wikiOwner;
        }
        if (((String)wikiOwner).endsWith("/")) {
            wikiOwner = ((String)wikiOwner).substring(0, ((String)wikiOwner).length() - 1);
        }
        return wikiOwner;
    }

    private String sanitizeAndSubstituteMentions(String content, String lang) {
        try {
            Locale locale = lang == null ? null : LocaleUtils.toLocale((String)lang);
            content = HtmlUtils.transform((String)content, (HtmlTransformerContext)new HtmlTransformerContext(ConversationState.getCurrent().getIdentity(), LocaleUtils.toLocale((String)lang)));
            String sanitizedBody = HTMLSanitizer.sanitize((String)content);
            sanitizedBody = sanitizedBody.replace("&#64;", "@");
            return MentionUtils.substituteUsernames((String)CommonsUtils.getCurrentPortalOwner(), (String)sanitizedBody, (Locale)locale);
        }
        catch (Exception e) {
            return content;
        }
    }

    private void buildNotesTree(JsonNodeData rootNode, List<JsonNodeData> treeNodeData, Map<String, Object> context, Identity identity, Locale locale) throws Exception {
        for (JsonNodeData child : rootNode.getChildren()) {
            treeNodeData.add(child);
            if (child.isHasChild()) {
                String path = URLDecoder.decode(child.getPath(), StandardCharsets.UTF_8);
                context.put("path", path);
                WikiPageParams noteParam = TreeUtils.getPageParamsFromPath(path);
                try {
                    Page parentNote = this.noteService.getNoteOfNoteBookByName(noteParam.getType(), noteParam.getOwner(), noteParam.getPageName(), identity);
                    context.put("selectedPage", parentNote);
                }
                catch (EntityNotFoundException e) {
                    LOG.warn("Cannot find the note {}", new Object[]{noteParam.getPageName()});
                }
                List<JsonNodeData> children = this.getJsonDescendants(noteParam, context, identity, locale);
                child.setChildren(children);
                treeNodeData.addAll(children);
            }
            this.buildNotesTree(child, treeNodeData, context, identity, locale);
        }
    }

    private void buildNoteDraftsTree(JsonNodeData rootNode, List<JsonNodeData> treeNodeData, WikiPageParams params, String path, Map<String, Object> context, Identity identity, Locale locale) {
        List<DraftPage> draftPages = this.noteService.getDraftsOfWiki(params.getOwner(), params.getType(), params.getPageName());
        Map<String, List> draftsByParentPage = draftPages.stream().map(draftPage -> {
            try {
                PageTreeNode pageTreeNode = new PageTreeNode((Page)draftPage);
                Boolean canEdit = context != null && context.get("canEdit") != null && (Boolean)context.get("canEdit") != false;
                return TreeUtils.toJsonNodeData(pageTreeNode, path, draftPage, context, canEdit, true, identity, locale, this.noteService);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(JsonNodeData::getParentPageId, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted((x, y) -> new NaturalComparator().compare(x.getName(), y.getName())).collect(Collectors.toList()))));
        draftsByParentPage.forEach((parentPageId, drafts) -> {
            try {
                drafts = TreeUtils.cleanDraftChildren(drafts, locale);
                JsonNodeData parentJsonData = this.findParent((String)parentPageId, treeNodeData);
                if (parentJsonData == null) {
                    Page parent = this.noteService.getNoteById(String.valueOf(parentPageId));
                    PageTreeNode pageTreeNode = new PageTreeNode(parent);
                    Boolean canEdit = context != null && context.get("canEdit") != null && (Boolean)context.get("canEdit") != false;
                    parentJsonData = TreeUtils.toJsonNodeData(pageTreeNode, path, parent, context, canEdit, true, identity, locale, this.noteService);
                }
                if (!Objects.equals(parentJsonData.getNoteId(), rootNode.getNoteId())) {
                    parentJsonData.addChildren((List<JsonNodeData>)drafts);
                    treeNodeData.add(parentJsonData);
                    this.buildPageAscendants(rootNode, parentJsonData, treeNodeData, context, identity, locale, path);
                } else {
                    rootNode.addChildren((List<JsonNodeData>)drafts);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while building draft tree descendants", (Throwable)e);
            }
        });
    }

    private void buildPageAscendants(JsonNodeData rootNode, JsonNodeData parentJsonData, List<JsonNodeData> treeNodeData, Map<String, Object> context, Identity identity, Locale locale, String path) throws Exception {
        String parentPageId = parentJsonData.getParentPageId();
        if (parentPageId != null && !parentPageId.equals(rootNode.getNoteId())) {
            JsonNodeData parentNode = this.findParent(parentPageId, treeNodeData);
            if (parentNode == null) {
                Page parent = this.noteService.getNoteById(parentJsonData.getParentPageId());
                PageTreeNode pageTreeNode = new PageTreeNode(parent);
                Boolean canEdit = context != null && context.get("canEdit") != null && (Boolean)context.get("canEdit") != false;
                parentNode = TreeUtils.toJsonNodeData(pageTreeNode, path, parent, context, canEdit, true, identity, locale, this.noteService);
            }
            this.addChildIfNoExists(parentNode, parentJsonData);
            treeNodeData.add(parentNode);
            this.buildPageAscendants(rootNode, parentNode, treeNodeData, context, identity, locale, path);
        } else {
            this.addChildIfNoExists(rootNode, parentJsonData);
        }
    }

    private JsonNodeData findParent(String parentId, List<JsonNodeData> list) {
        return list.stream().filter(obj -> obj.getNoteId().equals(parentId)).findFirst().orElse(null);
    }

    private void addChildIfNoExists(JsonNodeData parent, JsonNodeData child) {
        if (this.findParent(child.getNoteId(), parent.getChildren()) == null) {
            parent.addChildren(List.of(child));
        }
    }

    static {
        ILLUSTRATION_CACHE_CONTROL.setMaxAge(31536000);
    }
}

