/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import jakarta.annotation.PostConstruct;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
@Profile(value={"analytics"})
public class TermsAndConditionsAnalyticsListener
extends Listener<String, Object> {
    private static final Log LOG = ExoLogger.getLogger(TermsAndConditionsAnalyticsListener.class);
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        this.listenerService.addListener("terms.and.conditions.accepted", (ListenerBase)this);
    }

    public void onEvent(Event<String, Object> event) {
        long userId = AnalyticsUtils.getUserIdentityId((String)((String)event.getSource()));
        if (userId <= 0L) {
            LOG.debug("User not found in state, username= {} ", new Object[]{event.getSource()});
            return;
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("social");
        statisticData.setSubModule("terms");
        statisticData.setOperation("acceptTermsAndConditions");
        statisticData.setUserId(userId);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

